/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.common.block;

import com.luxtracon.floralis.common.helper.FloralisHelper;
import com.luxtracon.floralis.common.registry.FloralisBlockStateProperties;
import com.luxtracon.floralis.common.registry.FloralisVoxelShapes;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CactusCropBlock
extends CropBlock {
    public CactusCropBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FloralisBlockStateProperties.AGE, (Comparable)Integer.valueOf(0)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FloralisBlockStateProperties.AGE});
    }

    public void entityInside(BlockState pBlockState, Level pLevel, BlockPos pBlockPos, Entity pEntity, InsideBlockEffectApplier pInsideBlockEffectApplier) {
        Level level = pEntity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((Integer)pBlockState.getValue((Property)FloralisBlockStateProperties.AGE) > 1) {
                pEntity.hurtServer(serverLevel, pLevel.damageSources().cactus(), 1.0f);
            }
        }
    }

    public boolean canSurvive(BlockState pBlockState, LevelReader pLevelReader, BlockPos pBlockPos) {
        return FloralisHelper.maintain(pBlockPos.below(), pLevelReader, (TagKey<Block>)BlockTags.SAND) || FloralisHelper.maintain(pBlockPos.below(), pLevelReader, (TagKey<Block>)Tags.Blocks.VILLAGER_FARMLANDS);
    }

    public int getBonemealAgeIncrease(Level pLevel) {
        return 1;
    }

    public int getMaxAge() {
        return 3;
    }

    public IntegerProperty getAgeProperty() {
        return FloralisBlockStateProperties.AGE;
    }

    public ItemLike getBaseSeedId() {
        return this;
    }

    public PathType getBlockPathType(BlockState pBlockState, BlockGetter pBlockGetter, BlockPos pBlockPos, @Nullable Mob pMob) {
        return (Integer)pBlockState.getValue((Property)FloralisBlockStateProperties.AGE) > 1 ? PathType.DAMAGE_OTHER : PathType.WALKABLE;
    }

    public VoxelShape getShape(BlockState pBlockState, BlockGetter pBlockGetter, BlockPos pBlockPos, CollisionContext pCollisionContext) {
        return FloralisVoxelShapes.CACTUS_CROP.get((Integer)pBlockState.getValue((Property)FloralisBlockStateProperties.AGE));
    }
}

