/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.data.provider.tags;

import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloralisBiomeTagsProvider
extends BiomeTagsProvider {
    public static final TagKey<Biome> HAS_CACTUS = FloralisBiomeTagsProvider.floralisKey("has_cactus");

    public FloralisBiomeTagsProvider(PackOutput pPackOutput, CompletableFuture<HolderLookup.Provider> pProvider, String pId) {
        super(pPackOutput, pProvider, pId);
    }

    public void addTags(HolderLookup.Provider pProvider) {
        this.tag(HAS_CACTUS).add(Biomes.BADLANDS).add(Biomes.ERODED_BADLANDS).add(Biomes.WOODED_BADLANDS).add(Biomes.DESERT);
    }

    public String getName() {
        return "Biome Tags";
    }

    public static TagKey<Biome> cKey(String pName) {
        return FloralisBiomeTagsProvider.createKey("c:" + pName);
    }

    public static TagKey<Biome> floralisKey(String pName) {
        return FloralisBiomeTagsProvider.createKey("floralis:" + pName);
    }

    public static TagKey<Biome> industrialforegoingKey(String pName) {
        return FloralisBiomeTagsProvider.createKey("industrialforegoing:" + pName);
    }

    public static TagKey<Biome> minecraftKey(String pName) {
        return FloralisBiomeTagsProvider.createKey("minecraft:" + pName);
    }

    public static TagKey<Biome> neoforgeKey(String pName) {
        return FloralisBiomeTagsProvider.createKey("neoforge:" + pName);
    }

    public static TagKey<Biome> createKey(String pName) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)pName));
    }
}

