/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.data.provider;

import com.luxtracon.floralis.common.registry.FloralisItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloralisRecipeProvider
extends RecipeProvider {
    public FloralisRecipeProvider(HolderLookup.Provider pProvider, RecipeOutput pRecipeOutput) {
        super(pProvider, pRecipeOutput);
    }

    public void buildRecipes() {
        this.shaped();
        this.shapeless();
        this.smelting();
    }

    public void shaped() {
        this.shaped(1, (Item)FloralisItems.WHITE_DYE_BLOCK.get(), Items.WHITE_DYE);
        this.shaped(1, (Item)FloralisItems.LIGHT_GRAY_DYE_BLOCK.get(), Items.LIGHT_GRAY_DYE);
        this.shaped(1, (Item)FloralisItems.GRAY_DYE_BLOCK.get(), Items.GRAY_DYE);
        this.shaped(1, (Item)FloralisItems.BLACK_DYE_BLOCK.get(), Items.BLACK_DYE);
        this.shaped(1, (Item)FloralisItems.BROWN_DYE_BLOCK.get(), Items.BROWN_DYE);
        this.shaped(1, (Item)FloralisItems.RED_DYE_BLOCK.get(), Items.RED_DYE);
        this.shaped(1, (Item)FloralisItems.ORANGE_DYE_BLOCK.get(), Items.ORANGE_DYE);
        this.shaped(1, (Item)FloralisItems.YELLOW_DYE_BLOCK.get(), Items.YELLOW_DYE);
        this.shaped(1, (Item)FloralisItems.LIME_DYE_BLOCK.get(), Items.LIME_DYE);
        this.shaped(1, (Item)FloralisItems.GREEN_DYE_BLOCK.get(), Items.GREEN_DYE);
        this.shaped(1, (Item)FloralisItems.CYAN_DYE_BLOCK.get(), Items.CYAN_DYE);
        this.shaped(1, (Item)FloralisItems.LIGHT_BLUE_DYE_BLOCK.get(), Items.LIGHT_BLUE_DYE);
        this.shaped(1, (Item)FloralisItems.BLUE_DYE_BLOCK.get(), Items.BLUE_DYE);
        this.shaped(1, (Item)FloralisItems.PURPLE_DYE_BLOCK.get(), Items.PURPLE_DYE);
        this.shaped(1, (Item)FloralisItems.MAGENTA_DYE_BLOCK.get(), Items.MAGENTA_DYE);
        this.shaped(1, (Item)FloralisItems.PINK_DYE_BLOCK.get(), Items.PINK_DYE);
        this.shaped(1, (Item)FloralisItems.PLANT_FIBERS_BLOCK.get(), (Item)FloralisItems.PLANT_FIBERS.get());
    }

    public void shapeless() {
        this.shapeless(9, Items.WHITE_DYE, (Item)FloralisItems.WHITE_DYE_BLOCK.get());
        this.shapeless(9, Items.LIGHT_GRAY_DYE, (Item)FloralisItems.LIGHT_GRAY_DYE_BLOCK.get());
        this.shapeless(9, Items.GRAY_DYE, (Item)FloralisItems.GRAY_DYE_BLOCK.get());
        this.shapeless(9, Items.BLACK_DYE, (Item)FloralisItems.BLACK_DYE_BLOCK.get());
        this.shapeless(9, Items.BROWN_DYE, (Item)FloralisItems.BROWN_DYE_BLOCK.get());
        this.shapeless(9, Items.RED_DYE, (Item)FloralisItems.RED_DYE_BLOCK.get());
        this.shapeless(9, Items.ORANGE_DYE, (Item)FloralisItems.ORANGE_DYE_BLOCK.get());
        this.shapeless(9, Items.YELLOW_DYE, (Item)FloralisItems.YELLOW_DYE_BLOCK.get());
        this.shapeless(9, Items.LIME_DYE, (Item)FloralisItems.LIME_DYE_BLOCK.get());
        this.shapeless(9, Items.GREEN_DYE, (Item)FloralisItems.GREEN_DYE_BLOCK.get());
        this.shapeless(9, Items.CYAN_DYE, (Item)FloralisItems.CYAN_DYE_BLOCK.get());
        this.shapeless(9, Items.LIGHT_BLUE_DYE, (Item)FloralisItems.LIGHT_BLUE_DYE_BLOCK.get());
        this.shapeless(9, Items.BLUE_DYE, (Item)FloralisItems.BLUE_DYE_BLOCK.get());
        this.shapeless(9, Items.PURPLE_DYE, (Item)FloralisItems.PURPLE_DYE_BLOCK.get());
        this.shapeless(9, Items.MAGENTA_DYE, (Item)FloralisItems.MAGENTA_DYE_BLOCK.get());
        this.shapeless(9, Items.PINK_DYE, (Item)FloralisItems.PINK_DYE_BLOCK.get());
        this.shapeless(9, (Item)FloralisItems.PLANT_FIBERS.get(), (Item)FloralisItems.PLANT_FIBERS_BLOCK.get());
    }

    public void smelting() {
        this.smelting(0.1f, 200, Items.WHITE_DYE, (Item)FloralisItems.WHITE_PETALS.get());
        this.smelting(0.1f, 200, Items.LIGHT_GRAY_DYE, (Item)FloralisItems.LIGHT_GRAY_PETALS.get());
        this.smelting(0.1f, 200, Items.GRAY_DYE, (Item)FloralisItems.GRAY_PETALS.get());
        this.smelting(0.1f, 200, Items.BLACK_DYE, (Item)FloralisItems.BLACK_PETALS.get());
        this.smelting(0.1f, 200, Items.BROWN_DYE, (Item)FloralisItems.BROWN_PETALS.get());
        this.smelting(0.1f, 200, Items.RED_DYE, (Item)FloralisItems.RED_PETALS.get());
        this.smelting(0.1f, 200, Items.ORANGE_DYE, (Item)FloralisItems.ORANGE_PETALS.get());
        this.smelting(0.1f, 200, Items.YELLOW_DYE, (Item)FloralisItems.YELLOW_PETALS.get());
        this.smelting(0.1f, 200, Items.LIME_DYE, (Item)FloralisItems.LIME_PETALS.get());
        this.smelting(0.1f, 200, Items.GREEN_DYE, (Item)FloralisItems.GREEN_PETALS.get());
        this.smelting(0.1f, 200, Items.CYAN_DYE, (Item)FloralisItems.CYAN_PETALS.get());
        this.smelting(0.1f, 200, Items.LIGHT_BLUE_DYE, (Item)FloralisItems.LIGHT_BLUE_PETALS.get());
        this.smelting(0.1f, 200, Items.BLUE_DYE, (Item)FloralisItems.BLUE_PETALS.get());
        this.smelting(0.1f, 200, Items.PURPLE_DYE, (Item)FloralisItems.PURPLE_PETALS.get());
        this.smelting(0.1f, 200, Items.MAGENTA_DYE, (Item)FloralisItems.MAGENTA_PETALS.get());
        this.smelting(0.1f, 200, Items.PINK_DYE, (Item)FloralisItems.PINK_PETALS.get());
    }

    public void shaped(int pAmount, Item pResult, Item pResource) {
        this.shaped(RecipeCategory.MISC, (ItemLike)pResult, pAmount).define(Character.valueOf('A'), (ItemLike)pResource).pattern("AAA").pattern("AAA").pattern("AAA").unlockedBy(this.name(pResource), this.has((ItemLike)pResource)).save(this.output, this.key(pResult, pResource));
    }

    public void shapeless(int pAmount, Item pResult, Item pResource) {
        this.shapeless(RecipeCategory.MISC, (ItemLike)pResult, pAmount).requires((ItemLike)pResource).unlockedBy(this.name(pResource), this.has((ItemLike)pResource)).save(this.output, this.key(pResult, pResource));
    }

    public void smelting(float pExperience, int pTime, Item pResult, Item pResource) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)pResource), (RecipeCategory)RecipeCategory.MISC, (ItemLike)pResult, (float)pExperience, (int)pTime).unlockedBy(this.name(pResource), this.has((ItemLike)pResource)).save(this.output, this.key("smelting", pResult));
    }

    public ResourceKey<Recipe<?>> key(Item pResult, Item pResource) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"floralis", (String)(BuiltInRegistries.ITEM.getKey((Object)pResult).getPath() + "_from_" + BuiltInRegistries.ITEM.getKey((Object)pResource).getPath())));
    }

    public ResourceKey<Recipe<?>> key(String pFrom, Item pResult) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"floralis", (String)(BuiltInRegistries.ITEM.getKey((Object)pResult).getPath() + "_from_" + pFrom)));
    }

    public String name(Item pItem) {
        return "has_" + String.valueOf(pItem);
    }
}

