/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.data.provider.model;

import com.luxtracon.floralis.common.registry.FloralisBlocks;
import com.luxtracon.floralis.common.registry.FloralisTextureSlots;
import com.luxtracon.floralis.data.model.CactusBushModel;
import com.luxtracon.floralis.data.model.CactusCropModel;
import com.luxtracon.floralis.data.model.DyeBlockModel;
import com.luxtracon.floralis.data.model.FlowerBushModel;
import com.luxtracon.floralis.data.model.FlowerCropModel;
import com.luxtracon.floralis.data.model.PlantFibersBlockModel;
import com.luxtracon.floralis.data.model.PottedCactusModel;
import com.luxtracon.floralis.data.model.PottedFlowerModel;
import com.luxtracon.floralis.data.provider.model.FloralisModelProvider;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloralisBlockModelProvider {
    public static void register(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.provider(pBlockModelGenerators);
        FloralisBlockModelProvider.template(pBlockModelGenerators);
    }

    public static void provider(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.cactusBush(pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop(pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock(pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush(pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop(pBlockModelGenerators);
        FloralisBlockModelProvider.plantFibersBlock(pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus(pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower(pBlockModelGenerators);
    }

    public static void template(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.cactusBushModel(pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCropModel(pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlockModel(pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBushModel(pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCropModel(pBlockModelGenerators);
        FloralisBlockModelProvider.plantFibersBlockModel(pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactusModel(pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlowerModel(pBlockModelGenerators);
    }

    public static void cactusBush(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.WHITE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.LIGHT_GRAY_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.GRAY_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.BLACK_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.BROWN_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.RED_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.ORANGE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.YELLOW_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.LIME_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.GREEN_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.CYAN_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.LIGHT_BLUE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.BLUE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.PURPLE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.MAGENTA_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusBush((Block)FloralisBlocks.PINK_CACTUS.get(), pBlockModelGenerators);
    }

    public static void cactusCrop(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.WHITE_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.LIGHT_GRAY_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.GRAY_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.BLACK_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.BROWN_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.RED_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.ORANGE_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.YELLOW_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.LIME_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.GREEN_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.CYAN_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.LIGHT_BLUE_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.BLUE_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.PURPLE_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.MAGENTA_CACTUS_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.cactusCrop((Block)FloralisBlocks.PINK_CACTUS_CROP.get(), pBlockModelGenerators);
    }

    public static void dyeBlock(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.WHITE_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.LIGHT_GRAY_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.GRAY_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.BLACK_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.BROWN_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.RED_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.ORANGE_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.YELLOW_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.LIME_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.GREEN_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.CYAN_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.LIGHT_BLUE_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.BLUE_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.PURPLE_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.MAGENTA_DYE_BLOCK.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.dyeBlock((Block)FloralisBlocks.PINK_DYE_BLOCK.get(), pBlockModelGenerators);
    }

    public static void flowerBush(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.WHITE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.LIGHT_GRAY_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.GRAY_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.BLACK_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.BROWN_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.RED_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.ORANGE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.YELLOW_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.LIME_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.GREEN_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.CYAN_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.LIGHT_BLUE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.BLUE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.PURPLE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.MAGENTA_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerBush((Block)FloralisBlocks.PINK_FLOWER.get(), pBlockModelGenerators);
    }

    public static void flowerCrop(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.WHITE_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.LIGHT_GRAY_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.GRAY_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.BLACK_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.BROWN_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.RED_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.ORANGE_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.YELLOW_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.LIME_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.GREEN_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.CYAN_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.LIGHT_BLUE_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.BLUE_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.PURPLE_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.MAGENTA_FLOWER_CROP.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.flowerCrop((Block)FloralisBlocks.PINK_FLOWER_CROP.get(), pBlockModelGenerators);
    }

    public static void plantFibersBlock(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.plantFibersBlock((Block)FloralisBlocks.PLANT_FIBERS_BLOCK.get(), pBlockModelGenerators);
    }

    public static void pottedCactus(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_WHITE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_LIGHT_GRAY_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_GRAY_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_BLACK_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_BROWN_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_RED_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_ORANGE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_YELLOW_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_LIME_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_GREEN_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_CYAN_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_LIGHT_BLUE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_BLUE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_PURPLE_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_MAGENTA_CACTUS.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedCactus((Block)FloralisBlocks.POTTED_PINK_CACTUS.get(), pBlockModelGenerators);
    }

    public static void pottedFlower(BlockModelGenerators pBlockModelGenerators) {
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_WHITE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_LIGHT_GRAY_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_GRAY_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_BLACK_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_BROWN_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_RED_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_ORANGE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_YELLOW_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_LIME_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_GREEN_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_CYAN_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_LIGHT_BLUE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_BLUE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_PURPLE_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_MAGENTA_FLOWER.get(), pBlockModelGenerators);
        FloralisBlockModelProvider.pottedFlower((Block)FloralisBlocks.POTTED_PINK_FLOWER.get(), pBlockModelGenerators);
    }

    public static void cactusBush(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_cactus_bush")).build().create(FloralisModelProvider.blockFile(pBlock), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock)).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
    }

    public static void cactusCrop(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_0")).build().create(FloralisModelProvider.blockFile(pBlock, "0"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_1")).build().create(FloralisModelProvider.blockFile(pBlock, "1"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_2")).build().create(FloralisModelProvider.blockFile(pBlock, "2"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_3")).build().create(FloralisModelProvider.blockFile(pBlock, "3"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
    }

    public static void dyeBlock(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_dye_block")).build().create(FloralisModelProvider.blockFile(pBlock), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock)).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile(pBlock)), pBlockModelGenerators.modelOutput);
    }

    public static void flowerBush(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_flower_bush")).build().create(FloralisModelProvider.blockFile(pBlock), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock)).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
    }

    public static void flowerCrop(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_flower_crop_0")).build().create(FloralisModelProvider.blockFile(pBlock, "0"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_flower_crop_1")).build().create(FloralisModelProvider.blockFile(pBlock, "1"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_flower_crop_2")).build().create(FloralisModelProvider.blockFile(pBlock, "2"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_flower_crop_3")).build().create(FloralisModelProvider.blockFile(pBlock, "3"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "_crop", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
    }

    public static void plantFibersBlock(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_plant_fibers_block")).build().create(FloralisModelProvider.blockFile(pBlock), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock)).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_plant_fibers_block_horizontal")).build().create(FloralisModelProvider.blockFile(pBlock, "horizontal"), new TextureMapping().putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock)).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("floralis", "particle")), pBlockModelGenerators.modelOutput);
    }

    public static void pottedCactus(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_potted_cactus")).build().create(FloralisModelProvider.blockFile(pBlock), new TextureMapping().putForced(FloralisTextureSlots.DIRT, FloralisModelProvider.blockFile("minecraft", "dirt")).putForced(FloralisTextureSlots.FLOWER_POT, FloralisModelProvider.blockFile("minecraft", "flower_pot")).putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "potted_", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("minecraft", "flower_pot")), pBlockModelGenerators.modelOutput);
    }

    public static void pottedFlower(Block pBlock, BlockModelGenerators pBlockModelGenerators) {
        ExtendedModelTemplateBuilder.builder().parent(FloralisModelProvider.blockFile("floralis", "template_potted_flower")).build().create(FloralisModelProvider.blockFile(pBlock), new TextureMapping().putForced(FloralisTextureSlots.DIRT, FloralisModelProvider.blockFile("minecraft", "dirt")).putForced(FloralisTextureSlots.FLOWER_POT, FloralisModelProvider.blockFile("minecraft", "flower_pot")).putForced(FloralisTextureSlots.TEXTURE, FloralisModelProvider.blockFile(pBlock, "potted_", "")).putForced(FloralisTextureSlots.PARTICLE, FloralisModelProvider.blockFile("minecraft", "flower_pot")), pBlockModelGenerators.modelOutput);
    }

    public static void cactusBushModel(BlockModelGenerators pBlockModelGenerators) {
        CactusBushModel.template().create(FloralisModelProvider.blockFile("floralis", "template_cactus_bush"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }

    public static void cactusCropModel(BlockModelGenerators pBlockModelGenerators) {
        CactusCropModel.template0().create(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_0"), new TextureMapping(), pBlockModelGenerators.modelOutput);
        CactusCropModel.template1().create(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_1"), new TextureMapping(), pBlockModelGenerators.modelOutput);
        CactusCropModel.template2().create(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_2"), new TextureMapping(), pBlockModelGenerators.modelOutput);
        CactusCropModel.template3().create(FloralisModelProvider.blockFile("floralis", "template_cactus_crop_3"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }

    public static void dyeBlockModel(BlockModelGenerators pBlockModelGenerators) {
        DyeBlockModel.template().create(FloralisModelProvider.blockFile("floralis", "template_dye_block"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }

    public static void flowerBushModel(BlockModelGenerators pBlockModelGenerators) {
        FlowerBushModel.template().create(FloralisModelProvider.blockFile("floralis", "template_flower_bush"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }

    public static void flowerCropModel(BlockModelGenerators pBlockModelGenerators) {
        FlowerCropModel.template0().create(FloralisModelProvider.blockFile("floralis", "template_flower_crop_0"), new TextureMapping(), pBlockModelGenerators.modelOutput);
        FlowerCropModel.template1().create(FloralisModelProvider.blockFile("floralis", "template_flower_crop_1"), new TextureMapping(), pBlockModelGenerators.modelOutput);
        FlowerCropModel.template2().create(FloralisModelProvider.blockFile("floralis", "template_flower_crop_2"), new TextureMapping(), pBlockModelGenerators.modelOutput);
        FlowerCropModel.template3().create(FloralisModelProvider.blockFile("floralis", "template_flower_crop_3"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }

    public static void plantFibersBlockModel(BlockModelGenerators pBlockModelGenerators) {
        PlantFibersBlockModel.template().create(FloralisModelProvider.blockFile("floralis", "template_plant_fibers_block"), new TextureMapping(), pBlockModelGenerators.modelOutput);
        PlantFibersBlockModel.templateHorizontal().create(FloralisModelProvider.blockFile("floralis", "template_plant_fibers_block_horizontal"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }

    public static void pottedCactusModel(BlockModelGenerators pBlockModelGenerators) {
        PottedCactusModel.template().create(FloralisModelProvider.blockFile("floralis", "template_potted_cactus"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }

    public static void pottedFlowerModel(BlockModelGenerators pBlockModelGenerators) {
        PottedFlowerModel.template().create(FloralisModelProvider.blockFile("floralis", "template_potted_flower"), new TextureMapping(), pBlockModelGenerators.modelOutput);
    }
}

