/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.common.block;

import com.luxtracon.floralis.common.helper.FloralisHelper;
import com.luxtracon.floralis.common.registry.FloralisBlockStateProperties;
import com.luxtracon.floralis.common.registry.FloralisVoxelShapes;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CactusCropBlock
extends CropBlock {
    public CactusCropBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FloralisBlockStateProperties.AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean mayPlaceOn(BlockState pBlockState, BlockGetter pBlockGetter, BlockPos pBlockPos) {
        return pBlockState.is(BlockTags.SAND);
    }

    public int getBonemealAgeIncrease(Level pLevel) {
        return Mth.nextInt((RandomSource)pLevel.getRandom(), (int)1, (int)3);
    }

    public int getMaxAge() {
        return 5;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FloralisBlockStateProperties.AGE});
    }

    public void entityInside(BlockState pBlockState, Level pLevel, BlockPos pBlockPos, Entity pEntity) {
        super.entityInside(pBlockState, pLevel, pBlockPos, pEntity);
        FloralisHelper.hurt(pLevel.damageSources().cactus(), pEntity, 1.0f);
    }

    public IntegerProperty getAgeProperty() {
        return FloralisBlockStateProperties.AGE;
    }

    public ItemLike getBaseSeedId() {
        return this;
    }

    public PathType getBlockPathType(BlockState pBlockState, BlockGetter pBlockGetter, BlockPos pBlockPos, @Nullable Mob pMob) {
        return (Integer)pBlockState.getValue((Property)FloralisBlockStateProperties.AGE) >= 3 ? PathType.DAMAGE_OTHER : PathType.WALKABLE;
    }

    public VoxelShape getShape(BlockState pBlockState, BlockGetter pBlockGetter, BlockPos pBlockPos, CollisionContext pCollisionContext) {
        return FloralisVoxelShapes.CACTUS_CROP.get((Integer)pBlockState.getValue((Property)FloralisBlockStateProperties.AGE));
    }
}

