package me.pajic.zombieimprovements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.zombieimprovements.ZombieImprovements;
import me.pajic.zombieimprovements.util.ZombieExtension;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
//?} else {
/*import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
*///?}

@Mixin(class_1642.class)
public abstract class ZombieMixin extends class_1308 implements ZombieExtension {
    protected ZombieMixin(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
    }

    @SuppressWarnings("WrongEntityDataParameterClass")
    @Unique private static final class_2940<Boolean> LEADER = class_2945.method_12791(
            class_1642.class, class_2943.field_13323
    );
    @Unique private int soundTimer = 0;
    @Unique private class_1642 soundSource = null;
    @Unique private /*? if 1.21.1 {*/class_3730/*?} else {*//*EntitySpawnReason*//*?}*/ spawnType = null;

    @Inject(
            method = /*? if 1.21.1 {*/"hurt"/*?} else {*//*"hurtServer"*//*?}*/,
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V"
            )
    )
    private void playSoundOnReinforcementsSpawn(
            //? if > 1.21.1
            /*ServerLevel level,*/
            class_1282 source,
            float amount,
            CallbackInfoReturnable<Boolean> cir,
            @Local class_1642 zombie
    ) {
        if (ZombieImprovements.CONFIG.reinforcementSpawnSounds.get()) {
            soundTimer = 40;
            soundSource = zombie;
        }
    }

    @Inject(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/monster/Zombie;isUnderWaterConverting()Z"
            )
    )
    private void tickReinforcementSound(CallbackInfo ci) {
        if (soundTimer > 0 && soundSource != null) {
            if (soundTimer % 8 == 0) method_5783(
					soundSource.method_25936().method_26231().method_10595(),
					ZombieImprovements.CONFIG.spawnSoundVolume.get(), 1
			);
            soundTimer--;
        }
    }

    @Inject(
            method = "handleAttributes",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/monster/Zombie;setCanBreakDoors(Z)V"
            )
    )
    private void markLeader(float difficulty, CallbackInfo ci) {
        method_6025(method_6063());
        field_6011.method_12778(LEADER, true);
		ZombieImprovements.debugLog("Leader {} spawned at {} {} {}", method_5476().getString(), method_23317(), method_23318(), method_23321());
    }

    @Inject(
            method = "finalizeSpawn",
            at = @At("HEAD")
    )
    private void getSpawnReason(class_5425 level, class_1266 difficulty, /*? if 1.21.1 {*/class_3730/*?} else {*//*EntitySpawnReason*//*?}*/ spawnType, class_1315 spawnGroupData, CallbackInfoReturnable<class_1315> cir) {
        this.spawnType = spawnType;
    }

    @ModifyExpressionValue(
            method = "handleAttributes",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/RandomSource;nextFloat()F"
            )
    )
    private float noLeaderIfFromSpawner(float original) {
        return ZombieImprovements.CONFIG.noLeaderFromSpawners.get() && ZombieImprovements.isFromSpawner(spawnType) ? 1 : original;
    }

    @WrapWithCondition(
            method = "handleAttributes",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;addOrReplacePermanentModifier(Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V",
                    ordinal = 2
            )
    )
    private boolean noReinforcementsIfFromSpawner(class_1324 instance, class_1322 modifier) {
        return !ZombieImprovements.isFromSpawner(spawnType) || !ZombieImprovements.CONFIG.noReinforcementsFromSpawners.get();
    }

    @WrapWithCondition(
            method = "handleAttributes",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/monster/Zombie;randomizeReinforcementsChance()V"
            )
    )
    private boolean noReinforcementsIfFromSpawner(class_1642 instance) {
        return !ZombieImprovements.isFromSpawner(spawnType) || !ZombieImprovements.CONFIG.noReinforcementsFromSpawners.get();
    }

	@ModifyExpressionValue(
			method = "handleAttributes",
			at = @At(
					value = "CONSTANT",
					args = "floatValue=0.05"
			)
	)
	private float modifyMaxSpawnChance(float original) {
		return ZombieImprovements.CONFIG.leaderMaxSpawnChance.get();
	}

    @ModifyExpressionValue(
            method = /*? if 1.21.1 {*/"hurt"/*?} else {*//*"hurtServer"*//*?}*/,
            at = @At(
                    value = "INVOKE",
                    //? if 1.21.1
                    target = "Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z"
                    //? if > 1.21.1
                    /*target = "Lnet/minecraft/server/level/ServerLevel;isSpawningMonsters()Z"*/
            )
    )
    private boolean onlyLeaderSpawnsReinforcements(boolean original) {
        return ZombieImprovements.CONFIG.onlyLeaderSpawnsReinforcements.get() ? field_6011.method_12789(LEADER) : original;
    }

    //? if 1.21.1 {
    @SuppressWarnings("unchecked")
    @WrapOperation(
            method = "hurt",
            at = @At(
                    value = "NEW",
                    target = "(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/monster/Zombie;"
            )
    )
    private class_1642 fixIncorrectReinforcementSpawn(class_1937 level, Operation<class_1642> original, @Cancellable CallbackInfoReturnable<Boolean> cir) {
        class_1299<? extends class_1642> entityType = (class_1299<? extends class_1642>) method_5864();
        class_1642 zombie = entityType.method_5883(level);
        if (zombie == null) {
            cir.setReturnValue(true);
            return null;
        }
        else return zombie;
    }
    //?}

    @Inject(
            method = "defineSynchedData",
            at = @At("TAIL")
    )
    private void defineLeaderData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(LEADER, false);
    }

    //? if 1.21.1 {
    @Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void saveLeaderData(class_2487 compound, CallbackInfo ci) {
        compound.method_10556("Leader", field_6011.method_12789(LEADER));
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void readLeaderData(class_2487 compound, CallbackInfo ci) {
        field_6011.method_12778(LEADER, compound.method_10577("Leader"));
    }
    //?} else {
    /*@Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void saveLeaderData(ValueOutput output, CallbackInfo ci) {
        output.putBoolean("Leader", entityData.get(LEADER));
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void readLeaderData(ValueInput input, CallbackInfo ci) {
        entityData.set(LEADER, input.getBooleanOr("Leader", false));
    }
    *///?}

    @Override
    public boolean zi$isLeader() {
        return field_6011.method_12789(LEADER);
    }
}
