/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.zombieimprovements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.zombieimprovements.ZombieImprovements;
import me.pajic.zombieimprovements.util.AttachmentUtil;
import me.pajic.zombieimprovements.util.ModUtil;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Mob {
    @Unique
    private int soundTimer = 0;
    @Unique
    private Zombie soundSource = null;
    @Unique
    private MobSpawnType spawnType = null;

    protected ZombieMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V")})
    private void playSoundOnReinforcementsSpawn(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir, @Local Zombie zombie) {
        if (((Boolean)ZombieImprovements.CONFIG.reinforcementSpawnSounds.get()).booleanValue()) {
            this.soundTimer = 40;
            this.soundSource = zombie;
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Zombie;isUnderWaterConverting()Z")})
    private void tickReinforcementSound(CallbackInfo ci) {
        if (this.soundTimer > 0 && this.soundSource != null) {
            if (this.soundTimer % 8 == 0) {
                this.playSound(this.soundSource.getBlockStateOn().getSoundType().getBreakSound(), ((Float)ZombieImprovements.CONFIG.spawnSoundVolume.get()).floatValue(), 1.0f);
            }
            --this.soundTimer;
        }
    }

    @Inject(method={"handleAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Zombie;setCanBreakDoors(Z)V")})
    private void markLeader(float difficulty, CallbackInfo ci) {
        this.heal(this.getMaxHealth());
        AttachmentUtil.setLeader((Entity)((Zombie)this));
        ZombieImprovements.debugLog("Leader {} spawned at {} {} {}", this.getDisplayName().getString(), this.getX(), this.getY(), this.getZ());
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void getSpawnReason(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.spawnType = spawnType;
    }

    @ModifyExpressionValue(method={"handleAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;nextFloat()F")})
    private float noLeaderIfFromSpawner(float original) {
        return (Boolean)ZombieImprovements.CONFIG.noLeaderFromSpawners.get() != false && ModUtil.isFromSpawner(this.spawnType) ? 1.0f : original;
    }

    @WrapWithCondition(method={"handleAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;addOrReplacePermanentModifier(Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V", ordinal=2)})
    private boolean noReinforcementsIfFromSpawner(AttributeInstance instance, AttributeModifier modifier) {
        return !ModUtil.isFromSpawner(this.spawnType) || (Boolean)ZombieImprovements.CONFIG.noReinforcementsFromSpawners.get() == false;
    }

    @WrapWithCondition(method={"handleAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Zombie;randomizeReinforcementsChance()V")})
    private boolean noReinforcementsIfFromSpawner(Zombie instance) {
        return !ModUtil.isFromSpawner(this.spawnType) || (Boolean)ZombieImprovements.CONFIG.noReinforcementsFromSpawners.get() == false;
    }

    @ModifyExpressionValue(method={"handleAttributes"}, at={@At(value="CONSTANT", args={"floatValue=0.05"})})
    private float modifyMaxSpawnChance(float original) {
        return ((Float)ZombieImprovements.CONFIG.leaderMaxSpawnChance.get()).floatValue();
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z")})
    private boolean onlyLeaderSpawnsReinforcements(boolean original) {
        return (Boolean)ZombieImprovements.CONFIG.onlyLeaderSpawnsReinforcements.get() != false ? AttachmentUtil.isLeader((Entity)((Zombie)this)) : original;
    }

    @WrapOperation(method={"hurt"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/monster/Zombie;")})
    private Zombie fixIncorrectReinforcementSpawn(Level level, Operation<Zombie> original, @Cancellable CallbackInfoReturnable<Boolean> cir) {
        EntityType entityType = this.getType();
        Zombie zombie = (Zombie)entityType.create(level);
        if (zombie == null) {
            cir.setReturnValue((Object)true);
            return null;
        }
        return zombie;
    }
}

