/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we;

import com.kyfexuwu.m3we.lua.CustomScript;
import com.kyfexuwu.m3we.lua.LuaFunctionalInterface;
import com.kyfexuwu.m3we.lua.LuaSurfaceObj;
import com.kyfexuwu.m3we.lua.Translations;
import com.kyfexuwu.m3we.m3we;
import java.lang.reflect.Array;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class Utils {
    public static void forEach(LuaValue table, BiFunction<LuaValue, LuaValue, Boolean> function) {
        Varargs n;
        LuaValue key = LuaValue.NIL;
        while (!(key = (n = table.next(key)).arg1()).isnil() && function.apply(key, n.arg(2)).booleanValue()) {
        }
    }

    public static LuaValue toLuaValue(Object value) {
        if (value instanceof LuaValue) {
            return (LuaValue)value;
        }
        if (value == null) {
            return LuaValue.NIL;
        }
        if (value instanceof Boolean) {
            return LuaValue.valueOf((boolean)((Boolean)value));
        }
        if (value instanceof Integer) {
            return LuaValue.valueOf((int)((Integer)value));
        }
        if (value instanceof Double || value instanceof Float) {
            return LuaValue.valueOf((double)((Double)value));
        }
        if (value instanceof String) {
            return LuaValue.valueOf((String)((String)value));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            LuaTable cleanedToReturn = new LuaTable();
            for (int i = 0; i < length; ++i) {
                cleanedToReturn.set(i, Utils.toLuaValue(Array.get(value, i)));
            }
            return cleanedToReturn;
        }
        if (LuaFunctionalInterface.isFunctionalInterface(value.getClass())) {
            return LuaFunctionalInterface.createFunction(value);
        }
        return new LuaSurfaceObj(value);
    }

    public static Object toObject(LuaValue value) {
        switch (value.typename()) {
            case "boolean": {
                return value.toboolean();
            }
            case "number": {
                return value.todouble();
            }
            case "string": {
                return value.toString();
            }
            case "table": {
                Object[] toReturn = new Object[value.length()];
                for (int i = 0; i < toReturn.length; ++i) {
                    toReturn[i] = Utils.toObject(value.get(i));
                }
                return toReturn;
            }
            case "surfaceObj": {
                return ((LuaSurfaceObj)value).object;
            }
        }
        return null;
    }

    public static <T> T toObjectTyped(LuaValue value) {
        if (value.typename().equals("number")) {
            try {
                return (T)Integer.valueOf(value.toint());
            }
            catch (Exception exception) {
                try {
                    return (T)Float.valueOf(value.tofloat());
                }
                catch (Exception exception2) {
                    try {
                        return (T)Double.valueOf(value.todouble());
                    }
                    catch (Exception exception3) {
                        try {
                            return (T)Long.valueOf(value.tolong());
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        Object toReturn = Utils.toObject(value);
        try {
            return (T)toReturn;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LuaTable cloneTable(LuaTable table, LuaTable cloneInto) {
        LuaTable finalCloneInto = cloneInto == null ? new LuaTable() : cloneInto;
        Utils.forEach((LuaValue)table, (key, value) -> {
            if (value instanceof LuaTable) {
                value = Utils.cloneTable(table, null);
            }
            finalCloneInto.set(key.strvalue().checkjstring(), value);
            return true;
        });
        return finalCloneInto;
    }

    public static <T> T tryAndExecute(T dfault, CustomScript scriptContainer, String funcString, Object[] args, Function<LuaValue, T> transformFunc) {
        try {
            if (scriptContainer.isFake) {
                return dfault;
            }
            LuaValue func = scriptContainer.runEnv.get(funcString);
            if (!func.isfunction()) {
                return dfault;
            }
            return Utils.tryAndExecute(dfault, (LuaFunction)func, args, transformFunc);
        }
        catch (LuaError e) {
            m3we.LOGGER.error("env failure: \n" + e.getMessage());
            return dfault;
        }
    }

    public static <T> T tryAndExecute(T dfault, LuaFunction func, Object[] args, Function<LuaValue, T> transformFunc) {
        if (args == null) {
            args = new Object[]{};
        }
        try {
            LuaValue[] luaArgs = new LuaValue[args.length];
            for (int i = 0; i < luaArgs.length; ++i) {
                luaArgs[i] = Utils.toLuaValue(args[i]);
            }
            return transformFunc.apply(func.invoke(luaArgs).arg1());
        }
        catch (LuaError e) {
            m3we.LOGGER.error("function failure: \n" + e.getMessage());
            return dfault;
        }
    }

    public static void tryAndExecute(CustomScript scriptContainer, String funcString, Object[] args) {
        Utils.tryAndExecute(null, scriptContainer, funcString, args, returnValue -> null);
    }

    public static void tryAndExecute(LuaFunction func, Object[] args) {
        Utils.tryAndExecute(null, func, args, returnValue -> null);
    }

    public static String deobfuscate(String obfuscated) {
        Translations.ClassToken token;
        if (!Translations.OBFUSCATED || !Translations.obfuscatedPattern.matcher(obfuscated).matches()) {
            return obfuscated;
        }
        boolean isArray = obfuscated.endsWith("[]");
        int endingNum = Integer.parseInt(obfuscated.substring(obfuscated.indexOf(95) + 1, obfuscated.length() - (isArray ? 2 : 0)));
        switch (obfuscated.charAt(1)) {
            case 'l': {
                Translations.Token token2 = Translations.classesTranslations[endingNum];
                break;
            }
            case 'i': {
                Translations.Token token2 = Translations.fieldsTranslations[endingNum];
                break;
            }
            case 'e': {
                Translations.Token token2 = Translations.methodsTranslations[endingNum];
                break;
            }
            case 'o': {
                Translations.Token token2 = Translations.compFieldsTranslations[endingNum];
                break;
            }
            default: {
                Translations.Token token2 = token = null;
            }
        }
        return token != null ? token.deobfuscated + (isArray ? "[]" : "") : obfuscated;
    }

    public static class Ref<T> {
        public T value;

        public Ref(T value) {
            this.value = value;
        }
    }
}

