/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.editor.component;

import com.kyfexuwu.m3we.editor.Block;
import com.kyfexuwu.m3we.editor.component.Component;

public abstract class FillingComponent
extends Component {
    private final double minWidth;
    private final double minHeight;

    public FillingComponent(Block parent, double minWidth, double minHeight) {
        super(parent);
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    public FillingComponent(Block parent) {
        this(parent, 0.0, 0.0);
    }

    @Override
    public double width(boolean isolated) {
        if (isolated) {
            return this.minWidth;
        }
        double width = this.minWidth;
        double restOfRow = 0.0;
        for (Component[] row : this.parent.components) {
            if (!Component.arrContains(this, row)) continue;
            restOfRow = Component.rowWidth(row) - this.width(true);
        }
        for (Component[] row : this.parent.components) {
            if (Component.arrContains(this, row)) continue;
            width = Math.max(width, Component.rowWidth(row) - restOfRow);
        }
        return width;
    }

    @Override
    public double height(boolean isolated) {
        if (isolated) {
            return this.minHeight;
        }
        for (Component[] row : this.parent.components) {
            if (!Component.arrContains(this, row)) continue;
            return Component.rowHeight(row);
        }
        return this.minHeight;
    }
}

