/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.initializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.kyfexuwu.m3we.Json;
import com.kyfexuwu.m3we.initializers.InitUtils;
import com.kyfexuwu.m3we.lua.CustomScript;
import com.kyfexuwu.m3we.m3we;
import com.kyfexuwu.m3we.m3weData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4174;

public class ItemIniter {
    private static final ItemPropertyTranslator<?>[] itemPropertyMap = new ItemPropertyTranslator[]{new ItemPropertyTranslator<Integer>("maxCount", class_1792.class_1793::method_7889, InitUtils.IntTransformFunc, class_1792::method_7882), new ItemPropertyTranslator<Integer>("maxDamage", class_1792.class_1793::method_7895, InitUtils.IntTransformFunc, class_1792::method_7841), new ItemPropertyTranslator<class_1792>("recipeRemainder", class_1792.class_1793::method_7896, SAV -> {
        Object id = SAV.value.getAsString();
        if (!((String)id).contains(":")) {
            id = "minecraft:" + (String)id;
        }
        return (class_1792)class_2378.field_11142.method_10223(new class_2960((String)id));
    }, class_1792::method_7858), new ItemPropertyTranslator<class_1761>("itemGroup", class_1792.class_1793::method_7892, SAV -> {
        try {
            return (class_1761)class_1761.class.getField(SAV.value.getAsString()).get(null);
        }
        catch (Exception e) {
            return class_1761.field_7932;
        }
    }, class_1792::method_7859), new ItemPropertyTranslator<class_1814>("rarity", class_1792.class_1793::method_7894, SAV -> {
        try {
            return class_1814.valueOf((String)SAV.value.getAsString());
        }
        catch (IllegalArgumentException e) {
            return class_1814.field_8906;
        }
    }, item -> item.method_7862(item.method_7854())), new ItemPropertyTranslator<class_4174>("foodComponent", class_1792.class_1793::method_19265, SAV -> {
        JsonObject thisObj = SAV.value.getAsJsonObject();
        class_4174.class_4175 toReturn = new class_4174.class_4175().method_19238(thisObj.has("hunger") ? thisObj.get("hunger").getAsInt() : 0).method_19237(thisObj.has("get") ? thisObj.get("saturation").getAsFloat() : 0.0f);
        if (thisObj.has("isMeat") && thisObj.get("isMeat").getAsBoolean()) {
            toReturn = toReturn.method_19236();
        }
        if (thisObj.has("isAlwaysEdible") && thisObj.get("isAlwaysEdible").getAsBoolean()) {
            toReturn = toReturn.method_19240();
        }
        if (thisObj.has("canEatFast") && thisObj.get("canEatFast").getAsBoolean()) {
            toReturn = toReturn.method_19241();
        }
        if (thisObj.has("statusEffects") && thisObj.get("statusEffects").isJsonArray()) {
            JsonArray effects = thisObj.get("statusEffects").getAsJsonArray();
            int length = effects.size();
            for (int i = 0; i < length; ++i) {
                class_1291 type;
                JsonObject thisEffect = effects.get(i).getAsJsonObject();
                if (!thisEffect.has("effect") || (type = (class_1291)class_2378.field_11159.method_10223(new class_2960(thisEffect.get("effect").getAsString()))) == null) continue;
                int duration = thisEffect.has("duration") ? thisEffect.get("duration").getAsInt() : 0;
                int amplifier = thisEffect.has("amplifier") ? thisEffect.get("amplifier").getAsInt() : 0;
                boolean visible = thisEffect.has("visible") ? thisEffect.get("visible").getAsBoolean() : true;
                class_1293 effectToAdd = new class_1293(type, duration, amplifier, false, visible);
                float chance = thisEffect.has("chance") ? thisEffect.get("chance").getAsFloat() : 1.0f;
                toReturn = toReturn.method_19239(effectToAdd, chance);
            }
        }
        return toReturn.method_19242();
    }, class_1792::method_19264), new ItemPropertyTranslator<Boolean>("isFireproof", (settings, fireproof) -> fireproof != false ? settings.method_24359() : settings, InitUtils.BoolTransformFunc, class_1792::method_24358)};

    public static InitUtils.SuccessAndIdentifier itemFromFile(File file) {
        class_1792 thisItem;
        JsonObject itemJsonData;
        if (!file.canRead()) {
            return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.CANT_READ);
        }
        try {
            itemJsonData = (JsonObject)Json.GSON.fromJson(Files.readString(file.toPath()), JsonObject.class);
        }
        catch (JsonSyntaxException | IOException e) {
            return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.BAD_JSON);
        }
        if (itemJsonData.has("blockToPlace")) {
            Object blockToPlaceName = itemJsonData.get("blockToPlace").getAsString();
            if (!((String)blockToPlaceName).contains(":")) {
                blockToPlaceName = "minecraft:" + (String)blockToPlaceName;
            }
            if (class_2378.field_11146.method_17966(new class_2960((String)blockToPlaceName)).isEmpty()) {
                return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.COME_BACK_LATER);
            }
        }
        String itemName = "Invalid Name";
        try {
            itemName = itemJsonData.get("itemName").getAsString();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        class_1792.class_1793 settings = new class_1792.class_1793();
        settings.method_7892(m3we.m3weItemGroup);
        for (ItemPropertyTranslator<?> propToTranslate : itemPropertyMap) {
            if (!itemJsonData.has(propToTranslate.jsonProp)) continue;
            settings = propToTranslate.apply(settings, itemJsonData, CustomScript.NULL);
        }
        if (itemJsonData.has("blockToPlace")) {
            Object blockToPlaceName = itemJsonData.get("blockToPlace").getAsString();
            if (!((String)blockToPlaceName).contains(":")) {
                blockToPlaceName = "minecraft:" + (String)blockToPlaceName;
            }
            thisItem = new class_1747((class_2248)class_2378.field_11146.method_10223(new class_2960((String)blockToPlaceName)), settings);
        } else {
            thisItem = new class_1792(settings);
        }
        String namespace = "json-blocks";
        if (itemJsonData.has("namespace") && InitUtils.validNamespaceName.matcher(itemJsonData.get("namespace").getAsString()).matches()) {
            namespace = itemJsonData.get("namespace").getAsString();
        }
        class_2960 thisId = new class_2960(namespace, itemName);
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)thisId, (Object)thisItem);
        m3we.m3weItems.put(namespace + ":" + itemName, thisItem);
        m3weData.packNamespaces.add(namespace);
        return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.YOU_DID_IT, thisId);
    }

    private static class ItemPropertyTranslator<T>
    extends InitUtils.PropertyTranslator<T, class_1792.class_1793, class_1792> {
        public ItemPropertyTranslator(String jsonProp, BiFunction<class_1792.class_1793, T, class_1792.class_1793> toJavaFunc, Function<InitUtils.ScriptAndValue, T> transformFunc, Function<class_1792, T> getDefaultFunc) {
            super(jsonProp, toJavaFunc, transformFunc, getDefaultFunc);
        }
    }
}

