/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.lua;

import com.kyfexuwu.m3we.Utils;
import com.kyfexuwu.m3we.lua.ChatMessage;
import com.kyfexuwu.m3we.lua.CustomClickEvent;
import com.kyfexuwu.m3we.lua.ExploreScreen;
import com.kyfexuwu.m3we.lua.JavaExclusiveTable;
import com.kyfexuwu.m3we.lua.LuaFunc;
import com.kyfexuwu.m3we.lua.LuaSurfaceObj;
import com.kyfexuwu.m3we.lua.Translations;
import com.kyfexuwu.m3we.lua.UndecidedLuaFunction;
import com.kyfexuwu.m3we.lua.api.BlockEntityAPI;
import com.kyfexuwu.m3we.lua.api.CreateAPI;
import com.kyfexuwu.m3we.lua.api.DatastoreAPI;
import com.kyfexuwu.m3we.lua.api.EnumsAPI;
import com.kyfexuwu.m3we.lua.api.GuiAPI;
import com.kyfexuwu.m3we.lua.api.MiscAPI;
import com.kyfexuwu.m3we.lua.api.PropertyAPI;
import com.kyfexuwu.m3we.lua.api.RedstoneAPI;
import com.kyfexuwu.m3we.lua.api.RegistryAPI;
import com.kyfexuwu.m3we.lua.api.SignalsAPI;
import com.kyfexuwu.m3we.m3we;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.StringLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;

public class CustomScript {
    public static CustomScript NULL = new CustomScript(null, true);
    public Globals runEnv;
    public final String name;
    public final boolean isFake;
    static final Disabled disabled = new Disabled();
    public static final String contextIdentifier = "__context";
    public final JavaExclusiveTable contextObj = new JavaExclusiveTable();
    public static final ArrayList<String> apiNames = new ArrayList();
    private static final Logger printLogger = Logger.getLogger("m3we-print");
    public static MinecraftServer currentServer;
    public final List<Consumer<CustomScript>> updateListeners = new ArrayList<Consumer<CustomScript>>();
    public static final ArrayList<CustomScript> scripts;
    private static final int maxLevels = 5;

    private static Globals unsafeGlobal() {
        CustomGlobals toReturn = new CustomGlobals();
        toReturn.load((LuaValue)new JseBaseLib());
        toReturn.load((LuaValue)new PackageLib());
        toReturn.load((LuaValue)new TableLib());
        toReturn.load((LuaValue)new StringLib());
        toReturn.load((LuaValue)new JseMathLib());
        toReturn.set("print", (LuaValue)LuaFunc.func(args -> {
            CustomScript.print(toReturn.get(contextIdentifier).get("env").optjstring("none"), args);
            return LuaValue.NONE;
        }));
        toReturn.set("consoleprint", (LuaValue)LuaFunc.func(args -> {
            StringBuilder toPrint = new StringBuilder();
            for (int i = 0; i < args.size() - 1; ++i) {
                toPrint.append(args.get(i)).append(", ");
            }
            printLogger.info(toPrint.append(args.get(args.size() - 1)).toString());
            return LuaValue.NONE;
        }));
        toReturn.set("explore", (LuaValue)LuaFunc.func(values -> CustomScript.explore((LuaValue)values.get(0))));
        toReturn.set("loadclass", (LuaValue)LuaFunc.func(args -> {
            try {
                return CustomScript.loadclass(((LuaValue)args.get(0)).checkjstring());
            }
            catch (LuaError e) {
                return LuaValue.NIL;
            }
        }));
        toReturn.load((LuaValue)new BlockEntityAPI());
        toReturn.load((LuaValue)new CreateAPI());
        toReturn.load((LuaValue)new DatastoreAPI());
        toReturn.load((LuaValue)new EnumsAPI());
        toReturn.load((LuaValue)new GuiAPI());
        toReturn.load((LuaValue)new MiscAPI());
        toReturn.load((LuaValue)new PropertyAPI());
        toReturn.load((LuaValue)new RedstoneAPI());
        toReturn.load((LuaValue)new RegistryAPI());
        toReturn.load((LuaValue)new SignalsAPI());
        return toReturn;
    }

    protected static Globals safeGlobal() {
        Globals toReturn = CustomScript.unsafeGlobal();
        toReturn.set("loadLib", (LuaValue)LuaFunc.func(args -> {
            LuaValue arg = (LuaValue)args.get(0);
            if (!arg.isstring() || arg.checkjstring().contains("..")) {
                return LuaValue.NIL;
            }
            return LuaValue.NIL;
        }));
        toReturn.set("require", (LuaValue)disabled);
        toReturn.set("load", (LuaValue)disabled);
        toReturn.set("dofile", (LuaValue)disabled);
        toReturn.set("loadfile", (LuaValue)disabled);
        return toReturn;
    }

    public static Varargs createVarArgs(Object ... args) {
        Object object;
        if (args.length == 1 && (object = args[0]) instanceof LuaFunc.ArrayListWithNil) {
            LuaFunc.ArrayListWithNil arg1 = (LuaFunc.ArrayListWithNil)object;
            int size = arg1.size();
            Object[] newArgs = new Object[size];
            for (int i = 0; i < size; ++i) {
                newArgs[i] = arg1.get(i);
            }
            return CustomScript.createVarArgs(newArgs);
        }
        final LuaValue[] luaArgs = (LuaValue[])Arrays.stream(args).map(Utils::toLuaValue).toArray(LuaValue[]::new);
        return new Varargs(){

            public LuaValue arg(int i) {
                return luaArgs[i - 1];
            }

            public int narg() {
                return luaArgs.length;
            }

            public LuaValue arg1() {
                return this.arg(1);
            }

            public Varargs subargs(int start) {
                return CustomScript.createVarArgs(Arrays.copyOfRange(luaArgs, start - 1, luaArgs.length));
            }
        };
    }

    public static Varargs print(String env, Varargs args) {
        StringBuilder toPrint = new StringBuilder();
        if (args.narg() == 1 && args.arg(1).isstring()) {
            toPrint.append(args.arg(1).checkjstring());
        } else {
            int length = args.narg();
            for (int i = 1; i <= length; ++i) {
                toPrint.append(i > 1 ? ", " : "").append(CustomScript.valueToString(args.arg(i), 0));
            }
        }
        try {
            class_2561 message = class_2561.method_30163((String)toPrint.toString().replace("\r", ""));
            if (env.equals("server")) {
                for (class_3222 player : currentServer.method_3760().method_14571()) {
                    if (!player.method_5687(1)) continue;
                    player.method_43496(message);
                }
            } else {
                ChatMessage.message(message);
            }
        }
        catch (Exception e) {
            m3we.LOGGER.debug("m3we print: " + toPrint);
        }
        return LuaValue.NIL;
    }

    public static void print(String env, Object ... args) {
        CustomScript.print(env, CustomScript.createVarArgs(args));
    }

    private static boolean isPrimitive(Object o) {
        Class<?> clazz = o.getClass();
        return clazz == Integer.class || clazz == Float.class || clazz == Double.class || clazz == Long.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Boolean.class || clazz == String.class;
    }

    public static LuaValue explore(LuaValue value) {
        Object obj = Utils.toObject(value);
        if (obj == null) {
            ChatMessage.message((class_2561)class_2561.method_43470((String)"explored: nil").method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Primitive value")))));
            return LuaValue.NIL;
        }
        if (CustomScript.isPrimitive(obj)) {
            ChatMessage.message((class_2561)class_2561.method_43470((String)("explored: " + obj)).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Primitive value")))));
            return LuaValue.NIL;
        }
        ChatMessage.message((class_2561)class_2561.method_43470((String)("exploring " + Utils.deobfuscate(obj.getClass().getSimpleName()))).method_10862(class_2583.field_24360.method_10958((class_2558)new CustomClickEvent(() -> class_310.method_1551().method_1507((class_437)new ExploreScreen(value)))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to explore")))));
        return LuaValue.NIL;
    }

    public static LuaValue loadclass(String string) {
        Class<?> toReturn;
        try {
            Optional<Translations.ClassToken> classToken = Arrays.stream(Translations.classesTranslations).filter(token -> token != null && token.longDeobfuscated.equals(string)).findFirst();
            toReturn = Class.forName(classToken.isPresent() ? (Translations.OBFUSCATED ? classToken.get().longObfuscated : classToken.get().longDeobfuscated) : string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return LuaValue.NIL;
        }
        return Utils.toLuaValue(toReturn);
    }

    protected CustomScript(String name, boolean isFake) {
        this.name = name;
        this.isFake = isFake;
    }

    public CustomScript(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            this.name = "fake";
            this.isFake = true;
            return;
        }
        this.name = fileName;
        this.isFake = false;
        this.setScript(fileName);
        scripts.add(this);
    }

    private void setScript(String fileName) {
        this.runEnv = CustomScript.safeGlobal();
        this.runEnv.set(contextIdentifier, (LuaValue)this.contextObj);
        LoadState.install((Globals)this.runEnv);
        LuaC.install((Globals)this.runEnv);
        try {
            String[] parts = fileName.split(":");
            if (parts.length == 1) {
                throw new InvalidPathException("", "Script paths mush be in the form pack_name:file_name");
            }
            this.runEnv.load(Files.readString(Paths.get(m3we.m3weFolder.getAbsolutePath(), parts[0], "scripts", parts[1] + ".lua"))).call();
            for (Consumer<CustomScript> listener : this.updateListeners) {
                listener.accept(this);
            }
        }
        catch (IOException | InvalidPathException | LuaError e) {
            m3we.LOGGER.error("script {} not loaded... it was a {} exception. Message: {}", new Object[]{fileName, e.getClass().getName(), e.getMessage()});
        }
    }

    public void remove() {
        if (this.isFake) {
            return;
        }
        for (int i = 0; i < scripts.size(); ++i) {
            if (!CustomScript.scripts.get((int)i).name.equals(this.name)) continue;
            scripts.remove(i);
            --i;
        }
    }

    public void setStateWorldPos(class_2680 state, class_1937 world, class_2338 pos) {
        if (this.isFake) {
            return;
        }
        this.contextObj.javaSet("blockState", Utils.toLuaValue(state));
        this.contextObj.javaSet("world", Utils.toLuaValue(world));
        this.contextObj.javaSet("blockPos", Utils.toLuaValue(pos));
    }

    public void clearStateWorldPos() {
    }

    public static void reloadScript(String name) {
        for (CustomScript script : scripts) {
            if (!(script.name + ".lua").equals(name)) continue;
            script.setScript(script.name);
        }
    }

    public static void reloadAll() {
        for (CustomScript script : scripts) {
            script.setScript(script.name);
        }
    }

    private static String valueToString(LuaValue value, int indents, Utils.Ref<Integer> maxVals) {
        if ((Integer)maxVals.value <= 0) {
            return "";
        }
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("  ".repeat(indents));
        Object object = maxVals;
        Integer n = (Integer)((Utils.Ref)object).value;
        ((Utils.Ref)object).value = (Integer)((Utils.Ref)object).value - 1;
        switch (value.typename()) {
            case "nil": 
            case "boolean": 
            case "number": 
            case "function": 
            case "userdata": 
            case "thread": {
                toReturn.append(value);
                break;
            }
            case "string": {
                toReturn.append("\"").append(value).append("\"");
                break;
            }
            case "table": {
                if (indents < 5) {
                    LuaValue[] keys;
                    toReturn.append("{\n");
                    for (LuaValue key : keys = ((LuaTable)value).keys()) {
                        toReturn.append(key).append("=").append(CustomScript.valueToString(value.get(key), indents + 1, maxVals)).append(",\n");
                    }
                    toReturn.append("  ".repeat(indents)).append("}");
                    break;
                }
                toReturn.append("{...}");
                break;
            }
            case "surfaceObj": {
                toReturn.append("java object: ").append(Utils.deobfuscate(((LuaSurfaceObj)value).object.getClass().getSimpleName()));
                break;
            }
            case "undecidedFunc": {
                UndecidedLuaFunction func = (UndecidedLuaFunction)value;
                List<UndecidedLuaFunction.MethodDescriptor> description = func.methodDescribers();
                toReturn.append("java function: ").append(func.funcName());
                for (UndecidedLuaFunction.MethodDescriptor descriptor : description) {
                    if (!descriptor.params().isEmpty()) {
                        toReturn.append("\n \u2022 [takes parameters: ");
                        for (int i = 0; i < descriptor.params().size(); ++i) {
                            if (i > 0) {
                                toReturn.append(", ");
                            }
                            toReturn.append((String)descriptor.params().get(i).getB()).append(" (").append((String)descriptor.params().get(i).getA()).append(")");
                        }
                    } else {
                        toReturn.append(" [takes no parameters,");
                    }
                    toReturn.append(" and ");
                    if (descriptor.type() == UndecidedLuaFunction.MethodType.METHOD) {
                        String returnClass = descriptor.returnClass();
                        if (!returnClass.equals(Void.class.getSimpleName())) {
                            toReturn.append("returns with type ").append(returnClass).append("]");
                            continue;
                        }
                        toReturn.append("does not return a value]");
                        continue;
                    }
                    toReturn.append("and creates a new ").append(descriptor.returnClass()).append("]");
                }
                break;
            }
        }
        return toReturn.toString();
    }

    private static String valueToString(LuaValue value, int indents) {
        return CustomScript.valueToString(value, indents, new Utils.Ref<Integer>(100));
    }

    public static LuaValue finalizeAPI(String name, LuaValue api, LuaValue env) {
        apiNames.add(name);
        env.set(name, api);
        env.get("package").get("loaded").set(name, api);
        return api;
    }

    static {
        scripts = new ArrayList();
    }

    private static class CustomGlobals
    extends Globals {
        private CustomGlobals() {
        }

        public void hashset(LuaValue luaKey, LuaValue val) {
            try {
                String key = luaKey.checkjstring();
                if (key.equals(CustomScript.contextIdentifier)) {
                    throw new LuaError("Cannot overwrite __context");
                }
                for (String name : apiNames) {
                    if (!key.equals(name)) continue;
                    throw new LuaError("Cannot overwrite API " + name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.hashset(luaKey, val);
        }
    }

    static class Disabled
    extends VarArgFunction {
        Disabled() {
        }

        public Varargs invoke(Varargs args) {
            CustomScript.print("client", (Varargs)LuaValue.valueOf((String)"This value is disabled"));
            return NIL;
        }
    }
}

