/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.lua.api;

import com.kyfexuwu.m3we.Utils;
import com.kyfexuwu.m3we.lua.CustomScript;
import com.kyfexuwu.m3we.lua.JavaExclusiveTable;
import com.kyfexuwu.m3we.lua.ScriptError;
import com.kyfexuwu.m3we.lua.api.APIFunctions;
import com.kyfexuwu.m3we.lua.dyngui.DynamicGui;
import com.kyfexuwu.m3we.lua.dyngui.DynamicGuiBuilder;
import com.kyfexuwu.m3we.lua.dyngui.DynamicGuiHandler;
import com.kyfexuwu.m3we.lua.dyngui.DynamicInventory;
import java.util.HashMap;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class GuiAPI
extends TwoArgFunction {
    private static final LuaError outOfContextError = new LuaError("You must be inside a GUI function to call this function");
    static final HashMap<String, DynamicGuiBuilder> guis = new HashMap();

    public LuaValue call(LuaValue modname, LuaValue env) {
        JavaExclusiveTable thisApi = new JavaExclusiveTable();
        thisApi.javaSet("openGui", (LuaValue)new openGui(env));
        thisApi.javaSet("setBounds", (LuaValue)new setBounds(env));
        thisApi.javaSet("rect", (LuaValue)new drawRect(env));
        thisApi.javaSet("slot", (LuaValue)new drawSlot(env));
        thisApi.javaSet("drawImg", (LuaValue)new drawImg(env));
        thisApi.javaSet("text", (LuaValue)new drawText(env));
        thisApi.javaSet("playerInventory", (LuaValue)new drawInv(env));
        thisApi.javaSet("getSlot", (LuaValue)new getSlot(env));
        thisApi.javaSet("doInWorld", (LuaValue)new doInWorld(env));
        thisApi.javaSet("register", (LuaValue)new registerGUI(env));
        return CustomScript.finalizeAPI("Gui", (LuaValue)thisApi, env);
    }

    public static DynamicGuiBuilder getGui(String name) {
        if (!guis.containsKey(name)) {
            return null;
        }
        return guis.get(name);
    }

    static final class openGui
    extends APIFunctions.VarArgAPIFunc {
        public openGui(LuaValue globals) {
            super(globals);
        }

        public Varargs invoke(Varargs args) {
            JavaExclusiveTable ctxTable;
            class_1657 player = (class_1657)Utils.toObjectTyped(args.arg(1));
            final String guiName = (String)Utils.toObjectTyped(args.arg(2));
            final class_1937 world = (class_1937)Utils.toObjectTyped(args.arg(3));
            final class_2338 pos = (class_2338)Utils.toObjectTyped(args.arg(4));
            class_1263 serverInv = (class_1263)Utils.toObjectTyped(args.arg(5));
            if (serverInv == null) {
                serverInv = new DynamicInventory();
            }
            if (!(ctxTable = (JavaExclusiveTable)this.globals.get("__context")).get("env").checkjstring().equals("server")) {
                return FALSE;
            }
            try {
                final class_1263 finalServerInv = serverInv;
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                    @Nullable
                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                        return GuiAPI.getGui(guiName).build(syncId, inv, finalServerInv, world, pos, guiName);
                    }

                    public class_2561 method_5476() {
                        return class_2561.method_30163((String)"Custom Interface");
                    }

                    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                        buf.method_10814(guiName);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return TRUE;
        }
    }

    static final class setBounds
    extends TwoArgFunction {
        private final LuaValue globals;

        public setBounds(LuaValue globals) {
            this.globals = globals;
        }

        public LuaValue call(LuaValue w, LuaValue h) {
            return ScriptError.execute(() -> {
                JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
                DynamicGui gui = (DynamicGui)((Object)((Object)Utils.toObject(ctxTable.get("guiData"))));
                if (gui == null) {
                    throw outOfContextError;
                }
                DynamicGui.props.x = (gui.field_22789 - w.checkint()) / 2;
                DynamicGui.props.y = (gui.field_22790 - h.checkint()) / 2;
                DynamicGui.props.w = w.checkint();
                DynamicGui.props.h = h.checkint();
            });
        }
    }

    static final class drawRect
    extends VarArgFunction {
        private final LuaValue globals;

        public drawRect(LuaValue globals) {
            this.globals = globals;
        }

        public Varargs invoke(Varargs args) {
            return ScriptError.execute(() -> {
                JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
                DynamicGui gui = (DynamicGui)((Object)((Object)Utils.toObject(ctxTable.get("guiData"))));
                if (gui == null) {
                    throw outOfContextError;
                }
                gui.componentsToDraw.add(new DynamicGui.RectGuiComponent(args.arg(1).checkint(), args.arg(2).checkint(), args.arg(3).checkint(), args.arg(4).checkint()));
            });
        }
    }

    static final class drawSlot
    extends VarArgFunction {
        private final LuaValue globals;

        public drawSlot(LuaValue globals) {
            this.globals = globals;
        }

        public Varargs invoke(Varargs args) {
            LuaValue x = args.arg(1);
            LuaValue y = args.arg(2);
            LuaValue index = args.arg(3);
            LuaValue drawSlot2 = args.arg(4);
            JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
            DynamicGui gui = (DynamicGui)((Object)Utils.toObject(ctxTable.get("guiData")));
            if (gui == null) {
                throw outOfContextError;
            }
            LuaBoolean success = ScriptError.execute(() -> gui.componentsToDraw.add(new DynamicGui.SlotGuiComponent(x.checkint(), y.checkint(), index.checkint(), gui, false, drawSlot2.isboolean() ? (Boolean)Utils.toObject(drawSlot2) : true)));
            if (success.v) {
                int toReturn = DynamicGui.props.slotAmt + (gui.handler.builder.hasPlayerInventory ? 36 : 0);
                ++DynamicGui.props.slotAmt;
                return LuaValue.valueOf((int)toReturn);
            }
            return LuaValue.valueOf((int)-1);
        }
    }

    static final class drawImg
    extends VarArgFunction {
        private final LuaValue globals;

        public drawImg(LuaValue globals) {
            this.globals = globals;
        }

        public Varargs invoke(Varargs args) {
            try {
                JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
                DynamicGui gui = (DynamicGui)((Object)Utils.toObject(ctxTable.get("guiData")));
                if (gui == null) {
                    throw outOfContextError;
                }
                int narg = args.narg();
                if (!args.arg(1).isstring()) {
                    return NIL;
                }
                for (int i = 1; i < narg; ++i) {
                    if (args.arg(i + 1).isint()) continue;
                    return NIL;
                }
                if (narg < 5) {
                    return NIL;
                }
                if (narg < 7) {
                    drawImg.draw(gui, args.arg(1).checkjstring(), args.arg(2).checkint(), args.arg(3).checkint(), args.arg(4).checkint(), args.arg(5).checkint());
                } else if (narg < 9) {
                    drawImg.draw(gui, args.arg(1).checkjstring(), args.arg(2).checkint(), args.arg(3).checkint(), args.arg(4).checkint(), args.arg(5).checkint(), args.arg(6).checkint(), args.arg(7).checkint());
                } else if (narg < 11) {
                    drawImg.draw(gui, args.arg(1).checkjstring(), args.arg(2).checkint(), args.arg(3).checkint(), args.arg(4).checkint(), args.arg(5).checkint(), args.arg(6).checkint(), args.arg(7).checkint(), args.arg(8).checkint(), args.arg(9).checkint());
                } else {
                    drawImg.draw(gui, args.arg(1).checkjstring(), args.arg(2).checkint(), args.arg(3).checkint(), args.arg(4).checkint(), args.arg(5).checkint(), args.arg(6).checkint(), args.arg(7).checkint(), args.arg(8).checkint(), args.arg(9).checkint(), args.arg(10).checkint(), args.arg(11).checkint());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return NIL;
        }

        private static void draw(DynamicGui gui, String name, int tW, int tH, int x, int y, int w, int h, int sx, int sy, int sw, int sh) {
            gui.componentsToDraw.add(new DynamicGui.ImgGuiComponent(name, tW, tH, x, y, w, h, sx, sy, sw, sh));
        }

        private static void draw(DynamicGui gui, String name, int tW, int tH, int x, int y, int sx, int sy, int sw, int sh) {
            drawImg.draw(gui, name, tW, tH, x, y, sw, sh, sx, sy, sw, sh);
        }

        private static void draw(DynamicGui gui, String name, int tW, int tH, int x, int y, int w, int h) {
            drawImg.draw(gui, name, tW, tH, x, y, w, h, 0, 0, tW, tH);
        }

        private static void draw(DynamicGui gui, String name, int tW, int tH, int x, int y) {
            drawImg.draw(gui, name, tW, tH, x, y, tW, tH, 0, 0, tW, tH);
        }
    }

    static final class drawText
    extends ThreeArgFunction {
        private final LuaValue globals;

        public drawText(LuaValue globals) {
            this.globals = globals;
        }

        public LuaValue call(LuaValue text, LuaValue x, LuaValue y) {
            return ScriptError.execute(() -> {
                JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
                DynamicGui gui = (DynamicGui)((Object)((Object)Utils.toObject(ctxTable.get("guiData"))));
                if (gui == null) {
                    throw outOfContextError;
                }
                gui.componentsToDraw.add(new DynamicGui.TextGuiComponent(text.checkjstring(), x.checkint(), y.checkint(), gui));
            });
        }
    }

    static final class drawInv
    extends TwoArgFunction {
        private final LuaValue globals;

        public drawInv(LuaValue globals) {
            this.globals = globals;
        }

        public LuaValue call(LuaValue xP, LuaValue yP) {
            return ScriptError.execute(() -> {
                JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
                DynamicGui gui = (DynamicGui)((Object)((Object)Utils.toObject(ctxTable.get("guiData"))));
                if (gui == null) {
                    throw outOfContextError;
                }
                gui.componentsToDraw.add(new DynamicGui.RectGuiComponent(xP.checkint(), yP.checkint(), 176, 100));
                gui.componentsToDraw.add(new DynamicGui.TextGuiComponent("Inventory", xP.checkint() + 8, yP.checkint() + 6, gui));
                int index = 0;
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 9; ++x) {
                        gui.componentsToDraw.add(new DynamicGui.SlotGuiComponent(7 + x * 18 + xP.checkint(), 17 + y * 18 + yP.checkint(), index, gui, true, true));
                        ++index;
                    }
                }
                for (int i = 0; i < 9; ++i) {
                    gui.componentsToDraw.add(new DynamicGui.SlotGuiComponent(7 + i * 18 + xP.checkint(), 75 + yP.checkint(), index, gui, true, true));
                    ++index;
                }
            });
        }
    }

    static final class getSlot
    extends TwoArgFunction {
        private final LuaValue globals;

        public getSlot(LuaValue globals) {
            this.globals = globals;
        }

        public LuaValue call(LuaValue slotNum, LuaValue invType) {
            class_1735[] toReturn = new class_1735[1];
            ScriptError.execute(() -> {
                JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
                DynamicGuiHandler handler = (DynamicGuiHandler)((Object)((Object)Utils.toObject(ctxTable.get("guiHandler"))));
                if (handler == null) {
                    throw outOfContextError;
                }
                int num = slotNum.checkint();
                if (!invType.checkjstring().equals("player") && handler.builder.hasPlayerInventory) {
                    num += 36;
                }
                toReturn[0] = (class_1735)handler.field_7761.get(num);
            });
            if (toReturn[0] == null) {
                return NIL;
            }
            return Utils.toLuaValue(toReturn[0]);
        }
    }

    static final class doInWorld
    extends OneArgFunction {
        private final LuaValue globals;

        public doInWorld(LuaValue globals) {
            this.globals = globals;
        }

        public LuaValue call(LuaValue arg) {
            ScriptError.execute(() -> {
                JavaExclusiveTable ctxTable = (JavaExclusiveTable)this.globals.get("__context");
                DynamicGuiHandler handler = (DynamicGuiHandler)((Object)((Object)Utils.toObject(ctxTable.get("guiHandler"))));
                if (handler == null) {
                    throw outOfContextError;
                }
                handler.context.method_17393((world, pos) -> arg.call(Utils.toLuaValue(world), Utils.toLuaValue(pos)));
            });
            return NIL;
        }
    }

    static final class registerGUI
    extends TwoArgFunction {
        private final LuaValue globals;

        public registerGUI(LuaValue globals) {
            this.globals = globals;
        }

        public LuaValue call(LuaValue guiName, LuaValue guiBehavior) {
            try {
                guis.put(guiName.checkjstring(), new DynamicGuiBuilder(this.globals, guiBehavior));
                return TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                return FALSE;
            }
        }
    }

    public static class DrawingProps {
        public int x = 0;
        public int y = 0;
        public int w = 0;
        public int h = 0;
        public int slotAmt = 0;
    }
}

