/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.luablock;

import com.kyfexuwu.m3we.luablock.LuaBlock;
import com.kyfexuwu.m3we.luablock.LuaBlockEntity;
import com.kyfexuwu.m3we.m3we;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_155;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class LuaBlockScreen
extends class_437 {
    private static final class_2960 TEXTURE = new class_2960("m3we", "textures/gui/lua_code.png");
    private static final class_2561 title = class_2561.method_43471((String)"m3we.lua_script");
    final class_2338 pos;
    public String code;
    String[] formattedCode;
    boolean active;
    public int backgroundWidth = 256;
    public int backgroundHeight = 200;
    int cursorPos = 0;
    int selectionPos = 0;
    float blinkInterval = 0.0f;
    int scroll = 0;
    static final int LINES_AMT = 19;

    public LuaBlockScreen(class_2338 pos, boolean active) {
        super(title);
        this.pos = pos;
        this.code = "";
        this.active = active;
        this.updateCode();
        ClientPlayNetworking.send((class_2960)m3we.askForLuaCodePacket, (class_2540)PacketByteBufs.create().method_10807(pos));
    }

    public void updateCode() {
        this.formattedCode = (String[])Arrays.stream(this.code.split("\n")).toArray(String[]::new);
    }

    class_3545<Integer, Integer> getXY(int charPos) {
        int y;
        if (charPos < 0) {
            return new class_3545((Object)0, (Object)0);
        }
        int x = 0;
        int charCount = 0;
        for (y = 0; y < this.formattedCode.length; ++y) {
            int thisLength = this.formattedCode[y].length() + 1;
            if (charPos >= charCount && charPos < charCount + thisLength) {
                x = charPos - charCount;
                break;
            }
            charCount += thisLength;
        }
        return new class_3545((Object)x, (Object)y);
    }

    void setCursor(int pos, boolean isSelecting) {
        this.cursorPos = Math.max(Math.min(pos, this.code.length()), 0);
        Integer y = (Integer)this.getXY(this.cursorPos - 1).method_15441();
        if (this.scroll < y - 19 + 1) {
            this.scroll = y - 19 + 1;
        } else if (this.scroll > y) {
            this.scroll = y;
        }
        if (!isSelecting) {
            this.selectionPos = this.cursorPos;
        }
    }

    void moveCursor(int move, boolean isSelecting) {
        this.setCursor(this.cursorPos + move, isSelecting);
    }

    void write(String toWrite) {
        class_3545<Integer, Integer> selection = this.getSelection();
        this.code = this.code.substring(0, (Integer)selection.method_15442()) + toWrite + this.code.substring((Integer)selection.method_15441());
        this.moveCursor(toWrite.length(), false);
        this.updateCode();
    }

    class_3545<Integer, Integer> getSelection() {
        class_3545 toReturn = new class_3545((Object)this.cursorPos, (Object)this.selectionPos);
        if (this.cursorPos > this.selectionPos) {
            toReturn.method_34965((Object)this.cursorPos);
            toReturn.method_34964((Object)this.selectionPos);
        }
        return toReturn;
    }

    void delete(int starting, int ending) {
        if (starting < 0) {
            starting = 0;
        }
        if (ending >= this.code.length()) {
            ending = this.code.length();
        }
        this.code = this.code.substring(0, starting) + this.code.substring(ending);
        this.updateCode();
        this.cursorPos = starting;
        this.selectionPos = starting;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_3545<Integer, Integer> cursorXY;
        super.method_25420(matrices);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int x = (this.field_22789 - this.backgroundWidth) / 2;
        int y = (this.field_22790 - this.backgroundHeight) / 2;
        this.method_25302(matrices, x, y, 0, 0, this.backgroundWidth, this.backgroundHeight);
        boolean inButton = mouseX - x >= 240 && mouseX - x <= 252 && mouseY - y >= 2 && mouseY - y <= 14;
        this.method_25302(matrices, x + 241, y + 3, this.active ? 0 : 12, 200, 12, 12);
        this.field_22793.method_30883(matrices, this.method_25440(), (float)(x + 8), (float)(y + 6), 0x404040);
        class_3545<Integer, Integer> selection = this.getSelection();
        Integer sStart = (Integer)selection.method_15442();
        Integer sEnd = (Integer)selection.method_15441();
        int charCount = 0;
        for (int before = 0; before < this.scroll; ++before) {
            charCount += this.formattedCode[before].length() + 1;
        }
        for (int line = this.scroll; line < this.formattedCode.length && line < this.scroll + 19; ++line) {
            Objects.requireNonNull(this.field_22793);
            int thisY = 9 * (line - this.scroll);
            int lineLength = this.formattedCode[line].length() + 1;
            int localSStart = 0;
            int localSEnd = -1;
            if (sStart >= charCount && sStart < charCount + lineLength) {
                localSStart = this.field_22793.method_1727(this.formattedCode[line].substring(0, sStart - charCount));
            }
            if (sEnd >= charCount && sEnd < charCount + lineLength) {
                localSEnd = this.field_22793.method_1727(this.formattedCode[line].substring(0, sEnd - charCount));
            }
            if (localSEnd == -1) {
                localSEnd = this.field_22793.method_1727(this.formattedCode[line]);
            }
            if (charCount + lineLength > sStart && charCount <= sEnd) {
                Objects.requireNonNull(this.field_22793);
                class_332.method_25294((class_4587)matrices, (int)(x + 10 + localSStart), (int)(y + 20 + thisY), (int)(x + 10 + localSEnd), (int)(y + 20 + thisY + 9), (int)-16742400);
            }
            this.field_22793.method_1729(matrices, this.field_22793.method_27523(this.formattedCode[line], 236), (float)(x + 10), (float)(y + 20 + thisY), 0xFFFFFF);
            charCount += lineLength;
        }
        this.blinkInterval += delta;
        if (this.blinkInterval >= 16.0f) {
            this.blinkInterval %= 16.0f;
        }
        if (this.blinkInterval < 8.0f && (Integer)(cursorXY = this.getXY(this.cursorPos)).method_15441() < this.formattedCode.length && (Integer)cursorXY.method_15441() >= this.scroll && (Integer)cursorXY.method_15441() < this.scroll + 19) {
            float f = x + 10 - 1 + this.field_22793.method_1727(this.formattedCode[(Integer)cursorXY.method_15441()].substring(0, (Integer)cursorXY.method_15442()));
            Objects.requireNonNull(this.field_22793);
            this.field_22793.method_1729(matrices, "|", f, (float)(y + 20 + 9 * ((Integer)cursorXY.method_15441() - this.scroll)), 65280);
        }
        if (inButton) {
            this.method_25424(matrices, (class_2561)class_2561.method_43471((String)(this.active ? "gui.m3we.active" : "gui.m3we.inactive")), mouseX, mouseY);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
    }

    public boolean method_25421() {
        return true;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (class_155.method_643((char)chr)) {
            this.write(Character.toString(chr));
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            class_2680 luaBlock;
            this.field_22787.field_1774.method_1462(false);
            class_2540 toSend = PacketByteBufs.create().method_10807(this.pos).method_10814(this.code);
            toSend.writeBoolean(this.active);
            ClientPlayNetworking.send((class_2960)m3we.updateLuaBlockPacket, (class_2540)toSend);
            class_2586 blockEntity = this.field_22787.field_1724.field_6002.method_8321(this.pos);
            if (blockEntity instanceof LuaBlockEntity) {
                ((LuaBlockEntity)blockEntity).setState(this.code, this.active);
            }
            if ((luaBlock = this.field_22787.field_1724.field_6002.method_8320(this.pos)).method_26204() instanceof LuaBlock) {
                this.field_22787.field_1724.field_6002.method_8501(this.pos, (class_2680)this.field_22787.field_1724.field_6002.method_8320(this.pos).method_11657((class_2769)LuaBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active)));
            }
            this.field_22787.field_1724.method_7346();
            return true;
        }
        if (class_437.method_25439((int)keyCode)) {
            this.setCursor(Integer.MAX_VALUE, false);
            this.selectionPos = 0;
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_3545<Integer, Integer> selection = this.getSelection();
            class_310.method_1551().field_1774.method_1455(this.code.substring((Integer)selection.method_15442(), (Integer)selection.method_15441()));
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.write(class_310.method_1551().field_1774.method_1460());
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_3545<Integer, Integer> selection = this.getSelection();
            class_310.method_1551().field_1774.method_1455(this.code.substring((Integer)selection.method_15442(), (Integer)selection.method_15441()));
            this.write("");
            this.setCursor((Integer)selection.method_15442(), false);
            return true;
        }
        switch (keyCode) {
            case 257: {
                this.write("\n");
                return true;
            }
            case 263: {
                this.moveCursor(-1, class_437.method_25442());
                return true;
            }
            case 262: {
                this.moveCursor(1, class_437.method_25442());
                return true;
            }
            case 265: {
                class_3545<Integer, Integer> pos = this.getXY(this.cursorPos);
                if ((Integer)pos.method_15441() <= 0) {
                    this.setCursor(0, class_437.method_25442());
                    return true;
                }
                int newPos = this.field_22793.method_27523(this.formattedCode[(Integer)pos.method_15441() - 1], this.field_22793.method_1727(this.formattedCode[(Integer)pos.method_15441()].substring(0, (Integer)pos.method_15442()))).length();
                for (int i = 0; i < (Integer)pos.method_15441() - 1; ++i) {
                    newPos += this.formattedCode[i].length() + 1;
                }
                this.setCursor(newPos, class_437.method_25442());
                return true;
            }
            case 264: {
                class_3545<Integer, Integer> pos = this.getXY(this.cursorPos);
                if ((Integer)pos.method_15441() >= this.formattedCode.length - 1) {
                    this.setCursor(Integer.MAX_VALUE, class_437.method_25442());
                    return true;
                }
                int newPos = this.field_22793.method_27523(this.formattedCode[(Integer)pos.method_15441() + 1], this.field_22793.method_1727(this.formattedCode[(Integer)pos.method_15441()].substring(0, (Integer)pos.method_15442()))).length();
                for (int i = 0; i < (Integer)pos.method_15441() + 1; ++i) {
                    newPos += this.formattedCode[i].length() + 1;
                }
                this.setCursor(newPos, class_437.method_25442());
                return true;
            }
            case 259: {
                if (this.cursorPos != this.selectionPos) {
                    class_3545<Integer, Integer> selection = this.getSelection();
                    this.delete((Integer)selection.method_15442(), (Integer)selection.method_15441());
                } else {
                    this.delete(this.cursorPos - 1, this.cursorPos);
                }
                return true;
            }
            case 261: {
                if (this.cursorPos != this.selectionPos) {
                    class_3545<Integer, Integer> selection = this.getSelection();
                    this.delete((Integer)selection.method_15442(), (Integer)selection.method_15441());
                } else {
                    this.delete(this.cursorPos, this.cursorPos + 1);
                }
                return true;
            }
            case 268: {
                this.moveCursor(0, class_437.method_25442());
                return true;
            }
            case 269: {
                this.moveCursor(Integer.MAX_VALUE, class_437.method_25442());
                return true;
            }
        }
        return true;
    }

    private int mouseEventPos(double adjMouseX, double adjMouseY) {
        int newPos = 0;
        int n = this.code.split("\n").length;
        Objects.requireNonNull(this.field_22793);
        int y = Math.min(n, (int)(adjMouseY / 9.0) + this.scroll);
        int end = Math.min(this.formattedCode.length, y);
        for (int i = 0; i < end; ++i) {
            newPos += this.formattedCode[i].length() + 1;
        }
        if (y < this.formattedCode.length) {
            newPos += this.field_22793.method_27523(this.formattedCode[y], (int)adjMouseX).length();
        }
        return Math.min(newPos, this.code.length());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        double adjMouseX = mouseX - (double)((this.field_22789 - this.backgroundWidth) / 2) - 8.0;
        double adjMouseY = mouseY - (double)((this.field_22790 - this.backgroundHeight) / 2) - 18.0;
        if (adjMouseX + 8.0 >= 240.0 && adjMouseX + 8.0 <= 252.0 && adjMouseY + 18.0 >= 2.0 && adjMouseY + 18.0 <= 14.0) {
            this.active = !this.active;
            return true;
        }
        if (adjMouseX < 0.0 || adjMouseY < 0.0 || adjMouseX > (double)(this.backgroundWidth - 16) || adjMouseY > (double)(this.backgroundHeight - 26)) {
            return false;
        }
        this.setCursor(this.mouseEventPos(adjMouseX, adjMouseY), class_437.method_25442());
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        double adjMouseX = mouseX - (double)((this.field_22789 - this.backgroundWidth) / 2) - 8.0;
        double adjMouseY = mouseY - (double)((this.field_22790 - this.backgroundHeight) / 2) - 18.0;
        if (adjMouseX < 0.0 || adjMouseY < 0.0 || adjMouseX > (double)(this.backgroundWidth - 16) || adjMouseY > (double)(this.backgroundHeight - 26)) {
            return false;
        }
        this.selectionPos = this.mouseEventPos(adjMouseX, adjMouseY);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.scroll = (int)((double)this.scroll - amount);
        if (this.scroll + 19 > this.formattedCode.length) {
            this.scroll = this.formattedCode.length - 19;
        }
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        return true;
    }
}

