/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.editor;

import com.kyfexuwu.m3we.editor.Color;
import com.kyfexuwu.m3we.editor.KeyEvent;
import com.kyfexuwu.m3we.editor.Rect2d;
import com.kyfexuwu.m3we.editor.Vec2d;
import com.kyfexuwu.m3we.editor.component.Component;
import com.kyfexuwu.m3we.editor.component.ComponentFactory;
import com.kyfexuwu.m3we.editor.component.connection.Connection;
import com.kyfexuwu.m3we.editor.component.connection.InputOutConnection;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class Block {
    private final Color color;
    public final Component[][] components;
    public final HashMap<String, Connection> connections = new HashMap();
    private final Function<Block, String> exportFunc;
    private Vec2d offs = new Vec2d(0.0, 0.0);

    public Block(Color color, ComponentFactory[][] components, Function<Block, String> export) {
        this.color = color;
        this.exportFunc = export;
        this.components = new Component[components.length][];
        for (int y = 0; y < components.length; ++y) {
            this.components[y] = new Component[components[y].length];
            for (int x = 0; x < components[y].length; ++x) {
                this.components[y][x] = components[y][x].create(this, x, y, components);
                Component component = this.components[y][x];
                if (!(component instanceof Connection)) continue;
                Connection connection = (Connection)component;
                this.connections.put(connection.name, connection);
            }
        }
    }

    public void connect(String connName, Block other, String otherName) {
        this.connections.get(connName).connect(other.connections.get(otherName));
    }

    public void disconnectFromParents() {
        if (this.connections.containsKey("prev")) {
            this.connections.get("prev").disconnect();
        }
        for (Connection connection : this.connections.values()) {
            if (!(connection instanceof InputOutConnection)) continue;
            connection.disconnect();
        }
    }

    public Rect2d boundingBox() {
        if (this.components.length == 0 || this.components[0].length == 0) {
            return new Rect2d(0.0, 0.0, 0.0, 0.0);
        }
        double width = 0.0;
        double height = 0.0;
        for (Component[] row : this.components) {
            width = Math.max(width, Component.rowWidth(row));
            height += Component.rowHeight(row);
        }
        Vec2d pos = this.getPos();
        return new Rect2d(pos.x, pos.y, width, height);
    }

    public Vec2d getPos() {
        Connection conn = this.connections.get("prev");
        if (conn == null || !conn.isConnected()) {
            conn = null;
            for (Connection c2 : this.connections.values()) {
                InputOutConnection ic2;
                if (!(c2 instanceof InputOutConnection) || !(ic2 = (InputOutConnection)c2).isConnected()) continue;
                conn = ic2;
                break;
            }
        }
        if (conn != null) {
            Vec2d parentPos = conn.getConnection().globalConnPos();
            Vec2d thisOffs = conn.connPos();
            double thisX = conn.x();
            double thisY = conn.y();
            return new Vec2d(parentPos.x - thisX - thisOffs.x, parentPos.y - thisY - thisOffs.y);
        }
        return new Vec2d(this.offs.x, this.offs.y);
    }

    public void offset(Vec2d offs) {
        if (this.connections.containsKey("prev") && this.connections.get("prev").isConnected()) {
            return;
        }
        for (Connection connection : this.connections.values()) {
            if (!(connection instanceof InputOutConnection) || !connection.isConnected()) continue;
            return;
        }
        this.offs = offs;
    }

    public void offset(double x, double y) {
        this.offset(new Vec2d(x, y));
    }

    public Vec2d offset() {
        return this.offs;
    }

    public void removeOffset() {
        this.offs = new Vec2d(0.0, 0.0);
    }

    public void draw(class_4587 matrices, class_327 textRenderer, int mouseX, int mouseY) {
        matrices.method_22903();
        Vec2d pos = this.getPos();
        matrices.method_22904(pos.x, pos.y, 0.0);
        Color color = this.mouse(mouseX, mouseY) ? this.color.highlighted() : this.color;
        for (int y = 0; y < this.components.length; ++y) {
            for (int x = 0; x < this.components[y].length; ++x) {
                matrices.method_22903();
                matrices.method_22904(this.components[y][x].x(), this.components[y][x].y(), 0.0);
                this.components[y][x].draw(matrices, textRenderer, color);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
    }

    public boolean mouse(double x, double y) {
        Vec2d offs = this.getPos();
        x -= offs.x;
        y -= offs.y;
        Component[][] componentArray = this.components;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component[] row;
            for (Component c : row = componentArray[i]) {
                double cX = c.x();
                double cY = c.y();
                if (!(x >= cX) || !(y >= cY) || !(x < cX + c.width()) || !(y < cY + c.height())) continue;
                return c.mouseable(x - cX, y - cY);
            }
        }
        return false;
    }

    public boolean click(double x, double y) {
        Vec2d offs = this.getPos();
        x -= offs.x;
        y -= offs.y;
        Component[][] componentArray = this.components;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component[] row;
            for (Component c : row = componentArray[i]) {
                double cX = c.x();
                double cY = c.y();
                if (!(x >= cX) || !(y >= cY) || !(x < cX + c.width()) || !(y < cY + c.height()) || !c.click(cX - x, cY - y)) continue;
                return true;
            }
        }
        return false;
    }

    public void keyTyped(KeyEvent event) {
        Component[][] componentArray = this.components;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component[] row;
            for (Component c : row = componentArray[i]) {
                if (!c.keyTyped(event)) continue;
                return;
            }
        }
    }

    public String export() {
        String toReturn = this.exportFunc.apply(this);
        if (this.connections.containsKey("next")) {
            return toReturn + "\n" + this.connections.get((Object)"next").parent.export();
        }
        return toReturn;
    }

    public static String getExport(Block block, String connection) {
        return block.connections.get((Object)connection).parent.export();
    }
}

