/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.editor;

import com.kyfexuwu.m3we.editor.Block;
import com.kyfexuwu.m3we.editor.BlockFactory;
import com.kyfexuwu.m3we.editor.Color;
import com.kyfexuwu.m3we.editor.component.ComponentFactory;
import com.kyfexuwu.m3we.editor.component.blueprint.Blueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class BlockOptions
implements BlockFactory {
    private Color color = new Color(200, 200, 200);
    private static Function<Block, String> defaultFunc = b -> "";
    private Function<Block, String> exportFunc = defaultFunc;
    private ArrayList<ArrayList<ComponentFactory>> components = new ArrayList();
    private final Type type;
    private boolean precreated = false;
    private ComponentFactory[][] blueprintArr;

    public BlockOptions(Type type) {
        this.type = type;
    }

    public BlockOptions color(Color color) {
        this.color = color;
        return this;
    }

    public Color color() {
        return this.color;
    }

    public BlockOptions export(Function<Block, String> exportFunc) {
        this.exportFunc = exportFunc;
        return this;
    }

    public Function<Block, String> export() {
        return this.exportFunc;
    }

    public BlockOptions components(ArrayList<ArrayList<ComponentFactory>> components) {
        this.components = components;
        return this;
    }

    public BlockOptions insertRow(int index, ArrayList<ComponentFactory> row) {
        this.components.add(index, row);
        return this;
    }

    public BlockOptions insertRow(int index, ComponentFactory ... row) {
        return this.insertRow(index, BlockOptions.fromArr(row));
    }

    public BlockOptions replaceRow(int index, ArrayList<ComponentFactory> row) {
        this.components.set(index, row);
        return this;
    }

    public BlockOptions replaceRow(int index, ComponentFactory ... row) {
        return this.replaceRow(index, BlockOptions.fromArr(row));
    }

    public BlockOptions appendRow(ArrayList<ComponentFactory> row) {
        this.components.add(row);
        return this;
    }

    public BlockOptions appendRow(ComponentFactory ... row) {
        return this.appendRow(BlockOptions.fromArr(row));
    }

    public static ArrayList<ComponentFactory> fromArr(ComponentFactory[] arr) {
        return new ArrayList<ComponentFactory>(List.of(arr));
    }

    public BlockOptions preCreate() {
        ArrayList<ComponentFactory> row;
        int y;
        if (this.precreated) {
            return this;
        }
        this.precreated = true;
        ArrayList<ComponentFactory> l1 = BlockOptions.fromArr(new ComponentFactory[]{Blueprint.SOLID, Blueprint.SOLID, Blueprint.SOLID});
        if (this.type == Type.SEQ_IN || this.type == Type.SEQ) {
            l1.add(1, Blueprint.seq("prev"));
        }
        this.insertRow(0, l1);
        ArrayList<ComponentFactory> l2 = BlockOptions.fromArr(new ComponentFactory[]{Blueprint.SOLID, Blueprint.SOLID, Blueprint.SOLID});
        if (this.type == Type.SEQ_OUT || this.type == Type.SEQ) {
            l2.add(1, Blueprint.seq("next"));
        }
        this.appendRow(l2);
        for (y = 0; y < this.components.size(); ++y) {
            row = this.components.get(y);
            if (y == 0 || y == this.components.size() - 1) continue;
            ComponentFactory first = row.get(0);
            ComponentFactory last = row.get(row.size() - 1);
            boolean firstIsInput = first instanceof Blueprint.InputMarker;
            if (!firstIsInput && !first.equals(Blueprint.SOLID)) {
                row.add(0, Blueprint.SOLID);
            }
            if ((last instanceof Blueprint.InputMarker || last.equals(Blueprint.SOLID)) && (!firstIsInput || row.size() != 1)) continue;
            row.add(Blueprint.SOLID);
        }
        this.blueprintArr = new ComponentFactory[this.components.size()][];
        for (y = 0; y < this.components.size(); ++y) {
            row = this.components.get(y);
            this.blueprintArr[y] = new ComponentFactory[row.size()];
            for (int x = 0; x < row.size(); ++x) {
                this.blueprintArr[y][x] = row.get(x);
            }
        }
        return this;
    }

    public ComponentFactory[][] blueprintArr() {
        this.preCreate();
        return this.blueprintArr;
    }

    @Override
    public Block create() {
        this.preCreate();
        return new Block(this.color, this.blueprintArr(), this.exportFunc);
    }

    public static enum Type {
        SEQ,
        SEQ_IN,
        SEQ_OUT,
        NONE;

    }
}

