/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.editor;

import com.kyfexuwu.m3we.editor.Block;
import com.kyfexuwu.m3we.editor.KeyEvent;
import com.kyfexuwu.m3we.editor.Vec2d;
import com.kyfexuwu.m3we.editor.component.connection.Connection;
import com.kyfexuwu.m3we.editor.component.connection.InlineInputInConnection;
import com.kyfexuwu.m3we.editor.component.connection.InputInConnection;
import com.kyfexuwu.m3we.editor.component.connection.InputOutConnection;
import com.kyfexuwu.m3we.editor.component.connection.SeqInConnection;
import com.kyfexuwu.m3we.editor.component.connection.SeqOutConnection;
import com.kyfexuwu.m3we.editor.customblocks.Blocks;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class LuaEditorScreen
extends class_437 {
    private final ArrayList<Block> blocks = new ArrayList();
    private Block focused;
    private float scale = 0.7f;
    private final ClickData clickData = new ClickData();
    private static final float radius = 20.0f;

    protected LuaEditorScreen(class_2561 title) {
        super(title);
        this.blocks.add(Blocks.PRINT.create());
        this.blocks.add(Blocks.PRINT.create());
        this.blocks.add(Blocks.PRINT.create());
        this.blocks.add(Blocks.PRINT.create());
        this.blocks.add(Blocks.PLUS.create());
        this.blocks.add(Blocks.STRING.create());
        this.blocks.add(Blocks.FUNCTION.create());
        this.blocks.add(Blocks.IF.create());
    }

    public static LuaEditorScreen create() {
        return new LuaEditorScreen((class_2561)class_2561.method_43470((String)"Editor"));
    }

    public void method_25393() {
        super.method_25393();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        matrices.method_22903();
        matrices.method_22905(this.scale, this.scale, 1.0f);
        if (this.clickData.block != null) {
            if (!this.clickData.disconnected) {
                Vec2d pos = this.clickData.block.getPos();
                double x = pos.x - ((double)mouseX - this.clickData.xOffs) / (double)this.scale;
                double y = pos.y - ((double)mouseX - this.clickData.yOffs) / (double)this.scale;
                double dist = Math.sqrt(x * x + y * y);
                if (dist > 5.0) {
                    this.clickData.block.disconnectFromParents();
                    this.clickData.disconnected = true;
                }
            }
            if (this.clickData.disconnected) {
                this.clickData.block.offset(((double)mouseX - this.clickData.xOffs) / (double)this.scale, ((double)mouseY - this.clickData.yOffs) / (double)this.scale);
            }
        }
        for (Block block : this.blocks) {
            block.draw(matrices, this.field_22793, (int)((float)mouseX / this.scale), (int)((float)mouseY / this.scale));
        }
        matrices.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        double oldMouseX = mouseX;
        double oldMouseY = mouseY;
        mouseX /= (double)this.scale;
        mouseY /= (double)this.scale;
        for (Block block : this.blocks) {
            if (!block.mouse(mouseX, mouseY)) continue;
            Vec2d pos = block.getPos();
            this.clickData.copy(new ClickData((mouseX - pos.x) * (double)this.scale, (mouseY - pos.y) * (double)this.scale, block.offset(), block, oldMouseX, oldMouseY));
            return true;
        }
        return super.method_25402(oldMouseX, oldMouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.focused = this.clickData.block;
        if (this.clickData.block == null) {
            return super.method_25406(mouseX, mouseY, button);
        }
        if (!this.clickData.disconnected) {
            return true;
        }
        if (this.clickData.mouseX == mouseX && this.clickData.mouseY == mouseY && this.clickData.block.click(mouseX / (double)this.scale, mouseY / (double)this.scale)) {
            this.clickData.block = null;
            return true;
        }
        ArrayList<class_3545> possibleConnections = new ArrayList<class_3545>();
        for (Connection connection : this.clickData.block.connections.values()) {
            double dist;
            Vec2d c2Pos;
            Vec2d thisPos;
            if (connection instanceof SeqInConnection) {
                thisPos = connection.globalConnPos();
                for (Block block : this.blocks) {
                    if (block == this.clickData.block) continue;
                    for (Connection c2 : block.connections.values()) {
                        if (!(c2 instanceof SeqOutConnection)) continue;
                        c2Pos = c2.globalConnPos();
                        dist = Math.sqrt((thisPos.x - c2Pos.x) * (thisPos.x - c2Pos.x) + (thisPos.y - c2Pos.y) * (thisPos.y - c2Pos.y));
                        if (!(dist < 20.0)) continue;
                        possibleConnections.add(new class_3545((Object)dist, (Object)new class_3545((Object)connection, (Object)c2)));
                    }
                }
            }
            if (!(connection instanceof InputOutConnection)) continue;
            thisPos = connection.globalConnPos();
            for (Block block : this.blocks) {
                if (block == this.clickData.block) continue;
                for (Connection c2 : block.connections.values()) {
                    if (!(c2 instanceof InputInConnection) && !(c2 instanceof InlineInputInConnection)) continue;
                    c2Pos = c2.globalConnPos();
                    dist = Math.sqrt((thisPos.x - c2Pos.x) * (thisPos.x - c2Pos.x) + (thisPos.y - c2Pos.y) * (thisPos.y - c2Pos.y));
                    if (!(dist < 20.0)) continue;
                    possibleConnections.add(new class_3545((Object)dist, (Object)new class_3545((Object)connection, (Object)c2)));
                }
            }
        }
        this.clickData.block = null;
        if (possibleConnections.size() == 0) {
            return super.method_25406(mouseX, mouseY, button);
        }
        possibleConnections.sort((p1, p2) -> {
            double val = (Double)p1.method_15442() - (Double)p2.method_15442();
            if (val == 0.0) {
                return 0;
            }
            if (val > 0.0) {
                return 1;
            }
            return -1;
        });
        class_3545 pair = (class_3545)((class_3545)possibleConnections.get(0)).method_15441();
        ((Connection)pair.method_15442()).connect((Connection)pair.method_15441());
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.focused != null) {
            switch (keyCode) {
                case 259: {
                    this.focused.keyTyped(new KeyEvent(KeyEvent.Type.BACKSPACE));
                }
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.focused != null) {
            this.focused.keyTyped(new KeyEvent(chr));
        }
        return super.method_25400(chr, modifiers);
    }

    private static class ClickData {
        public double xOffs;
        public double yOffs;
        public Vec2d origPos;
        public Block block;
        public double mouseX;
        public double mouseY;
        public boolean disconnected;

        public void copy(ClickData data) {
            this.xOffs = data.xOffs;
            this.yOffs = data.yOffs;
            this.origPos = data.origPos;
            this.block = data.block;
            this.mouseX = data.mouseX;
            this.mouseY = data.mouseY;
            this.disconnected = data.disconnected;
        }

        public ClickData(double xOffs, double yOffs, Vec2d origPos, Block block, double mouseX, double mouseY) {
            this.xOffs = xOffs;
            this.yOffs = yOffs;
            this.origPos = origPos;
            this.block = block;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.disconnected = false;
        }

        public ClickData() {
        }
    }
}

