/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.editor.component;

import com.kyfexuwu.m3we.editor.Block;
import com.kyfexuwu.m3we.editor.Color;
import com.kyfexuwu.m3we.editor.KeyEvent;
import com.kyfexuwu.m3we.editor.Vec2d;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public abstract class Component {
    public final Block parent;

    public Component(Block parent) {
        this.parent = parent;
    }

    public double x() {
        for (Component[] row : this.parent.components) {
            int x = 0;
            for (Component c : row) {
                if (c == this) {
                    return x;
                }
                x = (int)((double)x + c.width());
            }
        }
        return 0.0;
    }

    public double y() {
        double y = 0.0;
        Component[][] componentArray = this.parent.components;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component[] row;
            for (Component c : row = componentArray[i]) {
                if (c != this) continue;
                return y;
            }
            if (row.length <= 0) continue;
            double height = 0.0;
            for (Component c : row) {
                height = Math.max(c.height(), height);
            }
            y += height;
        }
        return 0.0;
    }

    public Vec2d globalPos() {
        Vec2d pos = this.parent.getPos();
        return new Vec2d(this.x() + pos.x, this.y() + pos.y);
    }

    public abstract double width(boolean var1);

    public double width() {
        return this.width(false);
    }

    public abstract double height(boolean var1);

    public double height() {
        return this.height(false);
    }

    public boolean mouseable(double localX, double localY) {
        return true;
    }

    public boolean click(double x, double y) {
        return false;
    }

    public boolean keyTyped(KeyEvent event) {
        return false;
    }

    public abstract void draw(class_4587 var1, class_327 var2, Color var3);

    public static Component[] getRow(Component component) {
        Component[][] componentArray = component.parent.components;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component[] row;
            for (Component c : row = componentArray[i]) {
                if (c != component) continue;
                return row;
            }
        }
        return null;
    }

    public static double rowHeight(Component[] row) {
        if (row.length == 0) {
            return 0.0;
        }
        double height = 0.0;
        for (Component c : row) {
            height = Math.max(c.height(true), height);
        }
        return height;
    }

    public static double rowWidth(Component[] row) {
        if (row.length == 0) {
            return 0.0;
        }
        double width = 0.0;
        for (Component c : row) {
            width += c.width(true);
        }
        return width;
    }

    public static double fillRowWidth(Component component, boolean isolated, double dfault) {
        if (isolated) {
            return dfault;
        }
        double w = 0.0;
        for (Component[] componentArray : component.parent.components) {
            w = Math.max(w, Component.rowWidth(componentArray));
        }
        for (Component[] componentArray : Component.getRow(component)) {
            if (componentArray == component) continue;
            w -= componentArray.width();
        }
        return w;
    }

    public static double fillRowHeight(Component component, boolean isolated, double dfault) {
        return isolated ? dfault : Component.rowHeight(Component.getRow(component));
    }

    public static <T> boolean arrContains(T val, T[] arr) {
        for (T v : arr) {
            if (!val.equals(v)) continue;
            return true;
        }
        return false;
    }
}

