/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.initializers;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.kyfexuwu.m3we.Json;
import com.kyfexuwu.m3we.Utils;
import com.kyfexuwu.m3we.initializers.CustomBlockMaker;
import com.kyfexuwu.m3we.initializers.InitUtils;
import com.kyfexuwu.m3we.lua.CustomScript;
import com.kyfexuwu.m3we.m3we;
import com.kyfexuwu.m3we.m3weData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import org.luaj.vm2.LuaValue;

public class BlockIniter {
    private static final class_3614 starterMaterial = new class_3614.class_3615(class_3620.field_16008).method_15813();
    private static final BlockPropertyTranslator<?>[] blockPropertyMap = new BlockPropertyTranslator[]{new BlockPropertyTranslator<Float>("hardness", class_4970.class_2251::method_36557, InitUtils.FloatTransformFunc, class_4970::method_36555), new BlockPropertyTranslator<Float>("resistance", class_4970.class_2251::method_36558, InitUtils.FloatTransformFunc, class_2248::method_9520), new BlockPropertyTranslator<Float>("slipperiness", class_4970.class_2251::method_9628, InitUtils.FloatTransformFunc, class_2248::method_9499), new BlockPropertyTranslator<Float>("jumpMultiplier", class_4970.class_2251::method_23352, InitUtils.FloatTransformFunc, class_2248::method_23350), new BlockPropertyTranslator<Float>("speedMultiplier", class_4970.class_2251::method_23351, InitUtils.FloatTransformFunc, class_2248::method_23349), new BlockPropertyTranslator<class_2498>("sounds", class_4970.class_2251::method_9626, SAV -> {
        try {
            return (class_2498)class_2498.class.getField(SAV.value.getAsString()).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return class_2498.field_11544;
        }
    }, block -> block.method_9564().method_26231()), new BlockPropertyTranslator<Boolean>("hasTransparentTexture", (settings, isTransparent) -> isTransparent != false ? settings.method_22488() : settings, InitUtils.BoolTransformFunc, block -> block.method_9564().method_26225()), new BlockPropertyTranslator<ToIntFunction>("luminance", class_4970.class_2251::method_9631, SAV -> {
        if (SAV.value.getAsString().startsWith("script:")) {
            return state -> Utils.tryAndExecute(0, SAV.script, SAV.value.getAsString().substring(7), new Object[]{state}, LuaValue::checkint);
        }
        return value -> SAV.value.getAsInt();
    }, block -> class_4970.class_4971::method_26213), new BlockPropertyTranslator<class_3620>("mapColor", class_4970.class_2251::method_31710, SAV -> {
        try {
            return (class_3620)class_3620.class.getField(SAV.value.getAsString()).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return class_3620.field_16008;
        }
    }, class_4970::method_26403), new BlockPropertyTranslator<Boolean>("isToolRequired", (settings, toolRequired) -> toolRequired != false ? settings.method_29292() : settings, InitUtils.BoolTransformFunc, block -> block.method_9564().method_29291()), new BlockPropertyTranslator<Boolean>("ticksRandomly", (settings, randomlyTicks) -> randomlyTicks != false ? settings.method_9640() : settings, InitUtils.BoolTransformFunc, block -> block.method_9564().method_26229()), new BlockPropertyTranslator<Boolean>("isAir", (settings, isAir) -> isAir != false ? settings.method_26250() : settings, InitUtils.BoolTransformFunc, block -> block.method_9564().method_26215()), new BlockPropertyTranslator<Boolean>("isCollidable", (settings, collidable) -> collidable != false ? settings : settings.method_9634(), InitUtils.BoolTransformFunc, block -> !block.method_9564().method_26220((class_1922)class_2682.field_12294, class_2338.field_10980).method_1110()), new BlockPropertyTranslator<Boolean>("blockCollisionCanResize", (settings, dynBounds) -> dynBounds != false ? settings : settings.method_9624(), InitUtils.BoolTransformFunc, class_2248::method_9543), new BlockPropertyTranslator<class_4970.class_4973>("isSolidWhen", class_4970.class_2251::method_26236, SAV -> InitUtils.PredTransformFunc(SAV, true), block -> (state, world, pos) -> state.method_26207().method_15804() && state.method_26234(world, pos)), new BlockPropertyTranslator<class_4970.class_4972>("allowsSpawningWhen", class_4970.class_2251::method_26235, SAV -> {
        if (SAV.value.getAsString().startsWith("script:")) {
            return (state, world, pos, type) -> Utils.tryAndExecute(true, SAV.script, SAV.value.getAsString().substring(7), new Object[]{state, world, pos, type}, LuaValue::checkboolean);
        }
        return (state, world, pos, type) -> SAV.value.getAsBoolean();
    }, block -> (state, world, pos, type) -> state.method_26206(world, pos, class_2350.field_11036) && state.method_26213() < 14), new BlockPropertyTranslator<class_4970.class_4973>("visionBlockedWhen", class_4970.class_2251::method_26245, SAV -> InitUtils.PredTransformFunc(SAV, false), block -> (state, world, pos) -> block.method_9564().method_26207().method_15801() && state.method_26234(world, pos)), new BlockPropertyTranslator<class_4970.class_4973>("suffocatesWhen", class_4970.class_2251::method_26243, SAV -> InitUtils.PredTransformFunc(SAV, false), block -> (state, world, pos) -> block.method_9564().method_26207().method_15801() && state.method_26234(world, pos)), new BlockPropertyTranslator<class_4970.class_4973>("emissiveLightingWhen", class_4970.class_2251::method_26249, SAV -> InitUtils.PredTransformFunc(SAV, false), block -> (state, world, pos) -> false), new BlockPropertyTranslator<class_4970.class_4973>("postProcessWhen", class_4970.class_2251::method_26247, SAV -> InitUtils.PredTransformFunc(SAV, false), block -> (state, world, pos) -> false)};

    public static InitUtils.SuccessAndIdentifier blockFromFile(File file) {
        String blockName;
        JsonObject blockJsonData;
        if (!file.canRead()) {
            return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.CANT_READ);
        }
        try {
            blockJsonData = (JsonObject)Json.GSON.fromJson(Files.readString(file.toPath()), JsonObject.class);
        }
        catch (JsonSyntaxException | IOException e) {
            return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.BAD_JSON);
        }
        try {
            blockName = blockJsonData.get("blockName").getAsString();
        }
        catch (Exception ignored) {
            return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.BAD_JSON);
        }
        if (!InitUtils.validPathName.matcher(blockName).matches()) {
            return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.BAD_JSON);
        }
        class_4970.class_2251 settings = class_4970.class_2251.method_9637((class_3614)starterMaterial);
        String scriptName = InitUtils.getOr(blockJsonData, "script", new JsonPrimitive("")).getAsString();
        CustomScript tempScript = new CustomScript(scriptName);
        String copyFromName = InitUtils.getOr(blockJsonData, "copyFrom", new JsonPrimitive("")).getAsString();
        Optional copyFromBlockOptional = class_2378.field_11146.method_17966(new class_2960(copyFromName));
        class_2248 copyFrom = copyFromBlockOptional.orElseGet(() -> m3we.m3weBlocks.get(copyFromName));
        if (!copyFromName.isEmpty() && copyFrom == null) {
            return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.COME_BACK_LATER);
        }
        for (BlockPropertyTranslator<?> propToTranslate : blockPropertyMap) {
            if (!blockJsonData.has(propToTranslate.jsonProp)) {
                if (copyFrom == null) continue;
                settings = propToTranslate.applyDefault(settings, copyFrom);
                continue;
            }
            settings = propToTranslate.apply(settings, blockJsonData, tempScript);
        }
        tempScript.remove();
        class_2248 thisBlock = CustomBlockMaker.from(settings, copyFrom, blockJsonData, scriptName, blockJsonData.has("blockEntityScript") ? blockJsonData.get("blockEntityScript").getAsString() : null);
        String namespace = "m3we";
        if (blockJsonData.has("namespace") && InitUtils.validNamespaceName.matcher(blockJsonData.get("namespace").getAsString()).matches()) {
            namespace = blockJsonData.get("namespace").getAsString();
        }
        class_2960 thisId = new class_2960(namespace, blockName);
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)thisId, (Object)thisBlock);
        m3we.m3weBlocks.put(namespace + ":" + blockName, thisBlock);
        m3weData.packNamespaces.add(namespace);
        return new InitUtils.SuccessAndIdentifier(InitUtils.SuccessRate.YOU_DID_IT, thisId);
    }

    private static class BlockPropertyTranslator<T>
    extends InitUtils.PropertyTranslator<T, class_4970.class_2251, class_2248> {
        public BlockPropertyTranslator(String jsonProp, BiFunction<class_4970.class_2251, T, class_4970.class_2251> toJavaFunc, Function<InitUtils.ScriptAndValue, T> transformFunc, Function<class_2248, T> getDefaultFunc) {
            super(jsonProp, toJavaFunc, transformFunc, getDefaultFunc);
        }
    }
}

