/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.lua;

import com.kyfexuwu.m3we.Utils;
import com.kyfexuwu.m3we.lua.LuaFunctionalInterface;
import com.kyfexuwu.m3we.lua.Translations;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;
import oshi.util.tuples.Pair;

public class UndecidedLuaFunction
extends VarArgFunction {
    public Object thisObj;
    public Executable[] methods;
    public static final String CONSTRUCTOR_ID = "constructor";

    public UndecidedLuaFunction(Object thisObj, Executable[] methods) {
        this.thisObj = thisObj;
        this.methods = methods;
    }

    public String typename() {
        return "undecidedFunc";
    }

    public LuaValue call() {
        return this.figureAndCall(new LuaValue[0]);
    }

    public LuaValue call(LuaValue arg) {
        return this.figureAndCall(arg);
    }

    public LuaValue call(LuaValue arg1, LuaValue arg2) {
        return this.figureAndCall(arg1, arg2);
    }

    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
        return this.figureAndCall(arg1, arg2, arg3);
    }

    public Varargs invoke(Varargs varargs) {
        LuaValue[] values = new LuaValue[varargs.narg()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = varargs.arg(i + 1);
        }
        return this.figureAndCall(values);
    }

    public LuaValue figureAndCall(LuaValue ... args) {
        Object[] translatedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            translatedArgs[i] = Utils.toObject(args[i]);
        }
        for (Executable method : this.methods) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            int numParamsAmt = 0;
            int[] numParamsIndexes = new int[args.length];
            boolean matches = true;
            block12: for (int i = 0; i < args.length; ++i) {
                if (LuaFunctionalInterface.isFunctionalInterface(paramTypes[i])) {
                    if (!(args[i] instanceof LuaFunction)) {
                        matches = false;
                        break;
                    }
                    translatedArgs[i] = LuaFunctionalInterface.createFunctionalInterface((LuaFunction)args[i], paramTypes[i]);
                    continue;
                }
                if (translatedArgs[i] == null || translatedArgs[i] instanceof Boolean && paramTypes[i].equals(Boolean.TYPE)) continue;
                if (translatedArgs[i] instanceof String && Enum.class.isAssignableFrom(paramTypes[i])) {
                    ?[] enums;
                    for (Object val : enums = paramTypes[i].getEnumConstants()) {
                        if (!((Enum)val).name().toLowerCase(Locale.ROOT).equals(((String)translatedArgs[i]).toLowerCase(Locale.ROOT))) continue;
                        translatedArgs[i] = val;
                        continue block12;
                    }
                    continue;
                }
                if (translatedArgs[i] instanceof String && paramTypes[i].equals(Character.TYPE) && ((String)translatedArgs[i]).length() == 1) {
                    translatedArgs[i] = Character.valueOf(((String)translatedArgs[i]).charAt(0));
                    continue;
                }
                if (translatedArgs[i] instanceof Double) {
                    if (paramTypes[i].equals(Integer.TYPE)) {
                        translatedArgs[i] = ((Double)translatedArgs[i]).intValue();
                        continue;
                    }
                    if (paramTypes[i].equals(Float.TYPE)) {
                        translatedArgs[i] = Float.valueOf(((Double)translatedArgs[i]).floatValue());
                        continue;
                    }
                    if (paramTypes[i].equals(Double.TYPE)) {
                        translatedArgs[i] = (Double)translatedArgs[i];
                        continue;
                    }
                    if (paramTypes[i].equals(Long.TYPE)) {
                        translatedArgs[i] = ((Double)translatedArgs[i]).longValue();
                        continue;
                    }
                    if (paramTypes[i].equals(Short.TYPE)) {
                        translatedArgs[i] = ((Double)translatedArgs[i]).shortValue();
                        continue;
                    }
                    if (paramTypes[i].equals(Byte.TYPE)) {
                        translatedArgs[i] = ((Double)translatedArgs[i]).byteValue();
                        continue;
                    }
                    numParamsIndexes[numParamsAmt] = i;
                    ++numParamsAmt;
                }
                if (paramTypes[i].isAssignableFrom(translatedArgs[i].getClass())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            int amtOfTries = (int)Math.pow(6.0, numParamsAmt);
            for (int i = 0; i < amtOfTries; ++i) {
                Object[] changeableArgs = Arrays.copyOf(translatedArgs, translatedArgs.length);
                block15: for (int j = 0; j < numParamsAmt; ++j) {
                    switch (i / (int)Math.pow(6.0, j) % 6) {
                        case 0: {
                            changeableArgs[numParamsIndexes[j]] = (double)((Double)changeableArgs[numParamsIndexes[j]]);
                            continue block15;
                        }
                        case 1: {
                            changeableArgs[numParamsIndexes[j]] = Float.valueOf(((Double)changeableArgs[numParamsIndexes[j]]).floatValue());
                            continue block15;
                        }
                        case 2: {
                            changeableArgs[numParamsIndexes[j]] = ((Double)changeableArgs[numParamsIndexes[j]]).intValue();
                            continue block15;
                        }
                        case 3: {
                            changeableArgs[numParamsIndexes[j]] = ((Double)changeableArgs[numParamsIndexes[j]]).longValue();
                            continue block15;
                        }
                        case 4: {
                            changeableArgs[numParamsIndexes[j]] = ((Double)changeableArgs[numParamsIndexes[j]]).byteValue();
                            continue block15;
                        }
                        case 5: {
                            changeableArgs[numParamsIndexes[j]] = ((Double)changeableArgs[numParamsIndexes[j]]).shortValue();
                        }
                    }
                }
                try {
                    if (method instanceof Method) {
                        return Utils.toLuaValue(((Method)method).invoke(this.thisObj, changeableArgs));
                    }
                    return Utils.toLuaValue(((Constructor)method).newInstance(changeableArgs));
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        throw new LuaError("Function \"" + this.funcName() + "\" called with incorrect arguments");
    }

    public String funcName() {
        return Utils.deobfuscate(this.methods[0].getName());
    }

    public String toString() {
        return "java function " + this.methods[0].getName();
    }

    public List<MethodDescriptor> methodDescribers() {
        Executable[] refMethods;
        ArrayList<MethodDescriptor> toReturn = new ArrayList<MethodDescriptor>();
        for (Executable m : refMethods = this.methods) {
            Translations.MethodToken token = m instanceof Method ? Translations.getToken((Method)m) : new Translations.MethodToken("<init>", "<init>", "type", new String[]{"p1", "p2", "p3"});
            ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
            for (int i = 0; i < token.paramNames.length; ++i) {
                params.add(new Pair((Object)token.paramNames[i], (Object)token.paramClasses[i]));
            }
            String returnClass = Utils.deobfuscate(this.thisObj.getClass().getSimpleName());
            if (m instanceof Method) {
                Method method = (Method)m;
                returnClass = Utils.deobfuscate(method.getReturnType().getSimpleName());
            }
            toReturn.add(new MethodDescriptor(params, returnClass, m instanceof Method ? MethodType.METHOD : MethodType.CONSTRUCTOR));
        }
        return toReturn;
    }

    public record MethodDescriptor(List<Pair<String, String>> params, String returnClass, MethodType type) {
    }

    public static enum MethodType {
        METHOD,
        CONSTRUCTOR;

    }
}

