/*
 * Decompiled with CFR 0.152.
 */
package com.kyfexuwu.m3we.lua.api;

import com.kyfexuwu.m3we.Utils;
import com.kyfexuwu.m3we.lua.CustomScript;
import com.kyfexuwu.m3we.lua.ScriptError;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.TwoArgFunction;

public class DatastoreAPI
extends TwoArgFunction {
    public static DatastoreTable table = new DatastoreTable();

    public LuaValue call(LuaValue modname, LuaValue env) {
        return CustomScript.finalizeAPI("Datastore", (LuaValue)table, env);
    }

    public static class DatastoreTable
    extends LuaTable {
        HashMap<String, LuaValue> values = new HashMap();

        public static LuaValue fromNBTVal(class_2520 nbt, LuaTable tableToWrite) {
            if (nbt instanceof class_2519) {
                return LuaValue.valueOf((String)nbt.method_10714());
            }
            if (nbt instanceof class_2489) {
                return LuaValue.valueOf((double)((class_2489)nbt).method_10697());
            }
            if (nbt instanceof class_2494) {
                return LuaValue.valueOf((double)((class_2494)nbt).method_10697());
            }
            if (nbt instanceof class_2497) {
                return LuaValue.valueOf((double)((class_2497)nbt).method_10697());
            }
            if (nbt instanceof class_2481) {
                return LuaValue.valueOf((double)((class_2481)nbt).method_10697());
            }
            if (nbt instanceof class_2487) {
                LuaTable table = tableToWrite == null ? new DatastoreTable() : tableToWrite;
                Set keys = ((class_2487)nbt).method_10541();
                keys.forEach(key -> {
                    LuaTable tableToGive = null;
                    if (tableToWrite != null) {
                        try {
                            tableToGive = (LuaTable)tableToWrite.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    table.set(key, DatastoreTable.fromNBTVal(((class_2487)nbt).method_10580(key), tableToGive));
                });
                return table;
            }
            return NIL;
        }

        public Optional<class_2520> toNBT() {
            return DatastoreTable.toNBT((LuaValue)this);
        }

        public static Optional<class_2520> toNBT(LuaValue val) {
            if (val instanceof LuaString) {
                return Optional.of(class_2519.method_23256((String)val.checkjstring()));
            }
            if (val instanceof LuaBoolean) {
                return Optional.of(class_2481.method_23234((boolean)val.checkboolean()));
            }
            if (val instanceof LuaNumber) {
                return Optional.of(class_2489.method_23241((double)val.checkdouble()));
            }
            if (val instanceof DatastoreTable) {
                class_2487 table = new class_2487();
                ((DatastoreTable)val).values.forEach((key, value) -> {
                    Optional<class_2520> toAssign = DatastoreTable.toNBT(value);
                    toAssign.ifPresent(nbtElement -> table.method_10566(key, nbtElement));
                });
                return Optional.of(table);
            }
            if (val instanceof LuaTable) {
                class_2487 table = new class_2487();
                Utils.forEach((LuaValue)((LuaTable)val), (key, value) -> {
                    Optional<class_2520> toPut = DatastoreTable.toNBT(value);
                    if (toPut.isPresent() && (key instanceof LuaString || key instanceof LuaNumber)) {
                        table.method_10566(key.strvalue().checkjstring(), toPut.get());
                    }
                    return null;
                });
                return Optional.of(table);
            }
            return Optional.empty();
        }

        public void set(int key, LuaValue value) {
            this.rawset(key, value);
        }

        public void set(LuaValue key, LuaValue value) {
            this.rawset(key, value);
        }

        public void rawset(int key, LuaValue value) {
            this.rawset((LuaValue)LuaValue.valueOf((int)key), value);
        }

        public static boolean validate(LuaValue val) {
            if (val instanceof LuaBoolean || val instanceof LuaNumber || val instanceof LuaString || val.isnil()) {
                return true;
            }
            if (val instanceof LuaTable) {
                AtomicBoolean toReturn = new AtomicBoolean(true);
                Utils.forEach((LuaValue)((LuaTable)val), (key, value) -> {
                    if (!(key instanceof LuaString) && !(key instanceof LuaNumber)) {
                        toReturn.set(false);
                        return false;
                    }
                    if (!DatastoreTable.validate(value)) {
                        toReturn.set(false);
                        return false;
                    }
                    return null;
                });
                return toReturn.get();
            }
            return false;
        }

        public static LuaValue cleanup(LuaValue toClean) {
            if (toClean instanceof LuaBoolean || toClean instanceof LuaNumber || toClean instanceof LuaString || toClean instanceof DatastoreTable || toClean.isnil()) {
                return toClean;
            }
            DatastoreTable toReturn = new DatastoreTable();
            if (toClean instanceof LuaTable) {
                Utils.forEach((LuaValue)((LuaTable)toClean), (key, value) -> {
                    toReturn.set((LuaValue)key, DatastoreTable.cleanup(value));
                    return null;
                });
                return toReturn;
            }
            return NIL;
        }

        public void rawset(LuaValue key, LuaValue value) {
            ScriptError.execute(() -> {
                if (!key.isstring() && !key.isnumber() || !DatastoreTable.validate(value)) {
                    throw new LuaError("key must be a string or number, and values must be string, boolean, number, or table");
                }
                this.values.put(key.strvalue().checkjstring(), DatastoreTable.cleanup(value));
            }, e -> CustomScript.print("client", "Couldn't set datastore value! " + e.getMessage()));
        }

        public LuaValue get(int key) {
            return this.rawget(key);
        }

        public LuaValue get(LuaValue key) {
            return this.rawget(key);
        }

        public LuaValue rawget(int key) {
            return this.rawget((LuaValue)LuaValue.valueOf((int)key));
        }

        public LuaValue rawget(LuaValue key) {
            LuaValue toReturn = this.values.get(key.checkjstring());
            return toReturn == null ? NIL : toReturn;
        }

        public LuaValue remove(int pos) {
            throw new LuaError("please do not do this rn");
        }
    }
}

