/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.mixin;

import com.google.common.annotations.VisibleForTesting;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_8942;
import net.sssubtlety.anvil_crushing_recipes.AnvilCrushingRecipes;
import net.sssubtlety.anvil_crushing_recipes.mixin.EntityMixin;
import net.sssubtlety.anvil_crushing_recipes.mixin.accessor.EntityAccessor;
import net.sssubtlety.anvil_crushing_recipes.mixin_helpers.CollisionResult;
import net.sssubtlety.anvil_crushing_recipes.recipe.AnvilCrushingRecipe;
import net.sssubtlety.anvil_crushing_recipes.recipe.AnvilCrushingRecipeManager;
import net.sssubtlety.anvil_crushing_recipes.recipe.Crushable;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.BlockIngredient;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.EntityIngredient;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.GenericIngredient;
import net.sssubtlety.anvil_crushing_recipes.util.AnvilCondition;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.Util;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1540.class})
abstract class FallingAnvilMixin
extends EntityMixin {
    @Unique
    private static final String CRUSHES_KEY = "anvil_crushing_recipes:crushes";
    @Unique
    private static final String FAILED_ENTITY_CRUSHES_KEY = "anvil_crushing_recipes:failed_entity_crushes";
    @Unique
    private static final String PREVENT_ANVIL_FALL_DAMAGE_KEY = "anvil_crushing_recipes:prevent_anvil_fall_damage";
    @Unique
    private static final Codec<List<Crushable>> CRUSHES_CODEC = CodecUtil.mutableListOf(Crushable.CODEC);
    @Unique
    private static final Codec<Set<UUID>> FAILED_ENTITY_CRUSHES_CODEC = CodecUtil.mutableSetOf(CodecUtil.UUID_CODEC);
    @Unique
    private static final Codec<Boolean> PREVENT_ANVIL_FALL_DAMAGE_CODEC = Codec.BOOL;
    @Unique
    private static final float DAMAGE_TO_ANVIL_CHANCE_PER_BLOCK_FALLEN = 0.05f;
    @Shadow
    private class_2680 field_7188;
    @Unique
    private List<Crushable> crushes;
    @Unique
    private Set<UUID> failedEntityCrushes;
    @Unique
    private ThreadLocal<Boolean> entityRecipeOutputBlock;
    @Unique
    private ThreadLocal<Boolean> preventAnvilFallDamage;
    @Unique
    private double halfHeight;

    FallingAnvilMixin() {
    }

    @Unique
    private static boolean isInvulnerableTo(class_1297 entity, class_1282 source, class_3218 world) {
        boolean bl;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            bl = livingEntity.method_5679(world, source);
        } else {
            bl = ((EntityAccessor)entity).anvil_crushing_recipes$callIsAlwaysInvulnerableTo(source);
        }
        return bl;
    }

    @Shadow
    public abstract class_2680 method_6962();

    @Shadow
    public abstract void method_49181();

    @Inject(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"}, at={@At(value="TAIL")})
    private void initFields(class_1299<class_1540> type, class_1937 world, CallbackInfo ci) {
        this.crushes = new ArrayList<Crushable>();
        this.failedEntityCrushes = new HashSet<UUID>();
        this.entityRecipeOutputBlock = ThreadLocal.withInitial(() -> Boolean.FALSE);
        this.preventAnvilFallDamage = ThreadLocal.withInitial(() -> Boolean.FALSE);
        this.halfHeight = type.method_17686() / 2.0f;
    }

    @Unique
    private class_8567 createLootContextParamSet(class_3218 world, class_1282 anvilDamageSource) {
        return new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)((class_1540)this)).method_51874(class_181.field_24424, (Object)this.method_73189()).method_51874(class_181.field_1231, (Object)anvilDamageSource).method_51877(class_181.field_1230, (Object)anvilDamageSource.method_5529()).method_51877(class_181.field_1227, (Object)anvilDamageSource.method_5526()).method_51875(class_173.field_1173);
    }

    @Override
    protected class_243 tryEntityRecipes(class_1297 instance, class_243 movement, Operation<class_243> original) {
        class_238 box;
        class_3218 world;
        List overlappingEntities;
        CollisionResult collisionResult;
        class_243 adjustedMovement = (class_243)original.call(new Object[]{instance, movement});
        class_1937 class_19372 = this.getAnvilWorld();
        if (class_19372 instanceof class_3218 && (collisionResult = this.tryRecipesOnEntities(overlappingEntities = (world = (class_3218)class_19372).method_8333((class_1297)((class_1540)this), (box = this.method_5829()).method_18804(movement).method_1014(1.0E-7), class_1301.field_6155), world)) != CollisionResult.NONE) {
            this.method_5785();
            this.method_18799(class_243.field_1353);
            if (collisionResult == CollisionResult.LANDING) {
                return class_243.field_1353;
            }
        }
        return adjustedMovement;
    }

    @Override
    protected void tryRecipesPreLanding(double yMovement, boolean onGround, class_2680 landedState, class_2338 landedPosition, CallbackInfo ci) {
        class_1937 class_19372 = this.getAnvilWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (this.method_24828() && !this.isInsideBlock() && !this.entityRecipeOutputBlock.get().booleanValue() && !this.tryRecipesOnBlock(world, yMovement)) {
                this.method_24830(false);
                this.syncAnvilLandsEvent(world);
                this.method_5785();
                this.method_18799(class_243.field_1353);
            }
            this.entityRecipeOutputBlock.remove();
        }
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    private void writeAnvilFields(class_11372 writer, CallbackInfo ci) {
        if (!(this.getAnvilWorld() instanceof class_3218)) {
            return;
        }
        writer.method_71468(CRUSHES_KEY, CRUSHES_CODEC, this.crushes);
        writer.method_71468(FAILED_ENTITY_CRUSHES_KEY, FAILED_ENTITY_CRUSHES_CODEC, this.failedEntityCrushes);
        writer.method_71468(PREVENT_ANVIL_FALL_DAMAGE_KEY, PREVENT_ANVIL_FALL_DAMAGE_CODEC, (Object)this.preventAnvilFallDamage.get());
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    private void readAnvilFields(class_11368 reader, CallbackInfo ci) {
        if (!(this.getAnvilWorld() instanceof class_3218)) {
            return;
        }
        this.crushes = reader.method_71426(CRUSHES_KEY, CRUSHES_CODEC).orElseGet(ArrayList::new);
        this.failedEntityCrushes = reader.method_71426(FAILED_ENTITY_CRUSHES_KEY, FAILED_ENTITY_CRUSHES_CODEC).orElseGet(HashSet::new);
        this.preventAnvilFallDamage.set(reader.method_71426(PREVENT_ANVIL_FALL_DAMAGE_KEY, PREVENT_ANVIL_FALL_DAMAGE_CODEC).orElse(false));
    }

    @ModifyExpressionValue(method={"handleFallDamage"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/block/BlockState;isIn(Lnet/minecraft/registry/tag/TagKey;)Z")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/registry/tag/BlockTags;ANVILS:Lnet/minecraft/registry/tag/TagKey;"))})
    private boolean andNotPreventAnvilFallDamage(boolean original) {
        class_1937 class_19372 = this.getAnvilWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            boolean prevent = this.preventAnvilFallDamage.get();
            this.preventAnvilFallDamage.remove();
            return original && !prevent && this.field_6017 >= AnvilCrushingRecipes.getDamageToAnvilFallThreshold(world);
        }
        return original;
    }

    @Unique
    private boolean tryRecipesOnBlock(class_3218 world, double yMovement) {
        class_2338 anvilDestination;
        class_2680 collidedState;
        class_2338 collidedPos;
        class_2338 here = this.method_24515();
        class_2680 stateHere = this.method_73183().method_8320(here);
        boolean emptyHere = Util.isEmptyState(stateHere);
        if (emptyHere) {
            collidedPos = here.method_10074();
            collidedState = this.method_73183().method_8320(collidedPos);
            if (Util.isEmptyState(collidedState)) {
                return true;
            }
            anvilDestination = here;
        } else {
            collidedPos = here;
            collidedState = stateHere;
            anvilDestination = here.method_10084();
        }
        return this.tryRecipesOnBlockImpl(collidedState, collidedPos, anvilDestination, yMovement, world);
    }

    @Unique
    private boolean tryRecipesOnBlockImpl(class_2680 collidedState, class_2338 collidedPos, class_2338 anvilDestination, double yMovement, class_3218 world) {
        Crushable.Block crushableBlock = new Crushable.Block(collidedState, this.field_6017, this.method_18798().method_1027(), () -> {
            class_2586 blockEntity = world.method_8321(collidedPos);
            if (blockEntity == null) {
                return Optional.empty();
            }
            class_11362 writer = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)world.method_30349());
            blockEntity.method_71400((class_11372)writer);
            return Optional.of(writer.method_71475());
        });
        AnvilCrushingRecipe.MatchedCrushables matchedCrushables = this.reduceCrushesToMatch(crushableBlock, this.crushes.stream());
        this.crushes = matchedCrushables.crushes();
        @Nullable AnvilCrushingRecipe.Match match = matchedCrushables.match().orElse(null);
        if (match == null) {
            return true;
        }
        AnvilCrushingRecipe recipe = match.recipe();
        GenericIngredient<?, ?> ingredient = match.lastMatchedIngredient();
        if (!(ingredient instanceof BlockIngredient)) {
            AnvilCrushingRecipes.LOGGER.error("Received non-block lastMatchedIngredient on block collision:\n\trecipe: {}\n\tingredient: {}\n\tcrushableBlock: {}", new Object[]{recipe, ingredient, crushableBlock});
            return true;
        }
        BlockIngredient blockIngredient = (BlockIngredient)ingredient;
        blockIngredient.crush(collidedPos, Util.rollChance(recipe.finalIngredientDropChance(), world.field_9229), world);
        this.tryDamageAnvil(blockIngredient);
        this.tryPreventAnvilFallDamage(ingredient);
        double downwardMotion = -yMovement;
        if (match.full()) {
            boolean canLand = recipe.output(collidedPos, (class_2350)this.field_7188.method_11654((class_2769)class_2199.field_9883), world, collidedState, () -> this.createLootContextParamSet(world, this.getDamageSource(world)));
            if (canLand) {
                this.prepareToLandOnBlockOutput(anvilDestination, 0.0);
                return true;
            }
            this.resetFallAndDamageAnvilForNonLandingCrush(this.field_6017, downwardMotion, blockIngredient, this.field_5974, world);
            return false;
        }
        this.resetFallAndDamageAnvilForNonLandingCrush(this.field_6017, downwardMotion, blockIngredient, this.field_5974, world);
        return false;
    }

    @Unique
    private CollisionResult tryRecipesOnEntities(Collection<class_1297> overlappingEntities, class_3218 world) {
        class_1282 anvilDamageSource = this.getDamageSource(world);
        for (class_1297 overlappingEntity : overlappingEntities) {
            if (!overlappingEntity.method_5805() || this.failedEntityCrushes.contains(overlappingEntity.method_5667()) || FallingAnvilMixin.isInvulnerableTo(overlappingEntity, anvilDamageSource, world)) continue;
            double ySpace = Math.max(0.0, this.method_5829().field_1322 - overlappingEntity.method_5829().field_1325);
            double nextFallDistance = this.field_6017 + ySpace;
            Crushable.Entity crushableEntity = new Crushable.Entity(overlappingEntity.method_5864(), nextFallDistance, this.method_18798().method_1027(), () -> {
                class_11362 writer = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)world.method_30349());
                overlappingEntity.method_5647((class_11372)writer);
                return writer.method_71475();
            });
            AnvilCrushingRecipe.MatchedCrushables matchedCrushables = this.reduceCrushesToMatch(crushableEntity, this.crushes.stream());
            @Nullable AnvilCrushingRecipe.Match match = matchedCrushables.match().orElse(null);
            if (match == null) continue;
            GenericIngredient<?, ?> ingredient = match.lastMatchedIngredient();
            AnvilCrushingRecipe recipe = match.recipe();
            if (ingredient instanceof EntityIngredient) {
                EntityIngredient entityIngredient = (EntityIngredient)ingredient;
                boolean crushed = entityIngredient.tryCrush(overlappingEntity, nextFallDistance, match.full() && Util.rollChance(recipe.finalIngredientDropChance(), world.field_9229), anvilDamageSource, world);
                if (!crushed) {
                    this.crushes.clear();
                    this.failedEntityCrushes.add(overlappingEntity.method_5667());
                    return CollisionResult.COLLIDED;
                }
                this.tryDamageAnvil(entityIngredient);
                this.crushes = matchedCrushables.crushes();
                this.tryPreventAnvilFallDamage(ingredient);
                if (match.full()) {
                    class_2338 nextPos = this.getNextPos(ySpace);
                    boolean canLand = recipe.output(nextPos.method_10074(), this.method_58149(), world, null, () -> this.createLootContextParamSet(world, anvilDamageSource));
                    if (canLand) {
                        this.entityRecipeOutputBlock.set(true);
                        this.prepareToLandOnBlockOutput(nextPos, ySpace);
                        return CollisionResult.LANDING;
                    }
                    this.resetFallAndDamageAnvilForNonLandingCrush(this.field_6017 + ySpace, ySpace, entityIngredient, this.field_5974, world);
                    this.syncAnvilLandsEvent(world);
                } else {
                    this.resetFallAndDamageAnvilForNonLandingCrush(this.field_6017 + ySpace, ySpace, entityIngredient, this.field_5974, world);
                    this.syncAnvilLandsEvent(world);
                }
                return CollisionResult.COLLIDED;
            }
            AnvilCrushingRecipes.LOGGER.error("Received non-entity lastMatchedIngredient on entity collision:\n\trecipe: {}\n\tingredient: {}\n\tcrushableEntity: {}", new Object[]{recipe, ingredient, crushableEntity});
        }
        return CollisionResult.NONE;
    }

    @Unique
    private class_2338 getNextPos(double ySpace) {
        int nearestNextY;
        double exactNextY = this.method_23318() - ySpace;
        int nextY = class_3532.method_20390((double)exactNextY, (double)(nearestNextY = (int)Math.round(exactNextY))) ? nearestNextY : class_3532.method_15357((double)exactNextY);
        return new class_2338(class_3532.method_15357((double)this.method_23317()), nextY, class_3532.method_15357((double)this.method_23321()));
    }

    @Unique
    private class_1282 getDamageSource(class_3218 world) {
        return world.method_48963().method_48810((class_1297)((class_1540)this));
    }

    @Unique
    private void tryPreventAnvilFallDamage(GenericIngredient<?, ?> ingredient) {
        this.preventAnvilFallDamage.set(ingredient.settings().preventAnvilFallDamage().orElse(false));
    }

    @Unique
    private void tryDamageAnvil(GenericIngredient<?, ?> ingredient) {
        ingredient.settings().damageToAnvil().ifPresent(this::damageAnvil);
    }

    @Unique
    private void damageAnvil(int damage) {
        class_2199 thisAnvil = (class_2199)this.field_7188.method_26204();
        AnvilCondition.get(thisAnvil).map(thisCondition -> thisCondition.damage(damage).map(AnvilCondition::anvil).orElseGet(() -> {
            this.method_49181();
            return (class_2199)class_2246.field_10414;
        })).ifPresent(newAnvil -> {
            if (newAnvil != thisAnvil) {
                this.field_7188 = (class_2680)newAnvil.method_9564().method_11657((class_2769)class_2199.field_9883, (Comparable)((class_2350)this.field_7188.method_11654((class_2769)class_2199.field_9883)));
            }
        });
    }

    @Unique
    private AnvilCrushingRecipe.MatchedCrushables reduceCrushesToMatch(Crushable crushable, Stream<Crushable> crushedStream) {
        Optional<AnvilCrushingRecipe.Match> match;
        List crushes = crushedStream.collect(Collectors.toCollection(ArrayList::new));
        crushes.add(crushable);
        while (!(match = this.recipeManager().match(crushes)).isPresent()) {
            crushes.removeFirst();
            if (!crushes.isEmpty()) continue;
        }
        if (match.filter(AnvilCrushingRecipe.Match::partial).isEmpty()) {
            crushes.clear();
        }
        return new AnvilCrushingRecipe.MatchedCrushables(match, crushes);
    }

    @Override
    AnvilCrushingRecipeManager recipeManager() {
        return AnvilCrushingRecipeManager.INSTANCE;
    }

    @Unique
    private void syncAnvilLandsEvent(class_3218 world) {
        world.method_20290(1031, this.method_24515(), 0);
    }

    @Override
    @VisibleForTesting
    void resetFallAndDamageAnvilForNonLandingCrush(double fallDistance, double downwardMotion, GenericIngredient<?, ?> ingredient, class_5819 random, class_3218 world) {
        this.resetFallAndDamageAnvilForNonLandingCrushImpl(fallDistance, downwardMotion, ingredient, random, world);
    }

    @Override
    @VisibleForTesting
    void resetFallAndDamageAnvilForNonLandingCrushImpl(double fallDistance, double downwardMotion, GenericIngredient<?, ?> ingredient, class_5819 random, class_3218 world) {
        double damageToAnvilFallThreshold;
        if (!ingredient.settings().preventAnvilFallDamage().orElse(false).booleanValue() && (fallDistance += (double)1.0E-5f) >= (damageToAnvilFallThreshold = AnvilCrushingRecipes.getDamageToAnvilFallThreshold(world))) {
            int blocksFallen = class_3532.method_15384((double)fallDistance);
            if (random.method_43057() < (float)blocksFallen * 0.05f) {
                this.damageAnvil(1);
            }
        }
        this.field_6017 = -downwardMotion;
    }

    @Unique
    private void prepareToLandOnBlockOutput(class_2338 anvilDestination, double downwardMotion) {
        this.field_6017 = (int)(this.field_6017 + (double)1.0E-5f + downwardMotion);
        class_243 flushWithBottom = class_243.method_49273((class_2382)anvilDestination, (double)0.5, (double)this.halfHeight, (double)0.5);
        this.method_60949(flushWithBottom, this.method_36454(), this.method_36455());
        this.method_24830(true);
    }

    @Unique
    private boolean isInsideBlock() {
        if (this.field_5960) {
            return false;
        }
        class_238 box = this.method_33332();
        return class_2338.method_29715((class_238)box).anyMatch(blockPos -> {
            class_2680 state = this.method_73183().method_8320(blockPos);
            return !Util.isEmptyState(state) && state.method_26212((class_1922)this.method_73183(), blockPos) && class_259.method_1074((class_265)state.method_26220((class_1922)this.method_73183(), blockPos).method_1096((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), (class_265)class_259.method_1078((class_238)box), (class_247)class_247.field_16896);
        });
    }

    @Unique
    @Nullable
    private class_1937 getAnvilWorld() {
        return this.method_6962().method_26204() instanceof class_2199 ? this.method_73183() : null;
    }
}

