/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9383;
import net.sssubtlety.anvil_crushing_recipes.AnvilCrushingRecipes;
import net.sssubtlety.anvil_crushing_recipes.recipe.AnvilCrushingRecipeManager;
import net.sssubtlety.anvil_crushing_recipes.recipe.BlockOutput;
import net.sssubtlety.anvil_crushing_recipes.recipe.Crushable;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.GenericIngredient;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings.IngredientSettings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record AnvilCrushingRecipe(ImmutableList<GenericIngredient<?, ?>> ingredients, float finalIngredientDropChance, Optional<BlockOutput> blockOutput, ImmutableList<@Unmodifiable class_1799> itemOutputs, Optional<class_5321<class_52>> lootOutput, IngredientSettings.Defaults defaultIngredientSettings) {
    public static final float DEFAULT_FINAL_INGREDIENT_DROP_CHANCE = 0.0f;
    public static final Codec<GenericIngredient<?, ?>> INGREDIENT_CODEC = GenericIngredient.createCodec();
    private static final Codec<ImmutableList<GenericIngredient<?, ?>>> INGREDIENTS_CODEC = class_5699.method_36973((Codec)INGREDIENT_CODEC.listOf()).xmap(ImmutableList::copyOf, Function.identity());
    private static final Codec<ImmutableList<class_1799>> ITEM_OUTPUTS_CODEC = Codec.withAlternative((Codec)class_1799.field_51397, (Codec)class_1799.field_49267).listOf().xmap(ImmutableList::copyOf, Function.identity());
    private static final Codec<class_5321<class_52>> LOOT_OUTPUT_CODEC = class_2960.field_25139.xmap(id -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)id), class_5321::method_29177);
    public static final Codec<AnvilCrushingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)INGREDIENTS_CODEC.fieldOf("ingredients").forGetter(AnvilCrushingRecipe::ingredients), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("final_ingredient_drop_chance", (Object)Float.valueOf(0.0f)).forGetter(AnvilCrushingRecipe::finalIngredientDropChance), (App)BlockOutput.CODEC.optionalFieldOf("block_output").forGetter(AnvilCrushingRecipe::blockOutput), (App)ITEM_OUTPUTS_CODEC.optionalFieldOf("item_outputs", (Object)ImmutableList.of()).forGetter(AnvilCrushingRecipe::itemOutputs), (App)LOOT_OUTPUT_CODEC.optionalFieldOf("loot_output").forGetter(AnvilCrushingRecipe::lootOutput), (App)IngredientSettings.Defaults.CODEC.codec().optionalFieldOf("default_ingredient_settings", (Object)IngredientSettings.Defaults.EMPTY).forGetter(AnvilCrushingRecipe::defaultIngredientSettings)).apply((Applicative)instance, AnvilCrushingRecipe::of));
    public static final int GRANT_ADVANCEMENT_RADIUS = 20;
    public static final int GRANT_ADVANCEMENT_RADIUS_SQUARED = 400;

    private static AnvilCrushingRecipe of(ImmutableList<GenericIngredient<?, ?>> ingredients, float finalIngredientDropChance, Optional<BlockOutput> blockOutput, ImmutableList<@Unmodifiable class_1799> itemOutputs, Optional<class_5321<class_52>> lootOutput, IngredientSettings.Defaults defaultIngredientSettings) {
        ImmutableList defaultedIngredients = defaultIngredientSettings == IngredientSettings.Defaults.EMPTY ? ingredients : (ImmutableList)ingredients.stream().map(ingredient -> ingredient.withDefaults(defaultIngredientSettings)).collect(ImmutableList.toImmutableList());
        return new AnvilCrushingRecipe(defaultedIngredients, finalIngredientDropChance, blockOutput, itemOutputs, lootOutput, defaultIngredientSettings);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean matchesPrefix(List<Crushable> crushesPrefix) {
        int crushesSize = crushesPrefix.size();
        if (crushesSize > this.ingredients.size()) {
            return false;
        }
        ImmutableList<GenericIngredient<?, ?>> ingredients = this.ingredients;
        for (int i = 0; i < crushesSize; ++i) {
            if (((GenericIngredient)ingredients.get(i)).matches(crushesPrefix.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean output(class_2338 pos, class_2350 anvilFacing, class_3218 world, @Nullable class_2680 replacingState, Supplier<class_8567> createAnvilLootParamSet) {
        AnvilCrushingRecipeManager.INSTANCE.getId(this).ifPresent(id -> {
            class_243 center = pos.method_46558();
            List players = world.method_18766(player -> player.method_5707(center) < 400.0);
            for (class_3222 player2 : players) {
                AnvilCrushingRecipes.getAnyAnvilRecipeCrushedCriterion().trigger(player2);
                AnvilCrushingRecipes.getAnvilRecipeCrushedCriterion().trigger(player2, (class_2960)id);
            }
        });
        this.outputItems(pos, world);
        this.outputLoot(pos, world, createAnvilLootParamSet);
        return this.blockOutput.flatMap(blockOutput -> blockOutput.placeOrDrop(pos, anvilFacing, replacingState, world).map(placedState -> !class_2346.method_10128((class_2680)placedState))).orElse(false);
    }

    private void outputItems(class_2338 pos, class_3218 world) {
        for (class_1799 stack : this.itemOutputs) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack.method_7972());
        }
    }

    private void outputLoot(class_2338 pos, class_3218 world, Supplier<class_8567> createAnvilLootParamSet) {
        this.lootOutput.map(arg_0 -> ((class_9383.class_9385)world.method_8503().method_58576()).method_58295(arg_0)).filter(lootTable -> lootTable != class_52.field_948).ifPresent(lootTable -> lootTable.method_51878((class_8567)createAnvilLootParamSet.get()).forEach(stack -> class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack)));
    }

    public record MatchedCrushables(Optional<Match> match, List<Crushable> crushes) {
    }

    public record Match(AnvilCrushingRecipe recipe, GenericIngredient<?, ?> lastMatchedIngredient, boolean full) {
        public boolean partial() {
            return !this.full;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record ClientRecipe(class_2960 id, ImmutableList<ImmutableSet<@Unmodifiable class_1799>> ingredients, float finalIngredientDropChance, ImmutableMap<class_1799, class_2960> finalIngredientLoot, Optional<class_2248> blockOutput, ImmutableList<class_1799> itemOutputs, Optional<class_2960> lootOutputId) {
        public static ClientRecipe of(PacketedRecipe recipe) {
            ImmutableMap finalIngredientLoot;
            ImmutableList ingredients = (ImmutableList)recipe.ingredients.stream().map(packetedIngredient -> (ImmutableSet)packetedIngredient.streamItems().map(class_1792::method_7854).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
            if (recipe.ingredients.isEmpty() || recipe.finalIngredientDropChance() == 0.0f) {
                finalIngredientLoot = ImmutableMap.of();
            } else {
                GenericIngredient.Packeted lastIngredient = (GenericIngredient.Packeted)recipe.ingredients.getLast();
                finalIngredientLoot = ImmutableMap.copyOf(lastIngredient.getEntriesLoot());
            }
            return new ClientRecipe(recipe.id, (ImmutableList<ImmutableSet<class_1799>>)ingredients, recipe.finalIngredientDropChance, (ImmutableMap<class_1799, class_2960>)finalIngredientLoot, recipe.getBlockOutput(), recipe.itemOutputs, recipe.lootOutput);
        }
    }

    public record PacketedRecipe(class_2960 id, ImmutableList<GenericIngredient.Packeted<?, ? extends GenericIngredient.Entry.Packeted<?>>> ingredients, float finalIngredientDropChance, Optional<class_2960> blockOutput, ImmutableList<@Unmodifiable class_1799> itemOutputs, Optional<class_2960> lootOutput) {
        private static final class_9139<class_9129, ImmutableList<class_1799>> ITEM_OUTPUTS_CODEC = class_9135.method_56376(ArrayList::new, (class_9139)class_1799.field_48349).method_56432(ImmutableList::copyOf, Function.identity());
        public static final class_9139<class_2540, ImmutableList<GenericIngredient.Packeted<?, ? extends GenericIngredient.Entry.Packeted<?>>>> INGREDIENTS_CODEC = GenericIngredient.Packeted.CODEC.method_56433(class_9135.method_56363()).method_56432(ImmutableList::copyOf, Function.identity());
        public static final class_9139<class_9129, PacketedRecipe> CODEC = class_9139.method_58025((class_9139)class_2960.field_48267, PacketedRecipe::id, INGREDIENTS_CODEC, PacketedRecipe::ingredients, (class_9139)class_9135.field_48552, PacketedRecipe::finalIngredientDropChance, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), PacketedRecipe::blockOutput, ITEM_OUTPUTS_CODEC, PacketedRecipe::itemOutputs, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), PacketedRecipe::lootOutput, PacketedRecipe::new);
        public static final class_9139<class_9129, List<PacketedRecipe>> LIST_CODEC = class_9135.method_56376(ArrayList::new, CODEC);

        public static PacketedRecipe of(class_2960 id, AnvilCrushingRecipe recipe) {
            return new PacketedRecipe(id, (ImmutableList)recipe.ingredients.stream().map(GenericIngredient::packeted).collect(ImmutableList.toImmutableList()), recipe.finalIngredientDropChance, recipe.blockOutput.map(BlockOutput::block).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)), recipe.itemOutputs, recipe.lootOutput.map(class_5321::method_29177));
        }

        public Optional<class_2248> getBlockOutput() {
            return this.blockOutput.flatMap(arg_0 -> ((class_7922)class_7923.field_41175).method_17966(arg_0));
        }
    }
}

