/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.sssubtlety.anvil_crushing_recipes.mixin_helpers.BlockItemMixinExposure;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.Directions;
import net.sssubtlety.anvil_crushing_recipes.util.PartitionedResults;
import net.sssubtlety.anvil_crushing_recipes.util.StateParser;
import net.sssubtlety.anvil_crushing_recipes.util.StringUtil;
import net.sssubtlety.anvil_crushing_recipes.util.Util;
import org.jetbrains.annotations.Nullable;

public final class BlockOutput {
    private static final String BLOCK_KEY = "block";
    private static final String PROPERTIES_KEY = "properties";
    private static final String NBT_KEY = "nbt";
    private static final Codec<BlockOutput> OBJECT_CODEC = Data.CODEC.flatXmap(Data::toOutput, BlockOutput::toData);
    public static final Codec<BlockOutput> CODEC = Codec.either(CodecUtil.BLOCK_CODEC, OBJECT_CODEC).xmap(blockOrOutput -> (BlockOutput)Either.unwrap((Either)blockOrOutput.mapLeft(BlockOutput::of)), output -> output.properties.isEmpty() && output.blockEntityNbt.isEmpty() ? Either.left((Object)output.block) : Either.right((Object)output));
    private final class_2248 block;
    private final ImmutableMap<class_2769<?>, Object> properties;
    @VisibleForTesting
    final Optional<class_2487> blockEntityNbt;

    public static BlockOutput of(class_2248 block) {
        return new BlockOutput(block, ImmutableMap.of(), Optional.empty());
    }

    private static DataResult<Optional<class_2487>> validate(class_2248 block, Optional<class_2487> blockEntityNbt) {
        if (blockEntityNbt.isPresent() && !(block instanceof class_2343)) {
            return DataResult.error(() -> "\"%s\" specified for \"%s\" that does not support nbt: %s".formatted(NBT_KEY, BLOCK_KEY, class_7923.field_41175.method_10221((Object)block)));
        }
        return DataResult.success(blockEntityNbt);
    }

    private static <T> DataResult<T> missingPropertyError(class_2248 owner, String propertyName) {
        return DataResult.error(() -> "Block \"%s\" has no \"%s\" property".formatted(class_7923.field_41175.method_10221((Object)owner), propertyName));
    }

    private static Stream<Map.Entry<class_2769<?>, Object>> streamMergedProperties(@Nullable class_2680 state, Map<class_2769<?>, Object> properties) {
        Stream<Map.Entry<class_2769<?>, Object>> propertiesStream = properties.entrySet().stream();
        if (state == null) {
            return propertiesStream;
        }
        Stream<Map.Entry> statePropertiesStream = state.method_28501().stream().map(property -> Map.entry(property, state.method_11654(property)));
        return Stream.concat(statePropertiesStream, propertiesStream);
    }

    private static Optional<class_2371<class_1799>> parseInventoryContents(class_2487 compound) {
        return compound.method_10554("Items").map(items -> items.stream().mapMulti((itemElement, addStack) -> class_11343.field_60354.parse((DynamicOps)class_2509.field_11560, itemElement).resultOrPartial().map(class_11343::comp_4212).ifPresent((Consumer<class_1799>)addStack)).collect(Collectors.toCollection(class_2371::method_10211))).filter(stacks -> !stacks.isEmpty());
    }

    private static Optional<class_2680> getContextualState(class_2248 block, class_1799 blockStack, class_2350 anvilFacing, class_2338 pos, class_1937 world) {
        Function<class_1750, class_2680> function;
        class_1792 class_17922 = blockStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            function = ((BlockItemMixinExposure)blockItem)::anvil_crushing_recipes$getPlacementStateAllowEntityOverlap;
        } else {
            function = arg_0 -> ((class_2248)block).method_9605(arg_0);
        }
        Function<class_1750, @Nullable class_2680> getPlacementState = function;
        for (class_2350 facing : Directions.getCycled(anvilFacing)) {
            class_2968 context = new class_2968(world, pos, facing, blockStack, class_2350.field_11036);
            @Nullable class_2680 placementState = getPlacementState.apply((class_1750)context);
            if (placementState == null || !placementState.method_26184((class_4538)world, pos)) continue;
            return Optional.of(placementState);
        }
        return Optional.empty();
    }

    private static class_2680 withAll(class_2680 state, Stream<Map.Entry<class_2769<?>, Object>> properties) {
        Iterator<Map.Entry<class_2769<?>, Object>> iterator = properties.toList().iterator();
        while (iterator.hasNext()) {
            class_2680 inputState = state;
            Map.Entry<class_2769<?>, Object> entry = iterator.next();
            Optional<class_2680> stateWithValue = StateParser.withIfExists(inputState, entry.getKey(), entry.getValue());
            if (!stateWithValue.isPresent()) continue;
            state = stateWithValue.orElseThrow();
        }
        return state;
    }

    private static void mergeBlockEntityNbt(class_2487 outputNbt, class_2338 pos, class_3218 world) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            class_5455 registryManager = world.method_30349();
            class_11362 writer = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)registryManager);
            blockEntity.method_71400((class_11372)writer);
            class_2487 compound = writer.method_71475().method_10543(outputNbt);
            class_11368 reader = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)registryManager, (class_2487)compound);
            blockEntity.method_58690(reader);
        }
    }

    BlockOutput(class_2248 block, ImmutableMap<class_2769<?>, Object> properties, Optional<class_2487> blockEntityNbt) {
        this.block = block;
        this.properties = properties;
        this.blockEntityNbt = blockEntityNbt;
    }

    public Optional<class_2680> placeOrDrop(class_2338 pos, class_2350 anvilFacing, @Nullable class_2680 oldState, class_3218 world) {
        class_1799 blockStack = this.block.method_8389().method_7854();
        class_2680 defaultState = this.block.method_9564();
        Optional<Object> placementState = oldState == null && !world.method_8320(pos).method_45474() ? Optional.empty() : (blockStack.method_31574(class_1802.field_8162) ? Optional.of(defaultState) : BlockOutput.getContextualState(this.block, blockStack, anvilFacing, pos, (class_1937)world).map(contextualState -> BlockOutput.withAll(contextualState, BlockOutput.streamMergedProperties(oldState, this.properties))));
        placementState.ifPresentOrElse(state -> {
            world.method_8652(pos, state, 11);
            this.block.method_9567((class_1937)world, pos, state, null, blockStack);
            this.blockEntityNbt.ifPresent(outputNbt -> BlockOutput.mergeBlockEntityNbt(outputNbt, pos, world));
            class_2498 blockSoundGroup = state.method_26231();
            world.method_45446(pos, blockSoundGroup.method_10598(), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f, true);
            world.method_43276((class_6880)class_5712.field_28164, pos, class_5712.class_7397.method_43286(null, (class_2680)state));
        }, () -> {
            class_2680 adjustedState = this.block instanceof class_2244 ? (class_2680)defaultState.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560) : defaultState;
            class_2680 mergedState = BlockOutput.withAll(adjustedState, BlockOutput.streamMergedProperties(oldState, this.properties));
            class_2248.method_9497((class_2680)mergedState, (class_1937)world, (class_2338)pos);
            this.blockEntityNbt.flatMap(BlockOutput::parseInventoryContents).ifPresent(contents -> class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)contents));
            if (oldState != null) {
                world.method_8444(null, 2001, pos, class_2248.method_9507((class_2680)oldState));
            }
        });
        return placementState;
    }

    public class_2248 block() {
        return this.block;
    }

    public ImmutableMap<class_2769<?>, Object> properties() {
        return this.properties;
    }

    private DataResult<Data> toData() {
        return BlockOutput.validate(this.block, this.blockEntityNbt).flatMap(validNbt -> {
            class_2680 defaultState = this.block.method_9564();
            PartitionedResults stringEntriesAndErrors = this.properties.entrySet().stream().map(propertyEntry -> {
                class_2769 property = (class_2769)propertyEntry.getKey();
                String propertyName = property.method_11899();
                if (defaultState.method_28500(property).isEmpty()) {
                    return BlockOutput.missingPropertyError(this.block, propertyName);
                }
                Object value = propertyEntry.getValue();
                return StateParser.getValueName(property, value).map(valueName -> DataResult.success(Map.entry(propertyName, valueName))).orElseGet(() -> DataResult.error(() -> "Property \"%s\" cannot have value: %s".formatted(propertyName, value)));
            }).collect(PartitionedResults.collector());
            List<String> errors = stringEntriesAndErrors.rights();
            if (errors.isEmpty()) {
                ImmutableMap stringProperties = stringEntriesAndErrors.lefts().stream().collect(Util.entriesToImmutableMap());
                return DataResult.success((Object)new Data(this.block, (ImmutableMap<String, String>)stringProperties, (Optional<class_2487>)validNbt));
            }
            return DataResult.error(() -> errors.stream().collect(Collectors.joining(StringUtil.LINE_TAB, "Errors serializing BlockOut properties:", "")));
        });
    }

    private record Data(class_2248 block, ImmutableMap<String, String> stringProperties, Optional<class_2487> blockEntityNbt) {
        private static final Codec<ImmutableMap<String, String>> PROPERTIES_CODEC = Codec.unboundedMap((Codec)class_5699.field_41759, CodecUtil.PROPERTY_VALUE_CODEC).xmap(ImmutableMap::copyOf, Function.identity());
        private static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtil.BLOCK_CODEC.fieldOf(BlockOutput.BLOCK_KEY).forGetter(Data::block), (App)PROPERTIES_CODEC.optionalFieldOf(BlockOutput.PROPERTIES_KEY, (Object)ImmutableMap.of()).forGetter(Data::stringProperties), (App)class_2487.field_25128.optionalFieldOf(BlockOutput.NBT_KEY).forGetter(Data::blockEntityNbt)).apply((Applicative)instance, Data::new));

        private DataResult<BlockOutput> toOutput() {
            return BlockOutput.validate(this.block, this.blockEntityNbt).flatMap(validNbt -> {
                class_2680 defaultState = this.block.method_9564();
                PartitionedResults entriesAndErrors = this.stringProperties.entrySet().stream().map(stringEntry -> {
                    String propertyName = (String)stringEntry.getKey();
                    return StateParser.getProperty(defaultState, propertyName).map(property -> {
                        String valueName = (String)stringEntry.getValue();
                        return StateParser.getValue(property, valueName).map(value -> DataResult.success(Map.entry(property, value))).orElseGet(() -> DataResult.error(() -> "Property \"%s\" of block \"%s\" has no \"%s\" value".formatted(propertyName, class_7923.field_41175.method_10221((Object)this.block), valueName)));
                    }).orElseGet(() -> BlockOutput.missingPropertyError(this.block, propertyName));
                }).collect(PartitionedResults.collector());
                List<String> errors = entriesAndErrors.errors();
                if (errors.isEmpty()) {
                    ImmutableMap properties = entriesAndErrors.successes().stream().collect(Util.entriesToImmutableMap());
                    return DataResult.success((Object)new BlockOutput(this.block, (ImmutableMap<class_2769<?>, Object>)properties, (Optional<class_2487>)validNbt));
                }
                return DataResult.error(() -> errors.stream().collect(Collectors.joining(StringUtil.LINE_TAB, "Errors in \"%s\":".formatted(BlockOutput.PROPERTIES_KEY), "")));
            });
        }
    }
}

