/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;

public sealed interface Crushable {
    public static final Codec<Crushable> CODEC = Codec.either(Block.CODEC, Entity.CODEC).xmap(Either::unwrap, crushed -> {
        Crushable crushable = crushed;
        Objects.requireNonNull(crushable);
        Crushable selector0$temp = crushable;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Block.class, Entity.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Block block = (Block)selector0$temp;
                yield Either.left((Object)block);
            }
            case 1 -> {
                Entity entity = (Entity)selector0$temp;
                yield Either.right((Object)entity);
            }
        };
    });
    public static final String ANVIL_FALL_DISTANCE_KEY = "anvil_fall_distance";
    public static final String ANVIL_SPEED_SQUARED_KEY = "anvil_speed_squared";

    public Object getSingleton();

    public double anvilFallDistance();

    public double anvilSpeedSquared();

    public record Block(class_2680 state, double anvilFallDistance, double anvilSpeedSquared, Supplier<Optional<class_2487>> blockEntityNbt) implements Crushable
    {
        private static final Codec<Block> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2680.field_24734.fieldOf("state").forGetter(Block::state), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(block -> block.blockEntityNbt.get()), (App)Codec.DOUBLE.fieldOf(Crushable.ANVIL_FALL_DISTANCE_KEY).forGetter(Block::anvilFallDistance), (App)Codec.DOUBLE.fieldOf(Crushable.ANVIL_SPEED_SQUARED_KEY).forGetter(Block::anvilSpeedSquared)).apply((Applicative)instance, Block::new)).fieldOf("block").codec();

        public Block(class_2680 state, double anvilFallDistance, double anvilSpeedSquared, Supplier<Optional<class_2487>> blockEntityNbt) {
            this.state = state;
            this.blockEntityNbt = Suppliers.memoize(blockEntityNbt::get);
            this.anvilFallDistance = anvilFallDistance;
            this.anvilSpeedSquared = anvilSpeedSquared;
        }

        private Block(class_2680 state, Optional<class_2487> blockEntityNbt, double anvilFallDistance, double anvilSpeedSquared) {
            this(state, anvilFallDistance, anvilSpeedSquared, () -> blockEntityNbt);
        }

        public class_2248 getSingleton() {
            return this.state.method_26204();
        }
    }

    public record Entity(class_1299<?> type, double anvilFallDistance, double anvilSpeedSquared, Supplier<class_2487> entityNbt) implements Crushable
    {
        private static final Codec<Entity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtil.ENTITY_TYPE_CODEC.fieldOf("type").forGetter(Entity::type), (App)class_2487.field_25128.fieldOf("nbt").forGetter(entity -> entity.entityNbt.get()), (App)Codec.DOUBLE.fieldOf(Crushable.ANVIL_FALL_DISTANCE_KEY).forGetter(Entity::anvilFallDistance), (App)Codec.DOUBLE.fieldOf(Crushable.ANVIL_SPEED_SQUARED_KEY).forGetter(Entity::anvilSpeedSquared)).apply((Applicative)instance, Entity::new)).fieldOf("entity").codec();

        public Entity(class_1299<?> type, double anvilFallDistance, double anvilSpeedSquared, Supplier<class_2487> entityNbt) {
            this.type = type;
            this.entityNbt = Suppliers.memoize(entityNbt::get);
            this.anvilFallDistance = anvilFallDistance;
            this.anvilSpeedSquared = anvilSpeedSquared;
        }

        private Entity(class_1299<?> type, class_2487 entityNbt, double anvilFallDistance, double anvilSpeedSquared) {
            this(type, anvilFallDistance, anvilSpeedSquared, () -> entityNbt);
        }

        public class_1299<?> getSingleton() {
            return this.type;
        }
    }
}

