/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sssubtlety.anvil_crushing_recipes.recipe.AnvilCrushingRecipe;
import net.sssubtlety.anvil_crushing_recipes.recipe.Crushable;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.GenericIngredient;
import org.jetbrains.annotations.Nullable;

public class RecipeTrie {
    private final Entry root;

    public RecipeTrie(ImmutableCollection<AnvilCrushingRecipe> recipes) {
        this.root = new Entry(0, recipes);
    }

    public Optional<AnvilCrushingRecipe.Match> match(List<Crushable> crushes) {
        if (crushes.isEmpty()) {
            return Optional.empty();
        }
        Entry.Split currentSplit = this.root.split();
        int iLastCrush = crushes.size() - 1;
        for (Crushable crushable : crushes.subList(0, iLastCrush)) {
            @Nullable Entry currentEntry = (Entry)currentSplit.branches.get(crushable.getSingleton());
            if (currentEntry == null) {
                return Optional.empty();
            }
            currentSplit = currentEntry.split();
        }
        Object lastSingleton = crushes.getLast().getSingleton();
        ImmutableCollection fulls = currentSplit.leaves.get(lastSingleton);
        for (AnvilCrushingRecipe full : fulls) {
            if (!full.matchesPrefix(crushes)) continue;
            return Optional.of(new AnvilCrushingRecipe.Match(full, (GenericIngredient)full.ingredients().getLast(), true));
        }
        Entry branches = (Entry)currentSplit.branches.get(lastSingleton);
        if (branches != null) {
            for (AnvilCrushingRecipe partial : branches.ancestors) {
                if (!partial.matchesPrefix(crushes)) continue;
                GenericIngredient lastMatchedIngredient = (GenericIngredient)partial.ingredients().get(iLastCrush);
                return Optional.of(new AnvilCrushingRecipe.Match(partial, lastMatchedIngredient, false));
            }
        }
        return Optional.empty();
    }

    private static final class Entry {
        private final int depth;
        private final ImmutableCollection<AnvilCrushingRecipe> ancestors;
        @Nullable
        private Split split;

        private Entry(int depth, ImmutableCollection<AnvilCrushingRecipe> ancestors) {
            this.ancestors = ancestors;
            this.depth = depth;
        }

        public Split split() {
            if (this.split == null) {
                this.split = this.splitImpl();
            }
            return this.split;
        }

        private Split splitImpl() {
            HashMultimap branches = HashMultimap.create();
            HashMultimap leaves = HashMultimap.create();
            int nextDepth = this.depth + 1;
            for (AnvilCrushingRecipe ancestor : this.ancestors) {
                ImmutableList<GenericIngredient<?, ?>> ingredients = ancestor.ingredients();
                HashMultimap map = ingredients.size() > nextDepth ? branches : leaves;
                for (Object singleton : ((GenericIngredient)ingredients.get(this.depth)).getSingletonMatches()) {
                    map.put(singleton, (Object)ancestor);
                }
            }
            return new Split((ImmutableMap<Object, Entry>)((ImmutableMap)branches.asMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, branchEntry -> new Entry(nextDepth, (ImmutableCollection<AnvilCrushingRecipe>)ImmutableList.copyOf((Collection)((Collection)branchEntry.getValue())))))), (ImmutableMultimap<Object, AnvilCrushingRecipe>)ImmutableMultimap.copyOf((Multimap)leaves));
        }

        private record Split(ImmutableMap<Object, Entry> branches, ImmutableMultimap<Object, AnvilCrushingRecipe> leaves) {
        }
    }
}

