/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe.ingredient;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.sssubtlety.anvil_crushing_recipes.recipe.Crushable;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.GenericIngredient;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.filter.BlockFilter;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings.IngredientSettings;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import org.jetbrains.annotations.Nullable;

public final class BlockIngredient
extends GenericIngredient<class_2248, Entry> {
    public static final String TYPE = "block";
    private static final class_7922<class_2248> REGISTRY = class_7923.field_41175;
    private static final MapCodec<Element> ELEMENT_OBJECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtil.BLOCK_CODEC.fieldOf("id").forGetter(Element::value), (App)BlockFilter.CODEC.forGetter(Element::filter)).apply((Applicative)instance, Element::new));
    private static final MapCodec<Tag> TAG_OBJECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41254).fieldOf("tag").forGetter(Tag::key), (App)BlockFilter.CODEC.forGetter(Tag::filter)).apply((Applicative)instance, Tag::new));
    private static final Codec<Entry> ENTRY_OBJECT_CODEC = Codec.mapEither(ELEMENT_OBJECT_CODEC, TAG_OBJECT_CODEC).xmap(Either::unwrap, entry -> {
        Entry entry2 = entry;
        Objects.requireNonNull(entry2);
        Entry selector0$temp = entry2;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Element.class, Tag.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Element element = (Element)selector0$temp;
                yield Either.left((Object)element);
            }
            case 1 -> {
                Tag tag = (Tag)selector0$temp;
                yield Either.right((Object)tag);
            }
        };
    }).codec();
    private static final Codec<Entry> ENTRY_CODEC = GenericIngredient.Entry.stringOrObjectCodecOf(ENTRY_OBJECT_CODEC, REGISTRY, Element::of, Tag::of);
    private static final Codec<ImmutableSet<Entry>> ENTRY_SET_CODEC = CodecUtil.singleOrList(ENTRY_CODEC).xmap(ImmutableSet::copyOf, ArrayList::new);
    private static final Codec<BlockIngredient> SIMPLE_CODEC = ENTRY_SET_CODEC.xmap(BlockIngredient::of, GenericIngredient::entries);
    private static final Codec<BlockIngredient> OBJECT_CODEC = Codec.mapPair((MapCodec)ENTRY_SET_CODEC.fieldOf("entries"), Attachments.CODEC).xmap(entriesAndAttachments -> {
        ImmutableSet entries = (ImmutableSet)entriesAndAttachments.getFirst();
        Attachments attachments = (Attachments)entriesAndAttachments.getSecond();
        return BlockIngredient.of((ImmutableSet<Entry>)entries, attachments.filter, attachments.settings);
    }, ingredient -> Pair.of((Object)ingredient.entries, (Object)new Attachments(ingredient.filter, ingredient.settings))).codec();
    public static final Codec<BlockIngredient> CODEC = Codec.either(SIMPLE_CODEC, OBJECT_CODEC).xmap(Either::unwrap, ingredient -> ingredient.filter == BlockFilter.EMPTY && ingredient.settings == IngredientSettings.Block.EMPTY ? Either.left((Object)ingredient) : Either.right((Object)ingredient));
    private final BlockFilter filter;
    private final IngredientSettings.Block settings;

    public static BlockIngredient of(ImmutableSet<Entry> entries) {
        return BlockIngredient.of(entries, BlockFilter.EMPTY, IngredientSettings.Block.EMPTY);
    }

    public static BlockIngredient of(ImmutableSet<Entry> entries, BlockFilter filter, IngredientSettings.Block settings) {
        return new BlockIngredient(entries, filter, settings);
    }

    private BlockIngredient(ImmutableSet<Entry> entries, BlockFilter filter, IngredientSettings.Block settings) {
        super(entries);
        this.filter = filter;
        this.settings = settings;
    }

    @Override
    protected class_2378<class_2248> registry() {
        return REGISTRY;
    }

    @Override
    public GenericIngredient.Packeted<?, ?> packeted() {
        return Packeted.of((Collection<Entry>)this.entries);
    }

    public BlockIngredient withDefaults(IngredientSettings.Defaults defaults) {
        return new BlockIngredient((ImmutableSet<Entry>)this.entries, this.filter, this.settings.withDefaults(defaults));
    }

    @Override
    public boolean matches(Crushable crushable) {
        if (crushable instanceof Crushable.Block) {
            Crushable.Block crushableBlock = (Crushable.Block)crushable;
            class_2680 state = crushableBlock.state();
            class_2248 stateBlock = state.method_26204();
            return this.settingsAllow(crushableBlock.anvilFallDistance(), crushableBlock.anvilSpeedSquared()) && ((ImmutableMultimap)this.entriesBySingleton.get()).get((Object)stateBlock).stream().anyMatch(entry -> entry.filter().allows(state, crushableBlock.blockEntityNbt())) && this.filter.allows(state, crushableBlock.blockEntityNbt());
        }
        return false;
    }

    @Override
    public IngredientSettings.Block settings() {
        return this.settings;
    }

    public void crush(class_2338 pos, boolean drop, class_3218 world) {
        world.method_22352(pos, drop);
    }

    public static final class Packeted
    implements GenericIngredient.Packeted<class_2248, GenericIngredient.Entry.Packeted<class_2248>> {
        private static final class_9139<class_2540, Element.Packeted> ELEMENT_CODEC = GenericIngredient.Entry.Packeted.codecOf(Element.Packeted::new);
        private static final class_9139<class_2540, Tag.Packeted> TAG_CODEC = GenericIngredient.Entry.Packeted.codecOf(Tag.Packeted::new);
        public static final class_9139<class_2540, Packeted> CODEC = class_9139.method_56435((class_9139)class_9135.method_56376(ArrayList::new, ELEMENT_CODEC), Packeted::getElements, (class_9139)class_9135.method_56376(ArrayList::new, TAG_CODEC), Packeted::getTags, Packeted::of);
        private final ImmutableSet<GenericIngredient.Entry.Packeted<class_2248>> entries;
        @Nullable
        private ImmutableSet<class_2248> values;

        public Packeted(ImmutableSet<GenericIngredient.Entry.Packeted<class_2248>> entries) {
            this.entries = entries;
        }

        public static Packeted of(Collection<Element.Packeted> elements, Collection<Tag.Packeted> tags) {
            return new Packeted((ImmutableSet<GenericIngredient.Entry.Packeted<class_2248>>)((ImmutableSet)Stream.concat(elements.stream(), tags.stream()).collect(ImmutableSet.toImmutableSet())));
        }

        public static Packeted of(Collection<Entry> entries) {
            return new Packeted((ImmutableSet<GenericIngredient.Entry.Packeted<class_2248>>)((ImmutableSet)entries.stream().map(Entry::packeted).collect(ImmutableSet.toImmutableSet())));
        }

        private static Collection<Element.Packeted> getElements(Packeted packeted) {
            return packeted.entries.stream().mapMulti((entry, keep) -> {
                if (entry instanceof Element.Packeted) {
                    Element.Packeted element = (Element.Packeted)entry;
                    keep.accept(element);
                }
            }).toList();
        }

        private static Collection<Tag.Packeted> getTags(Packeted packeted) {
            return packeted.entries.stream().mapMulti((entry, keep) -> {
                if (entry instanceof Tag.Packeted) {
                    Tag.Packeted element = (Tag.Packeted)entry;
                    keep.accept(element);
                }
            }).toList();
        }

        @Override
        public ImmutableSet<class_2248> resolve() {
            if (this.values == null) {
                this.values = GenericIngredient.Packeted.resolve(this.entries);
            }
            return this.values;
        }

        @Override
        public Optional<class_1792> getItem(class_2248 entry) {
            return Optional.of(entry.method_8389()).filter(item -> item != class_1802.field_8162);
        }

        @Override
        public Optional<class_5321<class_52>> getLoot(class_2248 entry) {
            return entry.method_26162();
        }

        @Override
        public ImmutableSet<GenericIngredient.Entry.Packeted<class_2248>> entries() {
            return this.entries;
        }
    }

    public static sealed interface Entry
    extends GenericIngredient.Entry<class_2248>,
    Resolver
    permits Element, Tag {
        public GenericIngredient.Entry.Packeted<class_2248> packeted();

        public BlockFilter filter();

        default public boolean stringSerializable() {
            return this.filter() == BlockFilter.EMPTY;
        }
    }

    private record Attachments(BlockFilter filter, IngredientSettings.Block settings) {
        private static final MapCodec<Attachments> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockFilter.CODEC.forGetter(Attachments::filter), (App)IngredientSettings.Block.CODEC.forGetter(Attachments::settings)).apply((Applicative)instance, Attachments::new));
    }

    public static final class Element
    extends Record
    implements Entry,
    GenericIngredient.Element<class_2248> {
        private final class_2248 value;
        private final BlockFilter filter;

        public Element(class_2248 value, BlockFilter filter) {
            this.value = value;
            this.filter = filter;
        }

        public static Element of(class_2248 value) {
            return new Element(value, BlockFilter.EMPTY);
        }

        @Override
        public Optional<String> trySimpleString() {
            return this.stringSerializable() ? GenericIngredient.Element.super.trySimpleString() : Optional.empty();
        }

        public Packeted packeted() {
            return new Packeted(this.registry().method_10221((Object)this.value).toString());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Element.class, "value;filter", "value", "filter"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Element.class, "value;filter", "value", "filter"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Element.class, "value;filter", "value", "filter"}, this, o);
        }

        @Override
        public class_2248 value() {
            return this.value;
        }

        @Override
        public BlockFilter filter() {
            return this.filter;
        }

        public record Packeted(String id) implements GenericIngredient.Element.Packeted<class_2248>,
        Resolver
        {
        }
    }

    public record Tag(class_6862<class_2248> key, BlockFilter filter) implements Entry,
    GenericIngredient.Tag<class_2248>
    {
        public static Tag of(class_6862<class_2248> key) {
            return new Tag(key, BlockFilter.EMPTY);
        }

        @Override
        public Optional<String> trySimpleString() {
            return this.stringSerializable() ? GenericIngredient.Tag.super.trySimpleString() : Optional.empty();
        }

        public Packeted packeted() {
            return new Packeted(this.key().comp_327().toString());
        }

        public record Packeted(String id) implements GenericIngredient.Tag.Packeted<class_2248>,
        Resolver
        {
        }
    }

    private static interface Resolver
    extends GenericIngredient.Resolver<class_2248> {
        @Override
        default public class_7922<class_2248> registry() {
            return REGISTRY;
        }
    }
}

