/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe.ingredient;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.sssubtlety.anvil_crushing_recipes.mixin_helpers.LivingEntityMixinExposure;
import net.sssubtlety.anvil_crushing_recipes.recipe.Crushable;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.GenericIngredient;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.filter.EntityFilter;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings.IngredientSettings;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import org.jetbrains.annotations.Nullable;

public final class EntityIngredient
extends GenericIngredient<class_1299<?>, Entry> {
    public static final String TYPE = "entity";
    private static final class_7922<class_1299<?>> REGISTRY = class_7923.field_41177;
    private static final Codec<Entry> ENTRY_OBJECT_CODEC = Codec.mapEither(Element.OBJECT_CODEC, Tag.OBJECT_CODEC).xmap(Either::unwrap, entry -> {
        Entry entry2 = entry;
        Objects.requireNonNull(entry2);
        Entry selector0$temp = entry2;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Element.class, Tag.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Element element = (Element)selector0$temp;
                yield Either.left((Object)element);
            }
            case 1 -> {
                Tag tag = (Tag)selector0$temp;
                yield Either.right((Object)tag);
            }
        };
    }).codec();
    private static final Codec<Entry> ENTRY_CODEC = GenericIngredient.Entry.stringOrObjectCodecOf(ENTRY_OBJECT_CODEC, REGISTRY, Element::of, Tag::of);
    private static final Codec<ImmutableSet<Entry>> ENTRY_SET_CODEC = CodecUtil.singleOrList(ENTRY_CODEC).xmap(ImmutableSet::copyOf, ArrayList::new);
    private static final Codec<EntityIngredient> SIMPLE_CODEC = ENTRY_SET_CODEC.xmap(EntityIngredient::of, GenericIngredient::entries);
    private static final Codec<EntityIngredient> OBJECT_CODEC = Codec.mapPair((MapCodec)ENTRY_SET_CODEC.fieldOf("entries"), Attachments.CODEC).xmap(entriesAndAttachments -> {
        ImmutableSet entries = (ImmutableSet)entriesAndAttachments.getFirst();
        Attachments attachments = (Attachments)entriesAndAttachments.getSecond();
        return EntityIngredient.of((ImmutableSet<Entry>)entries, attachments.filter, attachments.settings);
    }, ingredient -> Pair.of((Object)ingredient.entries, (Object)new Attachments(ingredient.filter, ingredient.settings))).codec();
    public static final Codec<EntityIngredient> CODEC = Codec.either(SIMPLE_CODEC, OBJECT_CODEC).xmap(Either::unwrap, ingredient -> ingredient.filter == EntityFilter.EMPTY && ingredient.settings == IngredientSettings.Entity.EMPTY ? Either.left((Object)ingredient) : Either.right((Object)ingredient));
    private final EntityFilter filter;
    private final IngredientSettings.Entity settings;

    public static EntityIngredient of(ImmutableSet<Entry> entries) {
        return EntityIngredient.of(entries, EntityFilter.EMPTY, IngredientSettings.Entity.EMPTY);
    }

    public static EntityIngredient of(ImmutableSet<Entry> entries, EntityFilter filter, IngredientSettings.Entity settings) {
        return new EntityIngredient(entries, filter, settings);
    }

    private EntityIngredient(ImmutableSet<Entry> entries, EntityFilter filter, IngredientSettings.Entity settings) {
        super(entries);
        this.filter = filter;
        this.settings = settings;
    }

    @Override
    protected class_2378<class_1299<?>> registry() {
        return REGISTRY;
    }

    @Override
    public GenericIngredient.Packeted<?, ?> packeted() {
        return Packeted.of((Collection<Entry>)this.entries);
    }

    public EntityIngredient withDefaults(IngredientSettings.Defaults defaults) {
        return new EntityIngredient((ImmutableSet<Entry>)this.entries, this.filter, this.settings.withDefaults(defaults));
    }

    @Override
    public boolean matches(Crushable crushable) {
        if (crushable instanceof Crushable.Entity) {
            Crushable.Entity crushableEntity = (Crushable.Entity)crushable;
            return this.settingsAllow(crushableEntity.anvilFallDistance(), crushableEntity.anvilSpeedSquared()) && ((ImmutableMultimap)this.entriesBySingleton.get()).get(crushableEntity.type()).stream().anyMatch(entry -> entry.filter().allows(crushableEntity.entityNbt())) && this.filter.allows(crushableEntity.entityNbt());
        }
        return false;
    }

    @Override
    public IngredientSettings.Entity settings() {
        return this.settings;
    }

    public boolean tryCrush(class_1297 collidedEntity, double anvilFallDistance, boolean drop, class_1282 anvilDamageSource, class_3218 world) {
        float damage = this.settings.getEntityDamage(anvilFallDistance);
        if (collidedEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)collidedEntity;
            ((LivingEntityMixinExposure)livingEntity).anvil_crushing_recipes$damage(world, anvilDamageSource, damage, drop);
        } else {
            collidedEntity.method_64397(world, anvilDamageSource, damage);
        }
        return !collidedEntity.method_5805();
    }

    public static final class Packeted
    implements GenericIngredient.Packeted<class_1299<?>, GenericIngredient.Entry.Packeted<class_1299<?>>> {
        private static final class_9139<class_2540, Element.Packeted> ELEMENT_CODEC = GenericIngredient.Entry.Packeted.codecOf(Element.Packeted::new);
        private static final class_9139<class_2540, Tag.Packeted> TAG_CODEC = GenericIngredient.Entry.Packeted.codecOf(Tag.Packeted::new);
        public static final class_9139<class_2540, Packeted> CODEC = class_9139.method_56435((class_9139)class_9135.method_56376(ArrayList::new, ELEMENT_CODEC), Packeted::getElements, (class_9139)class_9135.method_56376(ArrayList::new, TAG_CODEC), Packeted::getTags, Packeted::of);
        private final ImmutableSet<GenericIngredient.Entry.Packeted<class_1299<?>>> entries;
        @Nullable
        private ImmutableSet<class_1299<?>> values;

        public Packeted(ImmutableSet<GenericIngredient.Entry.Packeted<class_1299<?>>> entries) {
            this.entries = entries;
        }

        public static Packeted of(Collection<Element.Packeted> elements, Collection<Tag.Packeted> tags) {
            return new Packeted((ImmutableSet)Stream.concat(elements.stream(), tags.stream()).collect(ImmutableSet.toImmutableSet()));
        }

        public static Packeted of(Collection<Entry> entries) {
            return new Packeted((ImmutableSet)entries.stream().map(Entry::packeted).collect(ImmutableSet.toImmutableSet()));
        }

        private static Collection<Element.Packeted> getElements(Packeted packeted) {
            return packeted.entries.stream().mapMulti((entry, keep) -> {
                if (entry instanceof Element.Packeted) {
                    Element.Packeted element = (Element.Packeted)entry;
                    keep.accept(element);
                }
            }).toList();
        }

        private static Collection<Tag.Packeted> getTags(Packeted packeted) {
            return packeted.entries.stream().mapMulti((entry, keep) -> {
                if (entry instanceof Tag.Packeted) {
                    Tag.Packeted element = (Tag.Packeted)entry;
                    keep.accept(element);
                }
            }).toList();
        }

        @Override
        public ImmutableSet<GenericIngredient.Entry.Packeted<class_1299<?>>> entries() {
            return this.entries;
        }

        @Override
        public ImmutableSet<class_1299<?>> resolve() {
            if (this.values == null) {
                this.values = GenericIngredient.Packeted.resolve(this.entries());
            }
            return this.values;
        }

        @Override
        public Optional<class_1792> getItem(class_1299<?> entry) {
            return Optional.ofNullable(class_1826.method_8019(entry));
        }

        @Override
        public Optional<class_5321<class_52>> getLoot(class_1299<?> entry) {
            return entry.method_16351();
        }
    }

    public static sealed interface Entry
    extends GenericIngredient.Entry<class_1299<?>>,
    Resolver
    permits Element, Tag {
        default public boolean stringSerializable() {
            return this.filter() == EntityFilter.EMPTY;
        }

        public GenericIngredient.Entry.Packeted<class_1299<?>> packeted();

        public EntityFilter filter();
    }

    private record Attachments(EntityFilter filter, IngredientSettings.Entity settings) {
        private static final MapCodec<Attachments> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityFilter.CODEC.forGetter(Attachments::filter), (App)IngredientSettings.Entity.CODEC.forGetter(Attachments::settings)).apply((Applicative)instance, Attachments::new));
    }

    public static final class Element
    extends Record
    implements Entry,
    GenericIngredient.Element<class_1299<?>> {
        private final class_1299<?> value;
        private final EntityFilter filter;
        private static final MapCodec<Element> OBJECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtil.ENTITY_TYPE_CODEC.fieldOf("id").forGetter(Element::value), (App)EntityFilter.CODEC.forGetter(Element::filter)).apply((Applicative)instance, Element::new));

        public Element(class_1299<?> value, EntityFilter filter) {
            this.value = value;
            this.filter = filter;
        }

        public static Element of(class_1299<?> value) {
            return new Element(value, EntityFilter.EMPTY);
        }

        @Override
        public Optional<String> trySimpleString() {
            return this.stringSerializable() ? GenericIngredient.Element.super.trySimpleString() : Optional.empty();
        }

        public Packeted packeted() {
            return new Packeted(this.registry().method_10221(this.value).toString());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Element.class, "value;filter", "value", "filter"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Element.class, "value;filter", "value", "filter"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Element.class, "value;filter", "value", "filter"}, this, o);
        }

        @Override
        public class_1299<?> value() {
            return this.value;
        }

        @Override
        public EntityFilter filter() {
            return this.filter;
        }

        public record Packeted(String id) implements GenericIngredient.Element.Packeted<class_1299<?>>,
        Resolver
        {
        }
    }

    public record Tag(class_6862<class_1299<?>> key, EntityFilter filter) implements Entry,
    GenericIngredient.Tag<class_1299<?>>
    {
        private static final MapCodec<Tag> OBJECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41266).fieldOf("tag").forGetter(Tag::key), (App)EntityFilter.CODEC.forGetter(Tag::filter)).apply((Applicative)instance, Tag::new));

        public static Tag of(class_6862<class_1299<?>> key) {
            return new Tag(key, EntityFilter.EMPTY);
        }

        @Override
        public Optional<String> trySimpleString() {
            return this.stringSerializable() ? GenericIngredient.Tag.super.trySimpleString() : Optional.empty();
        }

        public Packeted packeted() {
            return new Packeted(this.key.comp_327().toString());
        }

        public record Packeted(String id) implements GenericIngredient.Tag.Packeted<class_1299<?>>,
        Resolver
        {
        }
    }

    private static interface Resolver
    extends GenericIngredient.Resolver<class_1299<?>> {
        @Override
        default public class_7922<class_1299<?>> registry() {
            return REGISTRY;
        }
    }
}

