/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe.ingredient;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.sssubtlety.anvil_crushing_recipes.AnvilCrushingRecipes;
import net.sssubtlety.anvil_crushing_recipes.recipe.Crushable;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.BlockIngredient;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.EntityIngredient;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings.IngredientSettings;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.PartitionedResults;
import net.sssubtlety.anvil_crushing_recipes.util.StringUtil;
import org.slf4j.Logger;

public abstract sealed class GenericIngredient<T, E extends Entry<T>>
permits BlockIngredient, EntityIngredient {
    protected final ImmutableSet<E> entries;
    protected final Supplier<ImmutableMultimap<T, E>> entriesBySingleton;

    public static Codec<GenericIngredient<?, ?>> createCodec() {
        return Codec.mapEither((MapCodec)BlockIngredient.CODEC.fieldOf("block"), (MapCodec)EntityIngredient.CODEC.fieldOf("entity")).xmap(Either::unwrap, ingredient -> {
            GenericIngredient genericIngredient = ingredient;
            Objects.requireNonNull(genericIngredient);
            GenericIngredient selector0$temp = genericIngredient;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockIngredient.class, EntityIngredient.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    BlockIngredient block = (BlockIngredient)selector0$temp;
                    yield Either.left((Object)block);
                }
                case 1 -> {
                    EntityIngredient entity = (EntityIngredient)selector0$temp;
                    yield Either.right((Object)entity);
                }
            };
        }).codec();
    }

    protected static <T, E extends Entry<T>, I extends GenericIngredient<T, E>> Codec<I> codecOf(Codec<E> entryCodec, Function<ImmutableSet<E>, I> factory) {
        return CodecUtil.singleOrList(entryCodec).xmap(ImmutableSet::copyOf, ArrayList::new).xmap(factory, GenericIngredient::entries);
    }

    protected GenericIngredient(ImmutableSet<E> entries) {
        this.entries = entries;
        this.entriesBySingleton = Suppliers.memoize(this::getEntriesBySingletonImpl);
    }

    protected boolean settingsAllow(double anvilFallDistance, double anvilSpeedSquared) {
        return this.settings().anvilFallDistance().map(predicate -> predicate.test(anvilFallDistance)).orElse(true) != false && this.settings().anvilSpeed().map(predicate -> predicate.testSquare(anvilSpeedSquared)).orElse(true) != false;
    }

    public abstract boolean matches(Crushable var1);

    public abstract IngredientSettings settings();

    protected abstract class_2378<T> registry();

    public abstract Packeted<?, ?> packeted();

    public final ImmutableSet<T> getSingletonMatches() {
        return this.entriesBySingleton.get().keySet();
    }

    protected ImmutableSet<E> entries() {
        return this.entries;
    }

    private ImmutableMultimap<T, E> getEntriesBySingletonImpl() {
        PartitionedResults results = this.entries.stream().map(entry -> entry.resolve().map(singletons -> Pair.of((Object)entry, (Object)singletons))).collect(PartitionedResults.collector());
        if (results.errors().isEmpty()) {
            return (ImmutableMultimap)results.successes().stream().flatMap(entryAndSingletons -> ((Stream)entryAndSingletons.getSecond()).map(singleton -> Map.entry(singleton, (Entry)entryAndSingletons.getFirst()))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
        }
        AnvilCrushingRecipes.LOGGER.error(results.errors().stream().collect(Collectors.joining(StringUtil.LINE_TAB, "Errors in \"%s\" ingredient:".formatted(this.registry().method_46765().method_29177()), "")));
        return ImmutableListMultimap.of();
    }

    public abstract GenericIngredient<T, E> withDefaults(IngredientSettings.Defaults var1);

    public static sealed interface Entry<T>
    extends Resolver<T>
    permits BlockIngredient.Entry, EntityIngredient.Entry, Element, Tag {
        public static final String ENTRIES_KEY = "entries";

        public static <T, E extends Entry<T>> Codec<E> stringOrObjectCodecOf(Codec<E> objectCodec, class_2378<T> registry, Function<T, E> simpleElementFactory, Function<class_6862<T>, E> simpleTagFactory) {
            return Codec.either((Codec)class_5699.field_41759, objectCodec).flatXmap(stringOrEntry -> (DataResult)stringOrEntry.map(string -> Entry.ofStringImpl(string, registry, simpleElementFactory, simpleTagFactory), DataResult::success), entry -> DataResult.success((Object)entry.trySimpleString().map(Either::left).orElseGet(() -> Either.right((Object)entry))));
        }

        private static <T, E extends Entry<T>> DataResult<E> ofStringImpl(String string, class_2378<T> registry, Function<T, E> simpleElementFactory, Function<class_6862<T>, E> simpleTagFactory) {
            boolean isTag = string.startsWith("#");
            DataResult idResult = class_2960.method_29186((String)(isTag ? string.substring(1) : string));
            class_5321 registryKey = registry.method_46765();
            return isTag ? idResult.map(id -> class_6862.method_40092((class_5321)registryKey, (class_2960)id)).map(simpleTagFactory) : idResult.flatMap(id -> registry.method_17966(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No \"%s\" with id: \"%s\"".formatted(registryKey.method_29177().toString(), id)))).map(simpleElementFactory);
        }

        public Optional<String> trySimpleString();

        public static interface Packeted<T>
        extends Resolver<T> {
            public static <T, P extends Packeted<T>> class_9139<class_2540, P> codecOf(Function<String, P> factory) {
                return class_9139.method_56434((class_9139)class_9135.field_48554, Packeted::id, factory);
            }

            public String id();
        }
    }

    public static sealed interface Packeted<T, E extends Entry.Packeted<T>>
    permits BlockIngredient.Packeted, EntityIngredient.Packeted {
        public static final class_9139<class_2540, Packeted<?, ?>> CODEC = class_9135.method_57995(BlockIngredient.Packeted.CODEC, EntityIngredient.Packeted.CODEC).method_56432(Either::unwrap, packeted -> {
            Packeted packeted2 = packeted;
            Objects.requireNonNull(packeted2);
            Packeted selector0$temp = packeted2;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockIngredient.Packeted.class, EntityIngredient.Packeted.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    BlockIngredient.Packeted block = (BlockIngredient.Packeted)selector0$temp;
                    yield Either.left((Object)block);
                }
                case 1 -> {
                    EntityIngredient.Packeted entity = (EntityIngredient.Packeted)selector0$temp;
                    yield Either.right((Object)entity);
                }
            };
        });

        public static <T, E extends Entry.Packeted<T>, P extends Packeted<T, E>> class_9139<class_2540, P> codecOf(class_9139<class_2540, E> entryCodec, Function<Collection<E>, P> factory) {
            class_9139 entryCollectionCodec = class_9135.method_56376(ArrayList::new, entryCodec);
            return class_9139.method_56434((class_9139)entryCollectionCodec, Packeted::entries, factory);
        }

        public static <T, E extends Entry.Packeted<T>> ImmutableSet<T> resolve(ImmutableSet<E> entries) {
            PartitionedResults results = entries.stream().map(Resolver::resolve).collect(PartitionedResults.collector());
            results.errors().forEach(arg_0 -> ((Logger)AnvilCrushingRecipes.LOGGER).error(arg_0));
            return (ImmutableSet)results.successes().stream().flatMap(Function.identity()).collect(ImmutableSet.toImmutableSet());
        }

        public ImmutableSet<E> entries();

        public ImmutableSet<T> resolve();

        default public Stream<class_1792> streamItems() {
            return this.resolve().stream().map(this::getItem).flatMap(Optional::stream);
        }

        default public Map<class_1799, class_2960> getEntriesLoot() {
            HashMap<class_1799, class_2960> entriesLoot = new HashMap<class_1799, class_2960>();
            for (Object entry : this.resolve()) {
                this.getItem(entry).ifPresent(item -> this.getLoot(entry).ifPresent(lootKey -> entriesLoot.put(new class_1799((class_1935)item), lootKey.method_29177())));
            }
            return entriesLoot;
        }

        public Optional<class_1792> getItem(T var1);

        public Optional<class_5321<class_52>> getLoot(T var1);
    }

    public static sealed interface Tag<T>
    extends Entry<T>
    permits BlockIngredient.Tag, EntityIngredient.Tag {
        public static final String TAG_KEY = "tag";
        public static final String PREFIX = "#";

        public static <T> DataResult<Stream<T>> resolve(class_6862<T> key, class_2378<T> registry) {
            return registry.method_46733(key).map(holders -> holders.method_40239().map(class_6880::comp_349)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Ingredient has missing \"%s\" tag with id \"%s\"".formatted(registry.method_46765().method_29177(), key.comp_327())));
        }

        public class_6862<T> key();

        @Override
        default public Optional<String> trySimpleString() {
            return Optional.of(PREFIX + this.key().comp_327().toString());
        }

        @Override
        default public DataResult<Stream<T>> resolve() {
            return Tag.resolve(this.key(), this.registry());
        }

        public static interface Packeted<T>
        extends Entry.Packeted<T> {
            @Override
            default public DataResult<Stream<T>> resolve() {
                return class_2960.method_29186((String)this.id()).map(id -> class_6862.method_40092((class_5321)this.registry().method_46765(), (class_2960)id)).flatMap(key -> Tag.resolve(key, this.registry()));
            }
        }
    }

    public static sealed interface Element<T>
    extends Entry<T>
    permits BlockIngredient.Element, EntityIngredient.Element {
        public static final String ID_KEY = "id";

        public T value();

        @Override
        default public DataResult<Stream<T>> resolve() {
            return DataResult.success(Stream.of(this.value()));
        }

        @Override
        default public Optional<String> trySimpleString() {
            return Optional.of(this.registry().method_10221(this.value()).toString());
        }

        public static sealed interface Packeted<T>
        extends Entry.Packeted<T>
        permits BlockIngredient.Element.Packeted, EntityIngredient.Element.Packeted {
            @Override
            default public DataResult<Stream<T>> resolve() {
                return class_2960.method_29186((String)this.id()).flatMap(id -> this.registry().method_17966(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No \"%s\" with id \"%s\"".formatted(this.registry().method_46765().method_29177(), this.id())))).map(Stream::of);
            }
        }
    }

    protected static interface Resolver<T> {
        public class_7922<T> registry();

        public DataResult<Stream<T>> resolve();
    }
}

