/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.class_5699;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings.BlockImpl;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings.DefaultsImpl;
import net.sssubtlety.anvil_crushing_recipes.recipe.ingredient.settings.EntityImpl;
import net.sssubtlety.anvil_crushing_recipes.util.NonNegativeDoublePredicate;

public sealed interface IngredientSettings {
    public static final MapCodec<Optional<Integer>> DAMAGE_TO_ANVIL_CODEC = Codec.INT.optionalFieldOf("damage_to_anvil");
    public static final MapCodec<Optional<Boolean>> PREVENT_ANVIL_FALL_DAMAGE_CODEC = Codec.BOOL.optionalFieldOf("prevent_anvil_fall_damage");
    public static final MapCodec<Optional<NonNegativeDoublePredicate>> ANVIL_FALL_DISTANCE_CODEC = NonNegativeDoublePredicate.CODEC.optionalFieldOf("anvil_fall_distance");
    public static final MapCodec<Optional<NonNegativeDoublePredicate>> ANVIL_SPEED_CODEC = NonNegativeDoublePredicate.CODEC.optionalFieldOf("anvil_speed");

    public Optional<Integer> damageToAnvil();

    public Optional<Boolean> preventAnvilFallDamage();

    public Optional<NonNegativeDoublePredicate> anvilFallDistance();

    public Optional<NonNegativeDoublePredicate> anvilSpeed();

    public static sealed interface Defaults
    extends IngredientSettings,
    BlockParams,
    EntityParams
    permits DefaultsImpl {
        public static final Defaults EMPTY = DefaultsImpl.EMPTY;
        public static final MapCodec<Defaults> CODEC = DefaultsImpl.CODEC;
    }

    public static sealed interface Entity
    extends IngredientSettings,
    EntityParams
    permits EntityImpl, EntityImpl.Defaulted {
        public static final Entity EMPTY = EntityImpl.EMPTY;
        public static final MapCodec<Entity> CODEC = EntityImpl.CODEC;
        public static final float INSTANT_KILL_DAMAGE = Float.MAX_VALUE;

        public Entity withDefaults(Defaults var1);

        default public float getEntityDamage(double anvilFallDistance) {
            if (this.entityDamagePerBlockFallen().isEmpty() && this.flatEntityDamage().isEmpty()) {
                return Float.MAX_VALUE;
            }
            float damagePerBlockFallen = this.entityDamagePerBlockFallen().orElse(Float.valueOf(0.0f)).floatValue();
            float flatDamage = this.flatEntityDamage().orElse(Float.valueOf(0.0f)).floatValue();
            double fallDistanceScaledDamage = anvilFallDistance * (double)damagePerBlockFallen;
            return (float)(fallDistanceScaledDamage + (double)flatDamage);
        }
    }

    public static sealed interface Block
    extends IngredientSettings,
    BlockParams
    permits BlockImpl, BlockImpl.Defaulted {
        public static final Block EMPTY = BlockImpl.EMPTY;
        public static final MapCodec<Block> CODEC = BlockImpl.CODEC;

        public Block withDefaults(Defaults var1);
    }

    public static sealed interface EntityParams
    permits Defaults, Entity {
        public static final MapCodec<Optional<Float>> FLAT_ENTITY_DAMAGE_CODEC = class_5699.field_34387.optionalFieldOf("flat_entity_damage");
        public static final MapCodec<Optional<Float>> ENTITY_DAMAGE_PER_BLOCK_FALLEN_CODEC = class_5699.field_34387.optionalFieldOf("entity_damage_per_block_fallen");

        public Optional<Float> flatEntityDamage();

        public Optional<Float> entityDamagePerBlockFallen();
    }

    public static sealed interface BlockParams
    permits Defaults, Block {
    }
}

