/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.rei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.sssubtlety.anvil_crushing_recipes.AnvilCrushingRecipes;
import net.sssubtlety.anvil_crushing_recipes.rei.AnvilCrushingPlugin;
import net.sssubtlety.anvil_crushing_recipes.rei.AnvilCrushingRecipeDisplay;
import net.sssubtlety.anvil_crushing_recipes.rei.ImmutablePoint;
import net.sssubtlety.anvil_crushing_recipes.rei.ReiUtils;
import net.sssubtlety.anvil_crushing_recipes.rei.rer.AbstractLootWidget;
import net.sssubtlety.anvil_crushing_recipes.rei.rer.EntrySyncedLootWidget;
import net.sssubtlety.anvil_crushing_recipes.rei.rer.LootWidget;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.EntrySyncedIdsLabel;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.InfoLabel;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableArrow;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableLabel;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableOutputSlotWidget;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableRendererWithBounds;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableSlotBase;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableSlotWidget;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableWidget;
import net.sssubtlety.anvil_crushing_recipes.util.TextUtil;
import net.sssubtlety.anvil_crushing_recipes.util.Util;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class AnvilCrushingCategory
implements DisplayCategory<AnvilCrushingRecipeDisplay> {
    public static final EntryStack<class_1799> ICON = EntryStacks.of((class_1935)class_2246.field_10535);
    public static final CategoryIdentifier<AnvilCrushingRecipeDisplay> ID = CategoryIdentifier.of((class_2960)AnvilCrushingRecipes.idOf("plugins/anvil_crushing"));
    private static final ImmutablePoint ORIGIN = new ImmutablePoint();

    public Renderer getIcon() {
        return ICON;
    }

    public class_2561 getTitle() {
        return Texts.TITLE;
    }

    public List<Widget> setupDisplay(AnvilCrushingRecipeDisplay display, Rectangle bounds) {
        return this.setupDisplayImpl(display, bounds);
    }

    protected <T extends WidgetWithBounds> List<T> setupDisplayImpl(AnvilCrushingRecipeDisplay display, Rectangle bounds) {
        int minX = bounds.x;
        int centerY = bounds.getCenterY();
        ArrayList<Object> widgets = new ArrayList<Object>();
        List inputs = display.getInputEntries();
        int size = inputs.size();
        int inputColumnHeight = Measurements.COLUMN_SPACING * (size - 1) + Measurements.SLOT_SIDE_LEN;
        int inputColumnTopHalf = Util.greaterHalf(inputColumnHeight);
        Point currentPoint = new Point(minX, centerY - inputColumnTopHalf);
        Point anvilPos = currentPoint.clone();
        anvilPos.y -= Measurements.SLOT_SIDE_LEN;
        widgets.add(this.makeAnvilWidget(anvilPos));
        widgets.add(new MovableSlotBase(new Rectangle(currentPoint.x, currentPoint.y, Measurements.SLOT_SIDE_LEN, inputColumnHeight)).cast());
        currentPoint.translate(1, 1);
        Slot finalInputSlot = null;
        for (EntryIngredient input : inputs) {
            finalInputSlot = new MovableSlotWidget(currentPoint).entries((Collection)input);
            finalInputSlot.disableBackground();
            finalInputSlot.disableHighlight();
            widgets.add(finalInputSlot.cast());
            currentPoint.translate(0, Measurements.COLUMN_SPACING);
        }
        currentPoint.y = centerY - MovableArrow.ARROW_TOP_HALF_HEIGHT;
        currentPoint.x += Measurements.SLOT_SIDE_LEN + 6;
        MovableArrow arrow = new MovableArrow(currentPoint);
        arrow.tooltip((class_2561)Texts.FROM_PREFIX.method_27661().method_27693("\n").method_27693(ReiUtils.tooltipIdString(display.id)));
        widgets.add(arrow.cast());
        int widthLeftOfArrowCenter = currentPoint.x - minX + MovableArrow.ARROW_HALF_WIDTH;
        currentPoint.x += MovableArrow.ARROW_WIDTH + 6 + 2;
        currentPoint.y = centerY;
        int maxX = bounds.getMaxX();
        class_3545<List<T>, Integer> outputWidgetsAndRightX = this.getOutputWidgetsAndMaxX(display, new ImmutablePoint(currentPoint), maxX, finalInputSlot);
        widgets.addAll((Collection)outputWidgetsAndRightX.method_15442());
        int xTranslation = maxX - (Integer)outputWidgetsAndRightX.method_15441();
        if (xTranslation > 0) {
            widgets.forEach(widget -> ((MovableWidget)widget).translate(Math.min(xTranslation, widthLeftOfArrowCenter), 0));
        }
        return widgets;
    }

    private <T extends WidgetWithBounds> T makeAnvilWidget(Point point) {
        MovableRendererWithBounds anvilWidget = new MovableRendererWithBounds(new Rectangle(point.x, point.y, Measurements.SLOT_SIDE_LEN, Measurements.SLOT_SIDE_LEN), (Renderer)ICON).withTooltip(class_2561.method_30163((String)TextUtil.fuzzyWrappedSentence(Texts.ANVIL_TOOLTIP.getString(), ReiUtils.getTooltipWidth())));
        return (T)anvilWidget.cast();
    }

    private <T extends WidgetWithBounds> class_3545<List<T>, Integer> getOutputWidgetsAndMaxX(AnvilCrushingRecipeDisplay display, ImmutablePoint centerLeft, int maxAllowedX, Slot finalInputSlot) {
        ArrayList outputWidgets = new ArrayList();
        Point currentPoint = centerLeft.clone();
        display.blockOutput.ifPresent(block -> {
            MovableSlotWidget blockSlot = new MovableOutputSlotWidget(currentPoint).entry(EntryStacks.of((class_1935)block));
            int halfBlockSlotSideLen = Util.greaterHalf(((MovableOutputSlotWidget)blockSlot).getBounds().width) - 6;
            currentPoint.y -= halfBlockSlotSideLen + 5;
            ((MovableOutputSlotWidget)blockSlot).translate(0, -halfBlockSlotSideLen);
            currentPoint.x += halfBlockSlotSideLen;
            outputWidgets.add(blockSlot.cast());
            MovableLabel blockOutputLabel = new MovableLabel(currentPoint.clone(), Texts.BLOCK_OUTPUT_LABEL);
            blockOutputLabel.tooltip(new class_2561[]{Texts.BLOCK_OUTPUT_TOOLTIP});
            blockOutputLabel.getPoint().y -= blockOutputLabel.getBounds().height;
            outputWidgets.add(blockOutputLabel.cast());
            int blockOutputWidth = Math.max(halfBlockSlotSideLen, blockOutputLabel.getBounds().getMaxX() - blockOutputLabel.getX()) + 6;
            currentPoint.x += blockOutputWidth;
            currentPoint.y = centerLeft.y;
        });
        int minX = currentPoint.x;
        int maxAllowedWidth = maxAllowedX - minX;
        Util.MaxInt maxWidth = new Util.MaxInt(0);
        ArrayList<WidgetWithBounds> additionalOutputs = new ArrayList<WidgetWithBounds>();
        int additionalOutputTypeCount = 0;
        if (this.tryAddIngredientLoot(display, currentPoint, maxWidth, maxAllowedWidth, finalInputSlot, additionalOutputs)) {
            ++additionalOutputTypeCount;
        }
        if (!display.itemOutputs.isEmpty()) {
            ++additionalOutputTypeCount;
            this.addItemsOutput(currentPoint, minX, Math.max(1, maxAllowedWidth / Measurements.SLOT_SIDE_LEN), maxWidth, (List<T>)additionalOutputs, (List<class_1799>)display.itemOutputs);
        }
        if (display.lootOutputId.isPresent()) {
            ++additionalOutputTypeCount;
            this.addLootOutput(currentPoint, maxAllowedWidth, maxWidth, additionalOutputs, display.lootOutputId.orElseThrow());
        }
        if (additionalOutputTypeCount > 0) {
            int verticalAdjustment = AnvilCrushingCategory.getVerticalAdjustment(centerLeft, currentPoint, additionalOutputTypeCount);
            additionalOutputs.forEach(output -> ((MovableWidget)output).translate(0, verticalAdjustment));
        } else if (display.blockOutput.isEmpty()) {
            MovableLabel noOutputLabel = new MovableLabel(currentPoint, Texts.NO_OUTPUT_LABEL).alignedLeft();
            noOutputLabel.tooltip(new class_2561[]{class_2561.method_43470((String)TextUtil.fuzzyWrappedSentence(Texts.NO_OUTPUT_TOOLTIP.getString(), ReiUtils.getTooltipWidth()))});
            currentPoint.y -= Measurements.HALF_LABEL_HEIGHT - 2;
            additionalOutputs.add(noOutputLabel.cast());
            maxWidth.update(noOutputLabel.getBounds().width);
        }
        outputWidgets.addAll(additionalOutputs);
        return new class_3545(outputWidgets, (Object)(minX + maxWidth.get()));
    }

    private static int getVerticalAdjustment(ImmutablePoint centerLeft, Point currentPoint, int additionalOutputTypeCount) {
        int verticalAdjustmentMagnitude = currentPoint.y - centerLeft.y - 7;
        verticalAdjustmentMagnitude = additionalOutputTypeCount == 1 ? Util.greaterHalf(verticalAdjustmentMagnitude - Measurements.LABEL_HEIGHT) + Measurements.LABEL_HEIGHT : Util.greaterHalf(verticalAdjustmentMagnitude);
        return -verticalAdjustmentMagnitude;
    }

    private <T extends WidgetWithBounds> void addLootOutput(Point currentPoint, int maxAllowedWidth, Util.MaxInt maxWidth, List<T> additionalOutputs, class_2960 lootTableOutputId) {
        if (AnvilCrushingPlugin.RER_LOADED) {
            InfoLabel infoLabel = new InfoLabel(currentPoint.clone(), Texts.LOOT_OUTPUT_LABEL);
            this.addLabel(currentPoint, maxWidth, additionalOutputs, infoLabel.mainTooltip(Texts.LOOT_OUTPUT_TOOLTIP));
            Rectangle lootDisplayMaxBounds = this.adjustAndGetLootBounds(currentPoint, maxAllowedWidth);
            LootWidget lootWidget = LootWidget.create(lootTableOutputId, lootDisplayMaxBounds);
            additionalOutputs.add(lootWidget.cast());
            infoLabel.setInfo(lootWidget.getTooltip());
            Rectangle lootBounds = lootWidget.getBounds();
            maxWidth.update(lootBounds.width);
            currentPoint.y += lootBounds.height + 4;
        } else {
            this.addLabelWithTooltip(currentPoint, maxWidth, additionalOutputs, new MovableLabel(currentPoint.clone(), Texts.LOOT_OUTPUT_LABEL), Texts.LOOT_OUTPUT_TOOLTIP);
            MovableLabel idLabel = ReiUtils.makeIdLabel(currentPoint.clone(), lootTableOutputId, maxAllowedWidth);
            idLabel.leftAligned();
            currentPoint.y += Measurements.LABEL_HEIGHT;
            additionalOutputs.add(idLabel.cast());
            maxWidth.update(idLabel.getBounds().width);
        }
    }

    private <T extends WidgetWithBounds> void addItemsOutput(Point currentPoint, int minX, int maxAllowedCols, Util.MaxInt maxWidth, List<T> additionalOutputs, List<class_1799> itemOutputs) {
        this.addLabelWithTooltip(currentPoint, maxWidth, additionalOutputs, new MovableLabel(currentPoint.clone(), Texts.ITEM_OUTPUTS_LABEL), Texts.ITEM_OUTPUTS_TOOLTIP);
        --currentPoint.y;
        int numOutputs = itemOutputs.size();
        int numColumns = Math.min(numOutputs, maxAllowedCols);
        int numRows = Util.ceilDiv(numOutputs, maxAllowedCols);
        MovableSlotBase slotBase = new MovableSlotBase(new Rectangle(currentPoint.x, currentPoint.y, numColumns * Measurements.SLOT_SIDE_LEN, numRows * Measurements.SLOT_SIDE_LEN));
        additionalOutputs.add(slotBase.cast());
        currentPoint.translate(1, 1);
        int i = 0;
        for (int row = 0; row < numRows; ++row) {
            int col = 0;
            while (col < numColumns) {
                additionalOutputs.add(new MovableSlotWidget(currentPoint).entry(EntryStacks.of((class_1799)itemOutputs.get(i))).cast());
                if (i == numOutputs) break;
                currentPoint.x += Measurements.SLOT_SIDE_LEN;
                ++col;
                ++i;
            }
            currentPoint.x = minX;
            currentPoint.y += Measurements.SLOT_SIDE_LEN;
            if (i == numOutputs) break;
        }
        maxWidth.update(numColumns * Measurements.SLOT_SIDE_LEN);
        currentPoint.y += 4;
    }

    private <T extends WidgetWithBounds> boolean tryAddIngredientLoot(AnvilCrushingRecipeDisplay display, Point currentPoint, Util.MaxInt maxWidth, int maxAllowedWidth, Slot finalInputSlot, List<T> additionalOutputs) {
        class_2960 firstLootTableId;
        if (display.finalIngredientDropChance <= 0.0f) {
            return false;
        }
        class_2561 ingredientLootLabel = display.finalIngredientDropChance == 1.0f ? Texts.INGREDIENT_LOOT_LABEL : Texts.INGREDIENT_LOOT_LABEL.method_27661().method_10852((class_2561)class_2561.method_43470((String)(" (" + display.finalIngredientDropChance * 100.0f + "%)")));
        class_2960 class_29602 = firstLootTableId = display.finalIngredientLoot.size() > 1 ? null : (class_2960)display.finalIngredientLoot.values().iterator().next();
        if (AnvilCrushingPlugin.RER_LOADED) {
            InfoLabel infoLabel = new InfoLabel(currentPoint.clone(), ingredientLootLabel);
            this.addLabel(currentPoint, maxWidth, additionalOutputs, infoLabel.mainTooltip(Texts.INGREDIENT_LOOT_TOOLTIP));
            Rectangle lootDisplayMaxBounds = this.adjustAndGetLootBounds(currentPoint, maxAllowedWidth);
            AbstractLootWidget lootWidget = firstLootTableId == null ? new EntrySyncedLootWidget(lootDisplayMaxBounds, finalInputSlot, display.finalIngredientLoot) : LootWidget.create(firstLootTableId, lootDisplayMaxBounds);
            additionalOutputs.add(lootWidget.cast());
            infoLabel.setInfo(lootWidget.getTooltip());
            Rectangle lootBounds = lootWidget.getBounds();
            maxWidth.update(lootBounds.width);
            currentPoint.y += lootBounds.height + 4;
        } else {
            this.addLabelWithTooltip(currentPoint, maxWidth, additionalOutputs, new MovableLabel(currentPoint.clone(), Texts.INGREDIENT_LOOT_LABEL), Texts.INGREDIENT_LOOT_TOOLTIP);
            --currentPoint.y;
            MovableLabel idsLabel = firstLootTableId == null ? new EntrySyncedIdsLabel(currentPoint.clone(), maxAllowedWidth, finalInputSlot, display.finalIngredientLoot).alignedLeft() : ReiUtils.makeIdLabel(currentPoint, firstLootTableId, maxAllowedWidth);
            additionalOutputs.add(idsLabel.cast());
            Rectangle idsLabelBounds = idsLabel.getBounds();
            maxWidth.update(idsLabelBounds.width);
            currentPoint.y += idsLabelBounds.height;
        }
        return true;
    }

    @NotNull
    private Rectangle adjustAndGetLootBounds(Point currentPoint, int width) {
        return new Rectangle(currentPoint.x, currentPoint.y -= 2, width, Measurements.LOOT_HEIGHT);
    }

    private <T extends WidgetWithBounds> void addLabelWithTooltip(Point currentPoint, Util.MaxInt maxWidth, List<T> additionalOutputs, MovableLabel label, class_2561 tooltip) {
        this.addLabel(currentPoint, maxWidth, additionalOutputs, label);
        label.tooltip(new class_2561[]{tooltip});
    }

    private <T extends WidgetWithBounds> void addLabel(Point currentPoint, Util.MaxInt maxWidth, List<T> additionalOutputs, MovableLabel label) {
        label.leftAligned();
        currentPoint.y += Measurements.LABEL_HEIGHT;
        additionalOutputs.add(label.cast());
        maxWidth.update(label.getBounds().width);
    }

    public CategoryIdentifier<? extends AnvilCrushingRecipeDisplay> getCategoryIdentifier() {
        return ID;
    }

    public static interface Measurements {
        public static final int H_PADDING = 6;
        public static final int V_PADDING = 4;
        public static final int SLOT_SIDE_LEN = Widgets.createSlot((Point)AnvilCrushingCategory.ORIGIN).getBounds().width;
        public static final int COLUMN_SPACING = SLOT_SIDE_LEN - 6;
        public static final int LABEL_HEIGHT = Widgets.createLabel((Point)new Point(), (class_2561)class_2561.method_43470((String)"")).getBounds().height;
        public static final int HALF_LABEL_HEIGHT = Util.greaterHalf(LABEL_HEIGHT);
        public static final int LOOT_HEIGHT = SLOT_SIDE_LEN + 3;
    }

    public static interface Texts {
        public static final class_2561 TITLE = class_2561.method_43471((String)"title.anvil_crushing_recipes.anvil_crushing_recipe");
        public static final class_2561 ANVIL_TOOLTIP = class_2561.method_43471((String)"tooltip.anvil_crushing_recipes.anvil");
        public static final class_2561 FROM_PREFIX = class_2561.method_43471((String)"tooltip.anvil_crushing_recipes.from_prefix");
        public static final class_2561 BLOCK_OUTPUT_LABEL = class_2561.method_43471((String)"label.anvil_crushing_recipes.block_output");
        public static final class_2561 BLOCK_OUTPUT_TOOLTIP = class_2561.method_43471((String)"tooltip.anvil_crushing_recipes.block_output");
        public static final class_2561 INGREDIENT_LOOT_LABEL = class_2561.method_43471((String)"label.anvil_crushing_recipes.ingredient_loot");
        public static final class_2561 INGREDIENT_LOOT_TOOLTIP = class_2561.method_43471((String)"tooltip.anvil_crushing_recipes.ingredient_loot");
        public static final class_2561 ITEM_OUTPUTS_LABEL = class_2561.method_43471((String)"label.anvil_crushing_recipes.item_outputs");
        public static final class_2561 ITEM_OUTPUTS_TOOLTIP = class_2561.method_43471((String)"tooltip.anvil_crushing_recipes.item_outputs");
        public static final class_2561 LOOT_OUTPUT_LABEL = class_2561.method_43471((String)"label.anvil_crushing_recipes.loot_output");
        public static final class_2561 LOOT_OUTPUT_TOOLTIP = class_2561.method_43471((String)"tooltip.anvil_crushing_recipes.loot_output");
        public static final class_2561 NO_OUTPUT_LABEL = class_2561.method_43471((String)"label.anvil_crushing_recipes.no_output");
        public static final class_2561 NO_OUTPUT_TOOLTIP = class_2561.method_43471((String)"tooltip.anvil_crushing_recipes.no_output");
    }
}

