/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.rei;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.sssubtlety.anvil_crushing_recipes.recipe.AnvilCrushingRecipe;
import net.sssubtlety.anvil_crushing_recipes.rei.AnvilCrushingCategory;
import net.sssubtlety.anvil_crushing_recipes.rei.AnvilCrushingPlugin;
import net.sssubtlety.anvil_crushing_recipes.rei.rer.AbstractLootWidget;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AnvilCrushingRecipeDisplay
extends BasicDisplay {
    public final class_2960 id;
    public final float finalIngredientDropChance;
    public final ImmutableMap<EntryStack<?>, class_2960> finalIngredientLoot;
    public final Optional<class_2248> blockOutput;
    public final ImmutableList<class_1799> itemOutputs;
    public final Optional<class_2960> lootOutputId;

    public AnvilCrushingRecipeDisplay(AnvilCrushingRecipe.ClientRecipe recipe) {
        super(null, null, Optional.of(recipe.id()));
        this.id = recipe.id();
        this.inputs = recipe.ingredients().stream().map(EntryIngredients::ofItemStacks).collect(Collectors.toList());
        this.finalIngredientDropChance = recipe.finalIngredientDropChance();
        this.finalIngredientLoot = (ImmutableMap)recipe.finalIngredientLoot().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> EntryStacks.of((class_1799)((class_1799)entry.getKey())), Map.Entry::getValue, (left, right) -> left.equals((Object)class_7923.field_41178.method_10221((Object)class_1802.field_8162)) ? right : left));
        this.blockOutput = recipe.blockOutput();
        this.itemOutputs = recipe.itemOutputs();
        this.lootOutputId = recipe.lootOutputId();
        this.outputs = AnvilCrushingRecipeDisplay.getOutputs(recipe, this.finalIngredientLoot == null ? null : this.finalIngredientLoot.values());
    }

    private static List<EntryIngredient> getOutputs(AnvilCrushingRecipe.ClientRecipe recipe, @Nullable ImmutableCollection<class_2960> finalIngredientLootIds) {
        ImmutableList<class_1799> itemOutputs;
        EntryIngredient.Builder outputsBuilder = EntryIngredient.builder();
        recipe.blockOutput().map(EntryStacks::of).ifPresent(arg_0 -> ((EntryIngredient.Builder)outputsBuilder).add(arg_0));
        if (AnvilCrushingPlugin.RER_LOADED && finalIngredientLootIds != null) {
            finalIngredientLootIds.forEach(id -> AbstractLootWidget.lootIdToEntryIngredient(id).forEach(arg_0 -> ((EntryIngredient.Builder)outputsBuilder).addAll(arg_0)));
        }
        if ((itemOutputs = recipe.itemOutputs()) != null) {
            outputsBuilder.addAll((Iterable)itemOutputs.stream().map(EntryStacks::of).collect(Collectors.toList()));
        }
        if (AnvilCrushingPlugin.RER_LOADED) {
            recipe.lootOutputId().map(AbstractLootWidget::lootIdToEntryIngredient).ifPresent(ingredients -> ingredients.forEach(arg_0 -> ((EntryIngredient.Builder)outputsBuilder).addAll(arg_0)));
        }
        return List.of(outputsBuilder.build());
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AnvilCrushingCategory.ID;
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return null;
    }
}

