/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.rei.widgets;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.sssubtlety.anvil_crushing_recipes.rei.ReiUtils;
import net.sssubtlety.anvil_crushing_recipes.rei.widgets.MovableLabel;
import net.sssubtlety.anvil_crushing_recipes.util.TextUtil;
import net.sssubtlety.anvil_crushing_recipes.util.Util;

public class EntrySyncedIdsLabel
extends MovableLabel {
    protected final Slot ingredientSlot;
    protected final ImmutableMap<EntryStack<?>, class_2561> entry2LootTextMap;
    protected final int width;
    protected class_2561 lootTextCache;

    public EntrySyncedIdsLabel(Point point, int maxWidth, Slot ingredientSlot, ImmutableMap<EntryStack<?>, class_2960> finalIngredientLoot) {
        super(point, class_2561.method_30163((String)""));
        this.ingredientSlot = ingredientSlot;
        ImmutableMap.Builder entry2LootTextMapBuilder = ImmutableMap.builder();
        Util.MaxInt maxIdTextWidth = new Util.MaxInt(0);
        StringBuilder tooltipBuilder = new StringBuilder();
        int tooltipWidth = ReiUtils.getTooltipWidth();
        for (Map.Entry entry2IdMapping : finalIngredientLoot.entrySet()) {
            class_2960 id = (class_2960)entry2IdMapping.getValue();
            class_2561 idText = TextUtil.truncatedIdText(id, maxWidth);
            entry2LootTextMapBuilder.put((Object)((EntryStack)entry2IdMapping.getKey()), (Object)idText);
            maxIdTextWidth.update(this.font.method_27525((class_5348)idText));
            tooltipBuilder.append(TextUtil.wrappedIdString(id, tooltipWidth)).append(",\n");
        }
        int length = tooltipBuilder.length();
        tooltipBuilder.delete(length - 2, length);
        this.entry2LootTextMap = entry2LootTextMapBuilder.build();
        this.width = maxIdTextWidth.get();
        this.delegate.tooltip(new class_2561[]{class_2561.method_43470((String)tooltipBuilder.toString())});
        this.lootTextCache = (class_2561)this.entry2LootTextMap.get((Object)ingredientSlot.getCurrentEntry());
        this.setMessage((class_5348)this.lootTextCache);
    }

    @Override
    public Rectangle getBounds() {
        Point point = this.getPoint();
        if (this.getHorizontalAlignment() == -1) {
            return new Rectangle(point.x - 1, point.y - 5, this.width + 2, 14);
        }
        if (this.getHorizontalAlignment() == 1) {
            return new Rectangle(point.x - this.width - 1, point.y - 5, this.width + 2, 14);
        }
        return new Rectangle(point.x - this.width / 2 - 1, point.y - 5, this.width + 2, 14);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        class_2561 currentLootText = (class_2561)this.entry2LootTextMap.get((Object)this.ingredientSlot.getCurrentEntry());
        if (this.lootTextCache != currentLootText) {
            this.lootTextCache = currentLootText;
            this.setMessage((class_5348)this.lootTextCache);
        }
        this.delegate.method_25394(graphics, mouseX, mouseY, delta);
    }
}

