/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2483;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.sssubtlety.anvil_crushing_recipes.AnvilCrushingRecipes;
import net.sssubtlety.anvil_crushing_recipes.util.StringUtil;

public final class CodecUtil {
    public static final Codec<UUID> UUID_CODEC = class_5699.field_41759.flatXmap(string -> {
        try {
            return DataResult.success((Object)UUID.fromString(string));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(e::getMessage);
        }
    }, uuid -> DataResult.success((Object)uuid.toString()));
    public static final Codec<String> PROPERTY_VALUE_CODEC = Codec.either((Codec)Codec.either((Codec)Codec.BOOL, (Codec)class_5699.field_33441), (Codec)class_5699.field_41759).xmap(boolOrIntOrString -> (String)Either.unwrap((Either)boolOrIntOrString.mapLeft(boolOrInt -> (String)boolOrInt.map(Object::toString, Object::toString))), string -> {
        if (string.equals("true")) {
            return Either.left((Object)Either.left((Object)true));
        }
        if (string.equals("false")) {
            return Either.left((Object)Either.left((Object)false));
        }
        return StringUtil.parseSimpleInt(string).map(Either::right).map(boolOrInt -> Either.left((Object)boolOrInt)).orElseGet(() -> Either.right((Object)string));
    });
    public static final Codec<Pattern> PATTERN_CODEC = class_5699.field_41759.flatXmap(string -> {
        try {
            return DataResult.success((Object)Pattern.compile(string));
        }
        catch (PatternSyntaxException e) {
            return DataResult.error(() -> "Invalid regex \"%s\": %s".formatted(string, e.getDescription()));
        }
    }, pattern -> DataResult.success((Object)pattern.pattern()));
    public static final Codec<class_2248> BLOCK_CODEC = class_7923.field_41175.method_39673();
    public static final Codec<class_1299<?>> ENTITY_TYPE_CODEC = class_7923.field_41177.method_39673();
    public static final Codec<class_2483> NBT_LIST_CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        class_2483 nbtList;
        class_2520 nbtElement = (class_2520)dynamic.convert((DynamicOps)class_2509.field_11560).getValue();
        return nbtElement instanceof class_2483 ? DataResult.success((Object)((nbtList = (class_2483)nbtElement) == dynamic.getValue() ? (class_2483)nbtList.method_10707() : nbtList)) : DataResult.error(() -> "Not an nbt list: " + String.valueOf(nbtElement));
    }, nbtList -> new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbtList.method_10707()));

    private CodecUtil() {
    }

    public static <T> Codec<List<T>> singleOrList(Codec<T> codec) {
        return Codec.either(codec, (Codec)class_5699.method_36973((Codec)codec.listOf())).xmap(singleOrList -> (List)singleOrList.map(List::of, Function.identity()), list -> {
            if (list.size() == 1) {
                return Either.left(list.getFirst());
            }
            return Either.right((Object)list);
        });
    }

    public static <T> Codec<ImmutableList<T>> immutableListOf(Codec<T> elementCodec) {
        return CodecUtil.listOf(elementCodec, ImmutableList::copyOf);
    }

    public static <T> Codec<List<T>> mutableListOf(Codec<T> elementCodec) {
        return CodecUtil.listOf(elementCodec, ArrayList::new);
    }

    public static <T, L extends List<T>> Codec<L> listOf(Codec<T> elementCodec, Function<Collection<T>, L> listFactory) {
        return elementCodec.listOf().xmap(listFactory, Function.identity());
    }

    public static <T> Codec<Set<T>> mutableSetOf(Codec<T> elementCodec) {
        return CodecUtil.setOf(elementCodec, HashSet::new);
    }

    public static <T, S extends Set<T>> Codec<S> setOf(Codec<T> elementCodec, Function<Collection<T>, S> setFactory) {
        return elementCodec.listOf().xmap(setFactory, List::copyOf);
    }

    public static <T> Codec<ImmutableMultiset<T>> immutableMultisetOf(Codec<T> elementCodec, String elementName) {
        return CodecUtil.multisetOf(elementCodec, elementName, ImmutableMultiset.toImmutableMultiset());
    }

    public static <T, M extends Multiset<T>> Codec<M> multisetOf(Codec<T> elementCodec, String elementName, Collector<T, ?, M> collector) {
        Codec elementCountsCodec = RecordCodecBuilder.create(instance -> {
            MapCodec elementMapCodec = elementCodec.fieldOf(elementName);
            return instance.group((App)elementMapCodec.forGetter(Pair::getFirst), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of);
        }).listOf();
        return elementCountsCodec.xmap(elementCounts -> (Multiset)elementCounts.stream().mapMulti((elementCount, adder) -> {
            int count = (Integer)elementCount.getSecond();
            Object element = elementCount.getFirst();
            for (int i = 0; i < count; ++i) {
                adder.accept(element);
            }
        }).collect(collector), multiset -> {
            ArrayList<Pair> elementCounts = new ArrayList<Pair>();
            for (Object element : multiset.elementSet()) {
                elementCounts.add(Pair.of(element, (Object)multiset.count(element)));
            }
            return elementCounts;
        });
    }

    public static <K, V> Codec<ImmutableMap<K, V>> immutableMapOf(Codec<K> keyCodec, Codec<V> valueCodec) {
        return CodecUtil.mapOf(keyCodec, valueCodec, ImmutableMap::copyOf);
    }

    public static <K, V, M extends Map<K, V>> Codec<M> mapOf(Codec<K> keyCodec, Codec<V> valueCodec, Function<Map<K, V>, M> factory) {
        return Codec.unboundedMap(keyCodec, valueCodec).xmap(factory, Function.identity());
    }

    public static <I, T> DataResult<Pair<T, I>> findSuccess(DynamicOps<I> ops, I input, Iterable<Codec<? extends T>> codecs, String errorPrefix) {
        ArrayList errors = new ArrayList();
        for (Codec<T> codec : codecs) {
            DataResult result = codec.decode(ops, input);
            if (result.isSuccess()) {
                return result.map(pair -> pair.mapFirst(Function.identity()));
            }
            result.ifError(errors::add);
        }
        return DataResult.error(() -> errors.stream().map(DataResult.Error::message).collect(Collectors.joining("; ", errorPrefix, "")));
    }

    public static void logError(DataResult.Error<?> error) {
        AnvilCrushingRecipes.LOGGER.error(error.message());
    }

    public static <T, C extends Codec<T>> C recursive(String name, Function<Codec<T>, C> builder) {
        return new Recursive<T, C>(name, builder).unwrap();
    }

    private static final class Recursive<T, C extends Codec<T>>
    implements Codec<T> {
        private final String name;
        private final Supplier<C> wrapped;

        private Recursive(String name, Function<Codec<T>, C> builder) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (Codec)builder.apply(this));
        }

        private C unwrap() {
            return (C)((Codec)this.wrapped.get());
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> ops, S input) {
            return ((Codec)this.wrapped.get()).decode(ops, input);
        }

        public <S> DataResult<S> encode(T input, DynamicOps<S> ops, S prefix) {
            return ((Codec)this.wrapped.get()).encode(input, ops, prefix);
        }

        public String toString() {
            return "RecursiveCodec[" + this.name + "]";
        }
    }
}

