/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.Function;

public sealed interface NonNegativeDoublePredicate
extends DoublePredicate {
    public static final MapCodec<Min> MIN_CODEC = Codec.mapEither(Min.Exclusive.CODEC, Min.Inclusive.CODEC).xmap(Either::unwrap, min -> {
        Min min2 = min;
        Objects.requireNonNull(min2);
        Min selector0$temp = min2;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Min.Exclusive.class, Min.Inclusive.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Min.Exclusive exclusive = (Min.Exclusive)selector0$temp;
                yield Either.left((Object)exclusive);
            }
            case 1 -> {
                Min.Inclusive inclusive = (Min.Inclusive)selector0$temp;
                yield Either.right((Object)inclusive);
            }
        };
    });
    public static final MapCodec<Max> MAX_CODEC = Codec.mapEither(Max.Exclusive.CODEC, Max.Inclusive.CODEC).xmap(Either::unwrap, min -> {
        Max max = min;
        Objects.requireNonNull(max);
        Max selector0$temp = max;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Max.Exclusive.class, Max.Inclusive.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Max.Exclusive exclusive = (Max.Exclusive)selector0$temp;
                yield Either.left((Object)exclusive);
            }
            case 1 -> {
                Max.Inclusive inclusive = (Max.Inclusive)selector0$temp;
                yield Either.right((Object)inclusive);
            }
        };
    });
    public static final MapCodec<Direct> DIRECT_CODEC = Codec.mapEither(MIN_CODEC, MAX_CODEC).xmap(Either::unwrap, direct -> {
        Direct direct2 = direct;
        Objects.requireNonNull(direct2);
        Direct selector0$temp = direct2;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Min.class, Max.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Min min = (Min)selector0$temp;
                yield Either.left((Object)min);
            }
            case 1 -> {
                Max max = (Max)selector0$temp;
                yield Either.right((Object)max);
            }
        };
    });
    public static final Codec<NonNegativeDoublePredicate> CODEC = Codec.mapEither(DIRECT_CODEC, Range.CODEC).xmap(Either::unwrap, predicate -> {
        NonNegativeDoublePredicate nonNegativeDoublePredicate = predicate;
        Objects.requireNonNull(nonNegativeDoublePredicate);
        NonNegativeDoublePredicate selector0$temp = nonNegativeDoublePredicate;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Direct.class, Range.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Direct direct = (Direct)selector0$temp;
                yield Either.left((Object)direct);
            }
            case 1 -> {
                Range range = (Range)selector0$temp;
                yield Either.right((Object)range);
            }
        };
    }).codec();

    public boolean testSquare(double var1);

    public static abstract sealed class Direct
    implements NonNegativeDoublePredicate
    permits Min, Max {
        protected final double value;
        private final double squaredValue;

        private static <D extends Direct> MapCodec<D> codecOf(String key, Function<Double, D> factory) {
            return Codec.DOUBLE.validate(value -> value >= 0.0 ? DataResult.success((Object)value) : DataResult.error(() -> "\"%s\" must be non-negative: %s".formatted(key, value))).xmap(factory, Direct::value).fieldOf(key);
        }

        protected Direct(double value) {
            this.value = value;
            this.squaredValue = value * value;
        }

        private double value() {
            return this.value;
        }

        protected abstract boolean compare(double var1, double var3);

        @Override
        public boolean test(double value) {
            return this.compare(this.value, value);
        }

        @Override
        public boolean testSquare(double squaredValue) {
            return this.compare(this.squaredValue, squaredValue);
        }
    }

    public static final class Range
    implements NonNegativeDoublePredicate {
        public static final MapCodec<Range> CODEC = Codec.mapPair((MapCodec)Min.MIN_CODEC, (MapCodec)Max.MAX_CODEC).xmap(minAndMax -> new Range((Min)minAndMax.getFirst(), (Max)minAndMax.getSecond()), range -> Pair.of((Object)range.min, (Object)range.max));
        private final Min min;
        private final Max max;

        @VisibleForTesting
        Range(Min min, Max max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean test(double value) {
            return this.min.test(value) && this.max.test(value);
        }

        @Override
        public boolean testSquare(double squaredValue) {
            return this.min.testSquare(squaredValue) && this.max.testSquare(squaredValue);
        }
    }

    public static abstract sealed class Min
    extends Direct {
        protected Min(double value) {
            super(value);
        }

        public static final class Inclusive
        extends Min {
            private static final String KEY = "inclusive_min";
            public static final MapCodec<Inclusive> CODEC = Direct.codecOf("inclusive_min", Inclusive::new);

            @VisibleForTesting
            Inclusive(double value) {
                super(value);
            }

            @Override
            public boolean compare(double left, double right) {
                return left <= right;
            }
        }

        public static final class Exclusive
        extends Min {
            private static final String KEY = "exclusive_min";
            public static final MapCodec<Exclusive> CODEC = Direct.codecOf("exclusive_min", Exclusive::new);

            @VisibleForTesting
            Exclusive(double value) {
                super(value);
            }

            @Override
            protected boolean compare(double left, double right) {
                return left < right;
            }
        }
    }

    public static abstract sealed class Max
    extends Direct {
        protected Max(double value) {
            super(value);
        }

        public static final class Inclusive
        extends Max {
            private static final String KEY = "inclusive_max";
            public static final MapCodec<Inclusive> CODEC = Direct.codecOf("inclusive_max", Inclusive::new);

            @VisibleForTesting
            Inclusive(double value) {
                super(value);
            }

            @Override
            public boolean compare(double left, double right) {
                return left >= right;
            }
        }

        public static final class Exclusive
        extends Max {
            private static final String KEY = "exclusive_max";
            public static final MapCodec<Exclusive> CODEC = Direct.codecOf("exclusive_max", Exclusive::new);

            @VisibleForTesting
            Exclusive(double value) {
                super(value);
            }

            @Override
            public boolean compare(double left, double right) {
                return left > right;
            }
        }
    }
}

