/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.sssubtlety.anvil_crushing_recipes.util.StringUtil;

public final class NonNegativeIntRange {
    private static final String MIN_KEY = "min";
    private static final String MAX_KEY = "max";
    public static final Codec<NonNegativeIntRange> CODEC = Codec.mapPair((MapCodec)Codec.INT.fieldOf("min"), (MapCodec)Codec.INT.fieldOf("max")).flatXmap(intPair -> NonNegativeIntRange.of((Integer)intPair.getFirst(), (Integer)intPair.getSecond()), range -> DataResult.success((Object)Pair.of((Object)range.min, (Object)range.max))).codec();
    private final int min;
    private final int max;

    public static DataResult<NonNegativeIntRange> of(int min, int max) {
        if (min < 0) {
            return DataResult.error(() -> "\"%s\" must be non-negative: %s".formatted(MIN_KEY, min));
        }
        if (min > max) {
            return DataResult.error(() -> "\"%s\" (%s) must not be greater than \"%s\" (%s)".formatted(MIN_KEY, min, MAX_KEY, max));
        }
        return DataResult.success((Object)new NonNegativeIntRange(min, max));
    }

    public static Optional<NonNegativeIntRange> parse(List<String> strings) {
        int stringsSize = strings.size();
        if (stringsSize < 3) {
            return Optional.empty();
        }
        String firstString = strings.getFirst();
        Optional<Integer> firstParsed = StringUtil.parseSimpleInt(firstString);
        if (firstParsed.isEmpty()) {
            return Optional.empty();
        }
        int first = firstParsed.orElseThrow();
        String lastString = strings.getLast();
        Optional<Integer> lastParsed = StringUtil.parseSimpleInt(lastString);
        if (lastParsed.isEmpty()) {
            return Optional.empty();
        }
        int last = lastParsed.orElseThrow();
        int rangeSize = last - first + 1;
        if (rangeSize != stringsSize) {
            return Optional.empty();
        }
        int prior = first;
        for (String midString : strings.subList(1, stringsSize - 1)) {
            Optional<Integer> parsedMid = StringUtil.parseSimpleInt(midString);
            if (parsedMid.isEmpty()) {
                return Optional.empty();
            }
            int mid = parsedMid.orElseThrow();
            if (++prior == mid) continue;
            return Optional.empty();
        }
        if (prior + 1 != last) {
            return Optional.empty();
        }
        return Optional.of(new NonNegativeIntRange(first, last));
    }

    private NonNegativeIntRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public ImmutableList<String> expandToStrings() {
        return (ImmutableList)IntStream.concat(IntStream.range(this.min, this.max), IntStream.of(this.max)).mapToObj(Integer::toString).collect(ImmutableList.toImmutableList());
    }
}

