/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface Partitioned<I, L, R> {
    public static <I, L, R, P extends Partitioned<I, L, R>> Collector<I, ?, P> collectorOf(Supplier<P> factory) {
        return Collector.of(factory, Partitioned::accumulate, Partitioned::combine, Function.identity(), Collector.Characteristics.IDENTITY_FINISH);
    }

    private static <I, L, R> void accumulate(Partitioned<I, L, R> partitioned, I input) {
        partitioned.partition(input);
    }

    private static <I, L, R, P extends Partitioned<I, L, R>> P combine(P first, P second) {
        first.lefts().addAll(second.lefts());
        first.rights().addAll(second.rights());
        return first;
    }

    public List<L> lefts();

    public List<R> rights();

    public void partition(I var1);
}

