/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2688;
import net.minecraft.class_2769;

public final class StateParser {
    private static final Map<class_2688<?, ?>, ImmutableMap<String, class_2769<?>>> PROPERTIES_BY_NAME_BY_STATE = new IdentityHashMap();
    private static final Map<class_2688<?, ?>, Map<String, Optional<String>>> VALUE_NAMES_BY_PROPERTY_NAME_BY_STATE = new IdentityHashMap();
    private static final Map<class_2769<?>, ImmutableMap<String, Object>> VALUES_BY_NAME_BY_PROPERTY = new IdentityHashMap();
    private static final Map<class_2769<?>, ImmutableMap<Object, String>> VALUE_NAMES_BY_VALUE_BY_PROPERTY = new IdentityHashMap();

    public static <C extends Comparable<C>, O, S extends class_2688<O, S>> Optional<S> withIfExists(S state, class_2769<C> property, Object value) {
        return StateParser.mapTyped(property, value, new WithIfExistent(state));
    }

    public static <C extends Comparable<C>, T> Optional<T> mapTyped(class_2769<C> property, Object value, BiFunction<class_2769<C>, C, T> mapper) {
        Class propertyType = property.method_11902();
        if (propertyType.isAssignableFrom(value.getClass())) {
            Comparable typedValue = (Comparable)propertyType.cast(value);
            if (StateParser.getValueNamesByValue(property).containsKey((Object)typedValue)) {
                return Optional.of(mapper.apply(property, typedValue));
            }
        }
        return Optional.empty();
    }

    public static Optional<class_2769<?>> getProperty(class_2688<?, ?> state, String propertyName) {
        return Optional.ofNullable((class_2769)StateParser.getPropertiesByName(state).get((Object)propertyName));
    }

    public static Optional<Object> getValue(class_2769<?> property, String valueName) {
        return Optional.ofNullable(StateParser.getValuesByName(property).get((Object)valueName));
    }

    public static boolean stateHas(class_2688<?, ?> state, String propertyName, Collection<String> allowedValueNames) {
        return StateParser.getValueName(state, propertyName).filter(allowedValueNames::contains).isPresent();
    }

    public static Optional<String> getValueName(class_2769<?> property, Object value) {
        return Optional.ofNullable((String)StateParser.getValueNamesByValue(property).get(value));
    }

    private static Optional<String> getValueName(class_2688<?, ?> state, String propertyName) {
        Map valueNameByPropertyName = VALUE_NAMES_BY_PROPERTY_NAME_BY_STATE.computeIfAbsent(state, unused -> new HashMap());
        return valueNameByPropertyName.computeIfAbsent(propertyName, unused -> Optional.ofNullable((class_2769)StateParser.getPropertiesByName(state).get((Object)propertyName)).flatMap(property -> StateParser.getValueName(state, property)));
    }

    private static <C extends Comparable<C>> Optional<String> getValueName(class_2688<?, ?> state, class_2769<C> property) {
        return state.method_28500(property).map(arg_0 -> property.method_11901(arg_0));
    }

    private static ImmutableMap<String, class_2769<?>> getPropertiesByName(class_2688<?, ?> state) {
        return PROPERTIES_BY_NAME_BY_STATE.computeIfAbsent(state, StateParser::getPropertiesByNameImpl);
    }

    private static ImmutableMap<String, class_2769<?>> getPropertiesByNameImpl(class_2688<?, ?> state) {
        return (ImmutableMap)state.method_28501().stream().collect(ImmutableMap.toImmutableMap(class_2769::method_11899, Function.identity()));
    }

    private static <C extends Comparable<C>> ImmutableMap<String, Object> getValuesByName(class_2769<C> property) {
        return VALUES_BY_NAME_BY_PROPERTY.computeIfAbsent(property, StateParser::getValuesByNameImpl);
    }

    private static <C extends Comparable<C>> ImmutableMap<String, Object> getValuesByNameImpl(class_2769<C> property) {
        return (ImmutableMap)property.method_11898().stream().collect(ImmutableMap.toImmutableMap(arg_0 -> property.method_11901(arg_0), Function.identity()));
    }

    private static <C extends Comparable<C>> ImmutableMap<Object, String> getValueNamesByValue(class_2769<C> property) {
        return VALUE_NAMES_BY_VALUE_BY_PROPERTY.computeIfAbsent(property, StateParser::getValueNamesByValueImpl);
    }

    private static <C extends Comparable<C>> ImmutableMap<Object, String> getValueNamesByValueImpl(class_2769<C> property) {
        return (ImmutableMap)property.method_11898().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> property.method_11901(arg_0)));
    }

    private record WithIfExistent<C extends Comparable<C>, O, S extends class_2688<O, S>>(S state) implements BiFunction<class_2769<C>, C, S>
    {
        @Override
        public S apply(class_2769<C> property, C value) {
            return (S)((class_2688)this.state.method_47968(property, value));
        }
    }
}

