/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3545;
import org.apache.commons.lang3.mutable.MutableInt;

@Environment(value=EnvType.CLIENT)
public final class TextUtil {
    public static final String DOT_NAMESPACE_DOT = ".anvil_crushing_recipes.";
    public static final class_2561 ELLIPSES = class_2561.method_43471((String)"text.anvil_crushing_recipes.ellipses");
    private static final ImmutableSet<Character> PREFERRED_SPLIT_CHARS = ImmutableSet.of((Object)Character.valueOf('_'), (Object)Character.valueOf('-'));
    private static final int APPROX_CHAR_WIDTH = class_310.method_1551().field_1772.method_1727("_");

    private TextUtil() {
    }

    public static String fuzzyWrappedSentence(String sentence, int width) {
        return TextUtil.wrapWords(TextUtil.splitSentence(sentence), width);
    }

    private static LinkedList<String> splitSentence(String sentence) {
        return Arrays.stream(sentence.split("((?= ))")).collect(Collectors.toCollection(LinkedList::new));
    }

    public static String fuzzyWrapWords(LinkedList<String> words, int maxWidth) {
        return TextUtil.wrapWords(words, maxWidth);
    }

    private static String wrapWords(List<String> words, int maxWidth) {
        return TextUtil.wrapWordsImpl(words, maxWidth, TextUtil::splitWord);
    }

    private static String wrapWordsImpl(List<String> words, int maxWidth, BiFunction<String, Integer, class_3545<String, String>> wordSplitter) {
        StringBuilder lines = new StringBuilder();
        if (maxWidth <= APPROX_CHAR_WIDTH * 2) {
            for (String word : words) {
                lines.append(word).append("\n");
            }
            lines.deleteCharAt(lines.length() - 1);
            return lines.toString();
        }
        MutableInt curLineLen = new MutableInt(0);
        while (!words.isEmpty()) {
            lines.append(TextUtil.popNextWord(words, maxWidth, curLineLen, wordSplitter));
        }
        return lines.toString();
    }

    private static class_3545<String, String> splitWord(String word, int width) {
        int iBreak;
        class_3545<String, String> simpleSplit = TextUtil.simpleSplitWord(word, width);
        String remainder = (String)simpleSplit.method_15441();
        if (remainder.isEmpty()) {
            return simpleSplit;
        }
        String truncatedWord = (String)simpleSplit.method_15442();
        for (iBreak = truncatedWord.length() - 1; iBreak > 0; --iBreak) {
            if (!PREFERRED_SPLIT_CHARS.contains((Object)Character.valueOf(truncatedWord.charAt(iBreak)))) continue;
            ++iBreak;
            break;
        }
        if (iBreak == 0) {
            return simpleSplit;
        }
        return new class_3545((Object)truncatedWord.substring(0, iBreak), (Object)(truncatedWord.substring(iBreak) + remainder));
    }

    private static class_3545<String, String> simpleSplitWord(String word, int width) {
        if (class_310.method_1551().field_1772.method_1727(word) <= width) {
            return new class_3545((Object)word, (Object)"");
        }
        int split = width / APPROX_CHAR_WIDTH;
        String truncatedWord = word.substring(0, split);
        int approxWidth = class_310.method_1551().field_1772.method_1727(truncatedWord);
        if (approxWidth != width) {
            if (approxWidth > width) {
                while (split > 0 && class_310.method_1551().field_1772.method_1727(truncatedWord = word.substring(0, --split)) > width) {
                }
            } else {
                int truncWordLen;
                do {
                    if ((truncWordLen = class_310.method_1551().field_1772.method_1727(truncatedWord = word.substring(0, ++split))) < width) continue;
                    truncatedWord = truncatedWord.substring(0, --split);
                    break;
                } while (split <= truncWordLen);
            }
        }
        return new class_3545((Object)truncatedWord, (Object)word.substring(split));
    }

    private static String popNextWord(List<String> words, int maxWidth, MutableInt curLineLen, BiFunction<String, Integer, class_3545<String, String>> wordSplitter) {
        String nextWord = words.removeFirst();
        int wordLen = class_310.method_1551().field_1772.method_1727(nextWord);
        if (curLineLen.getValue() + wordLen <= maxWidth) {
            curLineLen.add(wordLen);
            return nextWord;
        }
        Object firstWordInLine = TextUtil.getWithoutLeadingSpace(nextWord);
        if (curLineLen.getValue() != 0) {
            firstWordInLine = "\n" + (String)firstWordInLine;
            curLineLen.setValue(0);
            if (wordLen <= maxWidth) {
                curLineLen.add(wordLen);
                return firstWordInLine;
            }
        }
        class_3545<String, String> splitWord = wordSplitter.apply((String)firstWordInLine, maxWidth);
        words.addFirst((String)splitWord.method_15441());
        return (String)splitWord.method_15442() + "\n";
    }

    private static String getWithoutLeadingSpace(String string) {
        if (string.charAt(0) == ' ') {
            string = string.substring(1);
        }
        return string;
    }

    public static String wrappedIdString(class_2960 id, int maxWidth) {
        String idString = id.toString();
        if (class_310.method_1551().field_1772.method_1727(idString) > maxWidth) {
            LinkedList<String> idPieces = new LinkedList<String>();
            idPieces.add(id.method_12836() + ":");
            idPieces.addAll(Arrays.asList(id.method_12832().split("((?<=/))")));
            idString = TextUtil.fuzzyWrapWords(idPieces, maxWidth);
        }
        return idString;
    }

    public static class_2561 truncatedIdText(class_2960 id, int maxWidth) {
        Object idString = id.toString();
        if (class_310.method_1551().field_1772.method_1727((String)idString) > maxWidth && class_310.method_1551().field_1772.method_1727((String)(idString = ELLIPSES.getString() + ":" + id.method_12832())) > maxWidth) {
            int lastSlashPos = ((String)idString).lastIndexOf(47);
            if (lastSlashPos != -1) {
                idString = ELLIPSES.getString() + ((String)idString).substring(lastSlashPos);
            }
            idString = TextUtil.getConstrainedString((String)idString, maxWidth);
        }
        return class_2561.method_30163((String)idString);
    }

    private static String getConstrainedString(String string, int maxWidth) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (textRenderer.method_1727((String)string) > maxWidth) {
            int length = ((String)string).length();
            while (textRenderer.method_1727((String)string + ELLIPSES.getString()) > maxWidth && length > 0) {
                string = ((String)string).substring(0, --length);
            }
            string = (String)string + ELLIPSES.getString();
        }
        return string;
    }
}

