/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import net.minecraft.class_9275;
import org.jetbrains.annotations.Nullable;

public final class Util {
    private Util() {
    }

    public static boolean isEmptyState(class_2680 state) {
        return state.method_26215() || state.method_26204() instanceof class_2404;
    }

    public static int ceilDiv(int dividend, int divisor) {
        return (int)Math.ceil((float)dividend / (float)divisor);
    }

    public static int greaterHalf(int value) {
        return Util.ceilDiv(value, 2);
    }

    public static boolean rollChance(float chance, class_5819 random) {
        return chance > 0.0f && (chance >= 1.0f || random.method_43057() < chance);
    }

    @SafeVarargs
    public static <T> ImmutableList<T> concatImmutable(Collection<T> collection, T ... elements) {
        return (ImmutableList)Util.streamConcat(collection, elements).collect(ImmutableList.toImmutableList());
    }

    @SafeVarargs
    public static <T> ImmutableList<T> concatImmutable(Collection<T> ... collections) {
        return (ImmutableList)Util.streamConcat(collections).collect(ImmutableList.toImmutableList());
    }

    @SafeVarargs
    public static <T> Stream<T> streamConcat(Collection<T> collection, T ... elements) {
        return Util.streamConcat(new Collection[]{collection, List.of(elements)});
    }

    @SafeVarargs
    public static <T> Stream<T> streamConcat(Collection<T> ... collections) {
        return Arrays.stream(collections).flatMap(Collection::stream);
    }

    public static class_9275 toComponent(@Nullable class_2680 state, ImmutableMap<String, String> propertyOverrides) {
        if (state == null && propertyOverrides.isEmpty()) {
            return class_9275.field_49284;
        }
        Stream<Map.Entry<String, String>> allEntries = Util.getEntryStream(state, propertyOverrides);
        return new class_9275(allEntries.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (stateValue, overrideValue) -> overrideValue)));
    }

    private static Stream<Map.Entry<String, String>> getEntryStream(@Nullable class_2680 state, ImmutableMap<String, String> propertyOverrides) {
        Stream overrideEntries = propertyOverrides.entrySet().stream();
        if (state == null) {
            return overrideEntries;
        }
        Stream<Map.Entry> stateEntries = state.method_28501().stream().map(property -> Map.entry(property.method_11899(), Util.getValueName(property, state)));
        return Stream.concat(stateEntries, overrideEntries);
    }

    private static <T extends Comparable<T>> String getValueName(class_2769<T> property, class_2680 state) {
        Comparable value = state.method_11654(property);
        return property.method_11901(value);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableMap<K, V>> entriesToImmutableMap() {
        return ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static final class MaxInt {
        private int max;

        public MaxInt(int initialValue) {
            this.max = initialValue;
        }

        public void update(int value) {
            if (value > this.max) {
                this.max = value;
            }
        }

        public int get() {
            return this.max;
        }
    }
}

