/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;

public interface ValueBacked<T> {
    public static <T, V extends ValueBacked<T>> Codec<V> codecOf(String name, Function<T, V> factory, Codec<T> valueCodec) {
        return ValueBacked.mapCodecOf(name, factory, valueCodec).codec();
    }

    public static <T, V extends ValueBacked<T>> MapCodec<V> mapCodecOf(String name, Function<T, V> factory, Codec<T> listCodec) {
        return ValueBacked.flatCodecOf(factory, listCodec).fieldOf(name);
    }

    public static <T, V extends ValueBacked<T>> Codec<V> flatCodecOf(Function<T, V> factory, Codec<T> listCodec) {
        return listCodec.xmap(factory, ValueBacked::value);
    }

    public T value();

    public static interface MultisetValue<T>
    extends ValueBacked<ImmutableMultiset<T>> {
        public ImmutableMultiset<T> multiset();

        @Override
        default public ImmutableMultiset<T> value() {
            return this.multiset();
        }
    }

    public static interface MapValue<T>
    extends ValueBacked<ImmutableMap<String, T>> {
        public ImmutableMap<String, T> map();

        @Override
        default public ImmutableMap<String, T> value() {
            return this.map();
        }
    }

    public static interface ListValue<T>
    extends ValueBacked<ImmutableList<T>> {
        public ImmutableList<T> list();

        @Override
        default public ImmutableList<T> value() {
            return this.list();
        }
    }
}

