/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.ValueBacked;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.AndMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.CachedMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NbtMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NotMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.OrMatcher;
import org.jetbrains.annotations.Nullable;

sealed interface CompoundImpl
extends NbtMatcher.CompoundMatcher {
    public static Codec<NbtMatcher.CompoundMatcher> codecOf(Codec<ImmutableMap<String, NbtMatcher<?>>> mapCodec) {
        return CodecImpl.of(mapCodec);
    }

    public static boolean matches(class_2487 compound, ImmutableMap<String, NbtMatcher<?>> matchers, BiPredicate<Stream<Map.Entry<String, NbtMatcher<?>>>, Predicate<Map.Entry<String, NbtMatcher<?>>>> predicate) {
        return predicate.test(matchers.entrySet().stream(), entry -> ((NbtMatcher)entry.getValue()).matchesElement(compound.method_10580((String)entry.getKey())));
    }

    @Override
    default public boolean shouldCache() {
        return true;
    }

    @Override
    default public boolean matchesElement(@Nullable class_2520 element) {
        class_2487 compound;
        return element instanceof class_2487 && this.matches(compound = (class_2487)element);
    }

    public static final class CodecImpl
    implements Codec<NbtMatcher.CompoundMatcher> {
        private static final String TYPE_NAME = "CompoundMatcher";
        public final Codec<Empty> empty;
        public final Codec<Any> any;
        public final Codec<Literal> literal;
        public final Codec<Exact> exact;
        public final Codec<AllEntries> allEntries;
        public final Codec<AnyEntries> anyEntries;
        public final Codec<And> and;
        public final Codec<Or> or;
        public final Codec<Not> not;
        private final ImmutableList<Codec<? extends NbtMatcher.CompoundMatcher>> codecs;

        private static CodecImpl of(Codec<ImmutableMap<String, NbtMatcher<?>>> matcherMapCodec) {
            return CodecUtil.recursive(TYPE_NAME, compoundCodec -> CodecImpl.build(matcherMapCodec, (Codec<NbtMatcher.CompoundMatcher>)compoundCodec));
        }

        private static CodecImpl build(Codec<ImmutableMap<String, NbtMatcher<?>>> matcherMapCodec, Codec<NbtMatcher.CompoundMatcher> compoundCodec) {
            Codec<ImmutableList<NbtMatcher.CompoundMatcher>> compoundListCodec = CodecUtil.immutableListOf(compoundCodec);
            return new CodecImpl(Empty.CODEC, Any.CODEC, Literal.CODEC, Exact.codecOf(matcherMapCodec), AllEntries.codecOf(matcherMapCodec), AnyEntries.codecOf(matcherMapCodec), And.codecOf(compoundListCodec), Or.codecOf(compoundListCodec), Not.codecOf(compoundCodec));
        }

        private CodecImpl(Codec<Empty> empty, Codec<Any> any, Codec<Literal> literal, Codec<Exact> exact, Codec<AllEntries> allEntries, Codec<AnyEntries> anyEntries, Codec<And> and, Codec<Or> or, Codec<Not> not) {
            this.empty = empty;
            this.any = any;
            this.literal = literal;
            this.exact = exact;
            this.allEntries = allEntries;
            this.anyEntries = anyEntries;
            this.and = and;
            this.or = or;
            this.not = not;
            this.codecs = ImmutableList.of(empty, any, literal, exact, allEntries, anyEntries, and, or);
        }

        public <T> DataResult<Pair<NbtMatcher.CompoundMatcher, T>> decode(DynamicOps<T> ops, T input) {
            return CodecUtil.findSuccess(ops, input, this.codecs, "Failed to parse CompoundMatcher. ");
        }

        public <T> DataResult<T> encode(NbtMatcher.CompoundMatcher input, DynamicOps<T> ops, T prefix) {
            NbtMatcher.CompoundMatcher compoundMatcher = input;
            Objects.requireNonNull(compoundMatcher);
            NbtMatcher.CompoundMatcher compoundMatcher2 = compoundMatcher;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Empty.class, Any.class, Literal.class, Exact.class, AllEntries.class, AnyEntries.class, And.class, Or.class, Not.class, Cached.class}, (Object)compoundMatcher2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Empty empty = (Empty)compoundMatcher2;
                    yield this.empty.encode((Object)empty, ops, prefix);
                }
                case 1 -> {
                    Any any = (Any)compoundMatcher2;
                    yield this.any.encode((Object)any, ops, prefix);
                }
                case 2 -> {
                    Literal literal = (Literal)compoundMatcher2;
                    yield this.literal.encode((Object)literal, ops, prefix);
                }
                case 3 -> {
                    Exact exact = (Exact)compoundMatcher2;
                    yield this.exact.encode((Object)exact, ops, prefix);
                }
                case 4 -> {
                    AllEntries all = (AllEntries)compoundMatcher2;
                    yield this.allEntries.encode((Object)all, ops, prefix);
                }
                case 5 -> {
                    AnyEntries any = (AnyEntries)compoundMatcher2;
                    yield this.anyEntries.encode((Object)any, ops, prefix);
                }
                case 6 -> {
                    And and = (And)compoundMatcher2;
                    yield this.and.encode((Object)and, ops, prefix);
                }
                case 7 -> {
                    Or or = (Or)compoundMatcher2;
                    yield this.or.encode((Object)or, ops, prefix);
                }
                case 8 -> {
                    Not not = (Not)compoundMatcher2;
                    yield this.not.encode((Object)not, ops, prefix);
                }
                case 9 -> {
                    Cached cached = (Cached)compoundMatcher2;
                    yield this.encode((NbtMatcher.CompoundMatcher)cached.matcher(), ops, prefix);
                }
            };
        }
    }

    public static final class Cached
    extends CachedMatcher.Typed<class_2487, NbtMatcher.CompoundMatcher>
    implements CompoundImpl {
        Cached(NbtMatcher.CompoundMatcher matcher) {
            super(matcher);
        }
    }

    public static final class Not
    extends NotMatcher<class_2487, NbtMatcher.CompoundMatcher>
    implements CompoundImpl {
        static Codec<Not> codecOf(Codec<NbtMatcher.CompoundMatcher> codec) {
            return NotMatcher.codecOf(codec, Not::new);
        }

        Not(NbtMatcher.CompoundMatcher matcher) {
            super(matcher);
        }
    }

    public record Or(ImmutableList<NbtMatcher.CompoundMatcher> list) implements CompoundImpl,
    OrMatcher<class_2487, NbtMatcher.CompoundMatcher>
    {
        public static final String NAME = "or_compounds";

        static Codec<Or> codecOf(Codec<ImmutableList<NbtMatcher.CompoundMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, Or::new, listCodec);
        }
    }

    public record And(ImmutableList<NbtMatcher.CompoundMatcher> list) implements CompoundImpl,
    AndMatcher<class_2487, NbtMatcher.CompoundMatcher>
    {
        public static final String NAME = "and_compounds";

        static Codec<And> codecOf(Codec<ImmutableList<NbtMatcher.CompoundMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, And::new, listCodec);
        }
    }

    public record AnyEntries(ImmutableMap<String, NbtMatcher<?>> map) implements CompoundImpl,
    ValueBacked.MapValue<NbtMatcher<?>>
    {
        public static final String NAME = "any_compound_entries";

        static Codec<AnyEntries> codecOf(Codec<ImmutableMap<String, NbtMatcher<?>>> mapCodec) {
            return ValueBacked.codecOf(NAME, AnyEntries::new, mapCodec);
        }

        @Override
        public boolean matches(class_2487 compound) {
            return CompoundImpl.matches(compound, this.map(), Stream::anyMatch);
        }
    }

    public record AllEntries(ImmutableMap<String, NbtMatcher<?>> map) implements CompoundImpl,
    ValueBacked.MapValue<NbtMatcher<?>>
    {
        public static final String NAME = "all_compound_entries";

        static Codec<AllEntries> codecOf(Codec<ImmutableMap<String, NbtMatcher<?>>> mapCodec) {
            return ValueBacked.codecOf(NAME, AllEntries::new, mapCodec);
        }

        @Override
        public boolean matches(class_2487 compound) {
            return this.map().size() <= compound.method_10546() && CompoundImpl.matches(compound, this.map(), Stream::allMatch);
        }
    }

    public record Exact(ImmutableMap<String, NbtMatcher<?>> map) implements CompoundImpl,
    ValueBacked.MapValue<NbtMatcher<?>>
    {
        public static final String NAME = "exact_compound";

        static Codec<Exact> codecOf(Codec<ImmutableMap<String, NbtMatcher<?>>> mapCodec) {
            return ValueBacked.codecOf(NAME, Exact::new, mapCodec);
        }

        @Override
        public boolean matches(class_2487 compound) {
            return this.map().size() == compound.method_10546() && CompoundImpl.matches(compound, this.map(), Stream::allMatch);
        }
    }

    public record Literal(class_2487 value) implements CompoundImpl
    {
        public static final String NAME = "literal_compound";
        public static final Codec<Literal> CODEC = class_2487.field_25128.xmap(Literal::new, Literal::value).fieldOf("literal_compound").codec();

        @Override
        public boolean matches(class_2487 compound) {
            return this.value.equals((Object)compound);
        }
    }

    public static final class Any
    implements CompoundImpl {
        public static final String NAME = "any_compound";
        public static final Any INSTANCE = new Any();
        public static final Codec<Any> CODEC = Codec.unit((Object)INSTANCE).fieldOf("any_compound").codec();

        private Any() {
        }

        @Override
        public boolean shouldCache() {
            return false;
        }

        @Override
        public boolean matches(class_2487 nbt) {
            return true;
        }
    }

    public static final class Empty
    implements CompoundImpl {
        public static final String NAME = "empty_compound";
        public static final Empty INSTANCE = new Empty();
        public static final Codec<Empty> CODEC = Codec.unit((Object)INSTANCE).fieldOf("empty_compound").codec();

        private Empty() {
        }

        @Override
        public boolean shouldCache() {
            return false;
        }

        @Override
        public boolean matches(class_2487 nbt) {
            return nbt.method_33133();
        }
    }
}

