/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_2520;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.ValueBacked;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NbtMatcher;
import org.jetbrains.annotations.Nullable;

sealed interface ElementMatcher
extends NbtMatcher<class_2520> {
    public static Codec<ElementMatcher> codecOf(Codec<NbtMatcher<?>> codec, Codec<ImmutableList<NbtMatcher<?>>> listCodec) {
        return CodecImpl.of(codec, listCodec);
    }

    @Override
    default public boolean shouldCache() {
        return true;
    }

    @Override
    default public boolean matchesElement(@Nullable class_2520 element) {
        return element != null && this.matches(element);
    }

    public static final class CodecImpl
    implements Codec<ElementMatcher> {
        private static final String TYPE_NAME = "ElementMatcher";
        public final Codec<Any> any;
        public final Codec<And> and;
        public final Codec<Or> or;
        public final Codec<Not> not;
        private final ImmutableList<Codec<? extends ElementMatcher>> codecs;

        private static CodecImpl of(Codec<NbtMatcher<?>> codec, Codec<ImmutableList<NbtMatcher<?>>> listCodec) {
            return new CodecImpl(Any.CODEC, And.codecOf(listCodec), Or.codecOf(listCodec), Not.codecOf(codec));
        }

        public CodecImpl(Codec<Any> any, Codec<And> and, Codec<Or> or, Codec<Not> not) {
            this.any = any;
            this.and = and;
            this.or = or;
            this.not = not;
            this.codecs = ImmutableList.of(any, and, or, not);
        }

        public <T> DataResult<Pair<ElementMatcher, T>> decode(DynamicOps<T> ops, T input) {
            return CodecUtil.findSuccess(ops, input, this.codecs, "Failed to parse ElementMatcher. ");
        }

        public <T> DataResult<T> encode(ElementMatcher input, DynamicOps<T> ops, T prefix) {
            ElementMatcher elementMatcher = input;
            Objects.requireNonNull(elementMatcher);
            ElementMatcher elementMatcher2 = elementMatcher;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Any.class, And.class, Or.class, Not.class}, (Object)elementMatcher2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Any any = (Any)elementMatcher2;
                    yield this.any.encode((Object)any, ops, prefix);
                }
                case 1 -> {
                    And and = (And)elementMatcher2;
                    yield this.and.encode((Object)and, ops, prefix);
                }
                case 2 -> {
                    Or or = (Or)elementMatcher2;
                    yield this.or.encode((Object)or, ops, prefix);
                }
                case 3 -> {
                    Not not = (Not)elementMatcher2;
                    yield this.not.encode((Object)not, ops, prefix);
                }
            };
        }
    }

    public static final class Not
    extends Record
    implements ElementMatcher,
    ValueBacked<NbtMatcher<?>> {
        private final NbtMatcher<?> value;

        public Not(NbtMatcher<?> value) {
            this.value = value;
        }

        private static Codec<Not> codecOf(Codec<NbtMatcher<?>> codec) {
            return ValueBacked.codecOf("not", Not::new, codec);
        }

        @Override
        public boolean matches(class_2520 nbt) {
            return !this.value.matchesElement(nbt);
        }

        @Override
        public boolean shouldCache() {
            return this.value.shouldCache();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Not.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Not.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Not.class, "value", "value"}, this, o);
        }

        @Override
        public NbtMatcher<?> value() {
            return this.value;
        }
    }

    public record Or(ImmutableList<NbtMatcher<?>> list) implements ElementMatcher,
    ValueBacked.ListValue<NbtMatcher<?>>
    {
        public static final String NAME = "or_elements";

        static Codec<Or> codecOf(Codec<ImmutableList<NbtMatcher<?>>> listCodec) {
            return ValueBacked.codecOf(NAME, Or::new, listCodec);
        }

        @Override
        public boolean matches(class_2520 nbt) {
            for (NbtMatcher matcher : this.list) {
                if (!matcher.matchesElement(nbt)) continue;
                return true;
            }
            return false;
        }
    }

    public record And(ImmutableList<NbtMatcher<?>> list) implements ElementMatcher,
    ValueBacked.ListValue<NbtMatcher<?>>
    {
        public static final String NAME = "and_elements";

        static Codec<And> codecOf(Codec<ImmutableList<NbtMatcher<?>>> listCodec) {
            return ValueBacked.codecOf(NAME, And::new, listCodec);
        }

        @Override
        public boolean matches(class_2520 nbt) {
            for (NbtMatcher matcher : this.list) {
                if (matcher.matchesElement(nbt)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Any
    implements ElementMatcher {
        public static final String NAME = "any_element";
        public static final Any INSTANCE = new Any();
        public static Codec<Any> CODEC = Codec.unit((Object)INSTANCE).fieldOf("any_element").codec();

        private Any() {
        }

        @Override
        public boolean shouldCache() {
            return false;
        }

        @Override
        public boolean matches(class_2520 nbt) {
            return true;
        }
    }
}

