/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.class_2483;
import net.minecraft.class_2520;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.ValueBacked;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.AndMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.CachedMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NbtMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NotMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.OrMatcher;
import org.jetbrains.annotations.Nullable;

sealed interface ListImpl
extends NbtMatcher.ListMatcher {
    public static Codec<NbtMatcher.ListMatcher> codecOf(Codec<ImmutableList<NbtMatcher<?>>> listCodec, Codec<ImmutableMultiset<NbtMatcher<?>>> multisetCodec) {
        return CodecImpl.of(listCodec, multisetCodec);
    }

    public static boolean allMatch(class_2483 list, ImmutableMultiset<NbtMatcher<?>> matchers) {
        ArrayList elements = Lists.newArrayList((Iterable)list);
        block0: for (NbtMatcher matcher : matchers) {
            Iterator elementItr = elements.iterator();
            while (elementItr.hasNext()) {
                if (!matcher.matchesElement((class_2520)elementItr.next())) continue;
                elementItr.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    default public boolean shouldCache() {
        return true;
    }

    @Override
    default public boolean matchesElement(@Nullable class_2520 element) {
        class_2483 list;
        return element instanceof class_2483 && this.matches(list = (class_2483)element);
    }

    @Override
    public boolean matches(class_2483 var1);

    public static final class CodecImpl
    implements Codec<NbtMatcher.ListMatcher> {
        private static final String TYPE_NAME = "ListMatcher";
        public final Codec<Empty> empty;
        public final Codec<Any> any;
        public final Codec<Literal> literal;
        public final Codec<AnyElements> anyElements;
        public final Codec<ExactOrdered> exactOrdered;
        public final Codec<AllOrdered> allOrdered;
        public final Codec<ExactUnordered> exactUnordered;
        public final Codec<AllUnordered> allUnordered;
        public final Codec<And> and;
        public final Codec<Or> or;
        public final Codec<Not> not;
        private final ImmutableList<Codec<? extends NbtMatcher.ListMatcher>> codecs;

        private static CodecImpl of(Codec<ImmutableList<NbtMatcher<?>>> listCodec, Codec<ImmutableMultiset<NbtMatcher<?>>> multisetCodec) {
            return CodecUtil.recursive(TYPE_NAME, codec -> CodecImpl.build((Codec<NbtMatcher.ListMatcher>)codec, listCodec, multisetCodec));
        }

        private static CodecImpl build(Codec<NbtMatcher.ListMatcher> listMatcherCodec, Codec<ImmutableList<NbtMatcher<?>>> matcherListCodec, Codec<ImmutableMultiset<NbtMatcher<?>>> matcherMultisetCodec) {
            Codec<ImmutableList<NbtMatcher.ListMatcher>> listMatcherListCodec = CodecUtil.immutableListOf(listMatcherCodec);
            return new CodecImpl(Empty.CODEC, Any.CODEC, Literal.CODEC, AnyElements.codecOf(matcherListCodec), ExactOrdered.codecOf(matcherListCodec), AllOrdered.codecOf(matcherListCodec), ExactUnordered.codecOf(matcherMultisetCodec), AllUnordered.codecOf(matcherMultisetCodec), And.codecOf(listMatcherListCodec), Or.codecOf(listMatcherListCodec), Not.codecOf(listMatcherCodec));
        }

        private CodecImpl(Codec<Empty> empty, Codec<Any> any, Codec<Literal> literal, Codec<AnyElements> anyElements, Codec<ExactOrdered> exactOrdered, Codec<AllOrdered> allOrdered, Codec<ExactUnordered> exactUnordered, Codec<AllUnordered> allUnordered, Codec<And> and, Codec<Or> or, Codec<Not> not) {
            this.empty = empty;
            this.any = any;
            this.literal = literal;
            this.anyElements = anyElements;
            this.exactOrdered = exactOrdered;
            this.allOrdered = allOrdered;
            this.exactUnordered = exactUnordered;
            this.allUnordered = allUnordered;
            this.and = and;
            this.or = or;
            this.not = not;
            this.codecs = ImmutableList.of(empty, any, literal, anyElements, exactOrdered, allOrdered, exactUnordered, allUnordered, and, or, not);
        }

        public <T> DataResult<Pair<NbtMatcher.ListMatcher, T>> decode(DynamicOps<T> ops, T input) {
            return CodecUtil.findSuccess(ops, input, this.codecs, "Failed to parse ListMatcher. ");
        }

        public <T> DataResult<T> encode(NbtMatcher.ListMatcher input, DynamicOps<T> ops, T prefix) {
            NbtMatcher.ListMatcher listMatcher = input;
            Objects.requireNonNull(listMatcher);
            NbtMatcher.ListMatcher listMatcher2 = listMatcher;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Empty.class, Any.class, Literal.class, AnyElements.class, AllOrdered.class, AllUnordered.class, ExactOrdered.class, ExactUnordered.class, And.class, Or.class, Not.class, Cached.class}, (Object)listMatcher2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Empty empty = (Empty)listMatcher2;
                    yield this.empty.encode((Object)empty, ops, prefix);
                }
                case 1 -> {
                    Any any = (Any)listMatcher2;
                    yield this.any.encode((Object)any, ops, prefix);
                }
                case 2 -> {
                    Literal literal = (Literal)listMatcher2;
                    yield this.literal.encode((Object)literal, ops, prefix);
                }
                case 3 -> {
                    AnyElements anyElements = (AnyElements)listMatcher2;
                    yield this.anyElements.encode((Object)anyElements, ops, prefix);
                }
                case 4 -> {
                    AllOrdered allOrdered = (AllOrdered)listMatcher2;
                    yield this.allOrdered.encode((Object)allOrdered, ops, prefix);
                }
                case 5 -> {
                    AllUnordered allUnordered = (AllUnordered)listMatcher2;
                    yield this.allUnordered.encode((Object)allUnordered, ops, prefix);
                }
                case 6 -> {
                    ExactOrdered exactOrdered = (ExactOrdered)listMatcher2;
                    yield this.exactOrdered.encode((Object)exactOrdered, ops, prefix);
                }
                case 7 -> {
                    ExactUnordered exactUnordered = (ExactUnordered)listMatcher2;
                    yield this.exactUnordered.encode((Object)exactUnordered, ops, prefix);
                }
                case 8 -> {
                    And and = (And)listMatcher2;
                    yield this.and.encode((Object)and, ops, prefix);
                }
                case 9 -> {
                    Or or = (Or)listMatcher2;
                    yield this.or.encode((Object)or, ops, prefix);
                }
                case 10 -> {
                    Not not = (Not)listMatcher2;
                    yield this.not.encode((Object)not, ops, prefix);
                }
                case 11 -> {
                    Cached cached = (Cached)listMatcher2;
                    yield this.encode((NbtMatcher.ListMatcher)cached.matcher(), ops, prefix);
                }
            };
        }
    }

    public static final class Cached
    extends CachedMatcher.Typed<class_2483, NbtMatcher.ListMatcher>
    implements ListImpl {
        Cached(NbtMatcher.ListMatcher matcher) {
            super(matcher);
        }
    }

    public static final class Not
    extends NotMatcher<class_2483, NbtMatcher.ListMatcher>
    implements ListImpl {
        private static Codec<Not> codecOf(Codec<NbtMatcher.ListMatcher> codec) {
            return NotMatcher.codecOf(codec, Not::new);
        }

        Not(NbtMatcher.ListMatcher matcher) {
            super(matcher);
        }
    }

    public record Or(ImmutableList<NbtMatcher.ListMatcher> list) implements ListImpl,
    OrMatcher<class_2483, NbtMatcher.ListMatcher>
    {
        public static final String NAME = "or_lists";

        static Codec<Or> codecOf(Codec<ImmutableList<NbtMatcher.ListMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, Or::new, listCodec);
        }

        @Override
        public boolean matches(class_2483 nbt) {
            return OrMatcher.super.matches(nbt);
        }
    }

    public record And(ImmutableList<NbtMatcher.ListMatcher> list) implements ListImpl,
    AndMatcher<class_2483, NbtMatcher.ListMatcher>
    {
        public static final String NAME = "and_lists";

        static Codec<And> codecOf(Codec<ImmutableList<NbtMatcher.ListMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, And::new, listCodec);
        }

        @Override
        public boolean matches(class_2483 nbt) {
            return AndMatcher.super.matches(nbt);
        }
    }

    public record ExactUnordered(ImmutableMultiset<NbtMatcher<?>> multiset) implements ListImpl,
    ValueBacked.MultisetValue<NbtMatcher<?>>
    {
        public static final String NAME = "exact_unordered_list_elements";

        private static Codec<ExactUnordered> codecOf(Codec<ImmutableMultiset<NbtMatcher<?>>> multisetCodec) {
            return ValueBacked.codecOf(NAME, ExactUnordered::new, multisetCodec);
        }

        @Override
        public boolean matches(class_2483 list) {
            if (list.size() == this.multiset.size()) {
                return ListImpl.allMatch(list, this.multiset);
            }
            return false;
        }
    }

    public record AllUnordered(ImmutableMultiset<NbtMatcher<?>> multiset) implements ListImpl,
    ValueBacked.MultisetValue<NbtMatcher<?>>
    {
        public static final String NAME = "all_unordered_list_elements";

        private static Codec<AllUnordered> codecOf(Codec<ImmutableMultiset<NbtMatcher<?>>> multisetCodec) {
            return ValueBacked.codecOf(NAME, AllUnordered::new, multisetCodec);
        }

        @Override
        public boolean matches(class_2483 list) {
            if (list.size() < this.multiset.size()) {
                return false;
            }
            return ListImpl.allMatch(list, this.multiset);
        }
    }

    public record AllOrdered(ImmutableList<NbtMatcher<?>> list) implements ListImpl,
    ValueBacked.ListValue<NbtMatcher<?>>
    {
        public static final String NAME = "all_ordered_list_elements";

        private static Codec<AllOrdered> codecOf(Codec<ImmutableList<NbtMatcher<?>>> listCodec) {
            return ValueBacked.codecOf(NAME, AllOrdered::new, listCodec);
        }

        @Override
        public boolean matches(class_2483 list) {
            if (this.list.size() > list.size()) {
                return false;
            }
            Iterator nbtItr = list.iterator();
            block0: for (NbtMatcher matcher : this.list) {
                while (nbtItr.hasNext()) {
                    if (!matcher.matchesElement((class_2520)nbtItr.next())) continue;
                    continue block0;
                }
                return false;
            }
            return true;
        }
    }

    public record ExactOrdered(ImmutableList<NbtMatcher<?>> list) implements ListImpl,
    ValueBacked.ListValue<NbtMatcher<?>>
    {
        public static final String NAME = "exact_ordered_list_elements";

        private static Codec<ExactOrdered> codecOf(Codec<ImmutableList<NbtMatcher<?>>> listCodec) {
            return ValueBacked.codecOf(NAME, ExactOrdered::new, listCodec);
        }

        @Override
        public boolean matches(class_2483 list) {
            int size = this.list.size();
            if (size == list.size()) {
                for (int i = 0; i < size; ++i) {
                    if (((NbtMatcher)this.list.get(i)).matchesElement(list.method_10534(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public record AnyElements(ImmutableList<NbtMatcher<?>> list) implements ListImpl,
    ValueBacked.ListValue<NbtMatcher<?>>
    {
        public static final String NAME = "any_list_elements";

        private static Codec<AnyElements> codecOf(Codec<ImmutableList<NbtMatcher<?>>> listCodec) {
            return ValueBacked.codecOf(NAME, AnyElements::new, listCodec);
        }

        @Override
        public boolean matches(class_2483 list) {
            for (NbtMatcher matcher : this.list) {
                for (class_2520 element : list) {
                    if (!matcher.matchesElement(element)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public record Literal(class_2483 value) implements ListImpl
    {
        public static final String NAME = "literal_list";
        public static final Codec<Literal> CODEC = CodecUtil.NBT_LIST_CODEC.xmap(Literal::new, Literal::value).fieldOf("literal_list").codec();

        @Override
        public boolean matches(class_2483 list) {
            return this.value.equals((Object)list);
        }
    }

    public static final class Any
    implements ListImpl {
        public static String NAME = "any_list";
        public static final Any INSTANCE = new Any();
        public static final Codec<Any> CODEC = Codec.unit((Object)INSTANCE).fieldOf(NAME).codec();

        private Any() {
        }

        @Override
        public boolean shouldCache() {
            return false;
        }

        @Override
        public boolean matches(class_2483 nbt) {
            return true;
        }
    }

    public static final class Empty
    implements ListImpl {
        public static String NAME = "empty_list";
        public static final Empty INSTANCE = new Empty();
        public static Codec<Empty> CODEC = Codec.unit((Object)INSTANCE).fieldOf(NAME).codec();

        private Empty() {
        }

        @Override
        public boolean shouldCache() {
            return false;
        }

        @Override
        public boolean matches(class_2483 nbt) {
            return nbt.isEmpty();
        }
    }
}

