/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.AndMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.CachedMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.CompoundImpl;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.ElementMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.ListImpl;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NbtMatcherCodec;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NotMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NullMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NumberImpl;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.OrMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.StringImpl;
import org.jetbrains.annotations.Nullable;

public sealed interface NbtMatcher<N extends class_2520>
permits CachedMatcher, ElementMatcher, AndMatcher, OrMatcher, NotMatcher, NullMatcher, NumberMatcher, StringMatcher, CompoundMatcher, ListMatcher {
    public static final String NAME = "nbt_matcher";
    public static final Codec<NbtMatcher<?>> CODEC = NbtMatcherCodec.INSTANCE;
    public static final Codec<NullMatcher> NULL_CODEC = NullMatcher.CODEC;
    public static final Codec<NumberMatcher> NUMBER_CODEC = NbtMatcherCodec.INSTANCE.number;
    public static final Codec<StringMatcher> STRING_CODEC = NbtMatcherCodec.INSTANCE.string;
    public static final Codec<CompoundMatcher> COMPOUND_CODEC = NbtMatcherCodec.INSTANCE.compound;
    public static final Codec<ListMatcher> LIST_CODEC = NbtMatcherCodec.INSTANCE.list;

    public static NbtMatcher<class_2491> nill() {
        return NullMatcher.INSTANCE;
    }

    public static NbtMatcher<?> cached(NbtMatcher<?> matcher) {
        return matcher.shouldCache() ? new CachedMatcher.Element(matcher) : matcher;
    }

    public static CompoundMatcher cached(CompoundMatcher matcher) {
        return matcher.shouldCache() ? new CompoundImpl.Cached(matcher) : matcher;
    }

    public static ListMatcher cached(ListMatcher matcher) {
        return matcher.shouldCache() ? new ListImpl.Cached(matcher) : matcher;
    }

    public static StringMatcher cached(StringMatcher matcher) {
        return matcher.shouldCache() ? new StringImpl.Cached(matcher) : matcher;
    }

    public static NumberMatcher cached(NumberMatcher matcher) {
        return matcher.shouldCache() ? new NumberImpl.Cached(matcher) : matcher;
    }

    public static NbtMatcher<?> any() {
        return ElementMatcher.Any.INSTANCE;
    }

    public static NbtMatcher<?> not(NbtMatcher<?> matcher) {
        return new ElementMatcher.Not(matcher);
    }

    public static CompoundMatcher not(CompoundMatcher matcher) {
        return new CompoundImpl.Not(matcher);
    }

    public static ListMatcher not(ListMatcher matcher) {
        return new ListImpl.Not(matcher);
    }

    public static StringMatcher not(StringMatcher matcher) {
        return new StringImpl.Not(matcher);
    }

    public static NumberMatcher not(NumberMatcher matcher) {
        return new NumberImpl.Not(matcher);
    }

    public static NbtMatcher<?> and(Iterable<NbtMatcher<?>> matchers) {
        return new ElementMatcher.And(ImmutableList.copyOf(matchers));
    }

    public static NbtMatcher<?> or(Iterable<NbtMatcher<?>> matchers) {
        return new ElementMatcher.Or(ImmutableList.copyOf(matchers));
    }

    public static NumberMatcher anyNumber() {
        return NumberImpl.Any.INSTANCE;
    }

    public static NumberMatcher exactNumber(double value) {
        return new NumberImpl.Exact(value);
    }

    public static NumberMatcher inclusiveMin(double min) {
        return new NumberImpl.Min.Inclusive(min);
    }

    public static NumberMatcher exclusiveMin(double min) {
        return new NumberImpl.Min.Exclusive(min);
    }

    public static NumberMatcher inclusiveMax(double min) {
        return new NumberImpl.Max.Inclusive(min);
    }

    public static NumberMatcher exclusiveMax(double min) {
        return new NumberImpl.Max.Exclusive(min);
    }

    public static NumberMatcher inclusiveRange(double min, double max) {
        return new NumberImpl.Range(new NumberImpl.Min.Inclusive(min), new NumberImpl.Max.Inclusive(max));
    }

    public static NumberMatcher exclusiveMaxRange(double min, double max) {
        return new NumberImpl.Range(new NumberImpl.Min.Inclusive(min), new NumberImpl.Max.Exclusive(max));
    }

    public static NumberMatcher exclusiveMinRange(double min, double max) {
        return new NumberImpl.Range(new NumberImpl.Min.Exclusive(min), new NumberImpl.Max.Inclusive(max));
    }

    public static NumberMatcher exclusiveRange(double min, double max) {
        return new NumberImpl.Range(new NumberImpl.Min.Exclusive(min), new NumberImpl.Max.Exclusive(max));
    }

    public static NumberMatcher andNumbers(Iterable<NumberMatcher> matchers) {
        return new NumberImpl.And((ImmutableList<NumberMatcher>)ImmutableList.copyOf(matchers));
    }

    public static NumberMatcher orNumbers(Iterable<NumberMatcher> matchers) {
        return new NumberImpl.Or((ImmutableList<NumberMatcher>)ImmutableList.copyOf(matchers));
    }

    public static StringMatcher anyString() {
        return StringImpl.Any.INSTANCE;
    }

    public static StringMatcher exactString(String string) {
        return new StringImpl.Exact(string);
    }

    public static StringMatcher containsString(String string) {
        return new StringImpl.Contains(string);
    }

    public static StringMatcher regex(Pattern pattern) {
        return new StringImpl.Regex(pattern);
    }

    public static StringMatcher andStrings(Iterable<StringMatcher> matchers) {
        return new StringImpl.And((ImmutableList<StringMatcher>)ImmutableList.copyOf(matchers));
    }

    public static StringMatcher orStrings(Iterable<StringMatcher> matchers) {
        return new StringImpl.Or((ImmutableList<StringMatcher>)ImmutableList.copyOf(matchers));
    }

    public static CompoundMatcher emptyCompound() {
        return CompoundImpl.Empty.INSTANCE;
    }

    public static CompoundMatcher anyCompound() {
        return CompoundImpl.Any.INSTANCE;
    }

    public static CompoundMatcher literalCompound(class_2487 compound) {
        return new CompoundImpl.Literal(compound);
    }

    public static CompoundMatcher allCompoundEntries(Map<String, NbtMatcher<?>> values) {
        return new CompoundImpl.AllEntries(ImmutableMap.copyOf(values));
    }

    public static CompoundMatcher anyCompoundEntries(Map<String, NbtMatcher<?>> values) {
        return new CompoundImpl.AnyEntries(ImmutableMap.copyOf(values));
    }

    public static CompoundMatcher exactCompound(Map<String, NbtMatcher<?>> values) {
        return new CompoundImpl.Exact(ImmutableMap.copyOf(values));
    }

    public static CompoundMatcher andCompounds(Iterable<CompoundMatcher> matchers) {
        return new CompoundImpl.And((ImmutableList<CompoundMatcher>)ImmutableList.copyOf(matchers));
    }

    public static CompoundMatcher orCompounds(Iterable<CompoundMatcher> matchers) {
        return new CompoundImpl.Or((ImmutableList<CompoundMatcher>)ImmutableList.copyOf(matchers));
    }

    public static ListMatcher anyListElements(Iterable<NbtMatcher<?>> matchers) {
        return new ListImpl.AnyElements(ImmutableList.copyOf(matchers));
    }

    public static ListMatcher allOrderedListElements(Iterable<NbtMatcher<?>> matchers) {
        return new ListImpl.AllOrdered(ImmutableList.copyOf(matchers));
    }

    public static ListMatcher allUnorderedListElements(Iterable<NbtMatcher<?>> matchers) {
        return new ListImpl.AllUnordered(ImmutableMultiset.copyOf(matchers));
    }

    public static ListMatcher exactOrderedListElements(Iterable<NbtMatcher<?>> matchers) {
        return new ListImpl.ExactOrdered(ImmutableList.copyOf(matchers));
    }

    public static ListMatcher exactUnorderedListElements(Iterable<NbtMatcher<?>> matchers) {
        return new ListImpl.ExactUnordered(ImmutableMultiset.copyOf(matchers));
    }

    public static ListMatcher emptyList() {
        return ListImpl.Empty.INSTANCE;
    }

    public static ListMatcher anyList() {
        return ListImpl.Any.INSTANCE;
    }

    public static ListMatcher literalList(class_2483 list) {
        return new ListImpl.Literal(list);
    }

    public static ListMatcher andLists(Iterable<ListMatcher> matchers) {
        return new ListImpl.And((ImmutableList<ListMatcher>)ImmutableList.copyOf(matchers));
    }

    public static ListMatcher orLists(Iterable<ListMatcher> matchers) {
        return new ListImpl.Or((ImmutableList<ListMatcher>)ImmutableList.copyOf(matchers));
    }

    public boolean shouldCache();

    public boolean matches(N var1);

    public boolean matchesElement(@Nullable class_2520 var1);

    public static sealed interface CompoundMatcher
    extends NbtMatcher<class_2487>
    permits CompoundImpl {
    }

    public static sealed interface ListMatcher
    extends NbtMatcher<class_2483>
    permits ListImpl {
    }

    public static sealed interface StringMatcher
    extends NbtMatcher<class_2519>
    permits StringImpl {
    }

    public static sealed interface NumberMatcher
    extends NbtMatcher<class_2514>
    permits NumberImpl {
    }
}

