/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.ValueBacked;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.AndMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.CachedMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NbtMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NotMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.OrMatcher;
import org.jetbrains.annotations.Nullable;

sealed interface NumberImpl
extends NbtMatcher.NumberMatcher {
    public static final Codec<NbtMatcher.NumberMatcher> CODEC = CodecImpl.INSTANCE;

    @Override
    default public boolean shouldCache() {
        return false;
    }

    @Override
    default public boolean matchesElement(@Nullable class_2520 element) {
        class_2514 nbtNumber;
        return element instanceof class_2514 && this.matches(nbtNumber = (class_2514)element);
    }

    public static final class CodecImpl
    implements Codec<NbtMatcher.NumberMatcher> {
        private static final String TYPE_NAME = "NumberMatcher";
        private static final CodecImpl INSTANCE = CodecUtil.recursive("NumberMatcher", CodecImpl::build);
        private final Codec<Any> any;
        private final Codec<Exact> exact;
        private final Codec<Min> min;
        private final Codec<Max> max;
        private final Codec<Range> range;
        private final Codec<And> and;
        private final Codec<Or> or;
        private final Codec<Not> not;
        private final ImmutableList<Codec<? extends NbtMatcher.NumberMatcher>> codecs;

        private static CodecImpl build(Codec<NbtMatcher.NumberMatcher> codec) {
            Codec<ImmutableList<NbtMatcher.NumberMatcher>> listCodec = CodecUtil.immutableListOf(codec);
            return new CodecImpl(Any.CODEC, Exact.CODEC, Min.CODEC, Max.CODEC, Range.CODEC, And.codecOf(listCodec), Or.codecOf(listCodec), Not.codecOf(codec));
        }

        private CodecImpl(Codec<Any> any, Codec<Exact> exact, Codec<Min> min, Codec<Max> max, Codec<Range> range, Codec<And> and, Codec<Or> or, Codec<Not> not) {
            this.any = any;
            this.exact = exact;
            this.min = min;
            this.max = max;
            this.range = range;
            this.and = and;
            this.or = or;
            this.not = not;
            this.codecs = ImmutableList.of(any, exact, min, max, range, and, or, not);
        }

        public <T> DataResult<Pair<NbtMatcher.NumberMatcher, T>> decode(DynamicOps<T> ops, T input) {
            return CodecUtil.findSuccess(ops, input, this.codecs, "Failed to parse NumberMatcher. ");
        }

        public <T> DataResult<T> encode(NbtMatcher.NumberMatcher input, DynamicOps<T> ops, T prefix) {
            NbtMatcher.NumberMatcher numberMatcher = input;
            Objects.requireNonNull(numberMatcher);
            NbtMatcher.NumberMatcher numberMatcher2 = numberMatcher;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Any.class, Exact.class, Min.class, Max.class, Range.class, And.class, Or.class, Not.class, Cached.class}, (Object)numberMatcher2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Any any = (Any)numberMatcher2;
                    yield this.any.encode((Object)any, ops, prefix);
                }
                case 1 -> {
                    Exact exact = (Exact)numberMatcher2;
                    yield this.exact.encode((Object)exact, ops, prefix);
                }
                case 2 -> {
                    Min min = (Min)numberMatcher2;
                    yield this.min.encode((Object)min, ops, prefix);
                }
                case 3 -> {
                    Max max = (Max)numberMatcher2;
                    yield this.max.encode((Object)max, ops, prefix);
                }
                case 4 -> {
                    Range range = (Range)numberMatcher2;
                    yield this.range.encode((Object)range, ops, prefix);
                }
                case 5 -> {
                    And and = (And)numberMatcher2;
                    yield this.and.encode((Object)and, ops, prefix);
                }
                case 6 -> {
                    Or or = (Or)numberMatcher2;
                    yield this.or.encode((Object)or, ops, prefix);
                }
                case 7 -> {
                    Not not = (Not)numberMatcher2;
                    yield this.not.encode((Object)not, ops, prefix);
                }
                case 8 -> {
                    Cached cached = (Cached)numberMatcher2;
                    yield this.encode((NbtMatcher.NumberMatcher)cached.matcher(), ops, prefix);
                }
            };
        }
    }

    public static final class Cached
    extends CachedMatcher.Typed<class_2514, NbtMatcher.NumberMatcher>
    implements NumberImpl {
        Cached(NbtMatcher.NumberMatcher matcher) {
            super(matcher);
        }
    }

    public static final class Not
    extends NotMatcher<class_2514, NbtMatcher.NumberMatcher>
    implements NumberImpl {
        private static Codec<Not> codecOf(Codec<NbtMatcher.NumberMatcher> codec) {
            return NotMatcher.codecOf(codec, Not::new);
        }

        Not(NbtMatcher.NumberMatcher value) {
            super(value);
        }
    }

    public record Or(ImmutableList<NbtMatcher.NumberMatcher> list) implements NumberImpl,
    OrMatcher<class_2514, NbtMatcher.NumberMatcher>
    {
        public static final String NAME = "or_numbers";

        static Codec<Or> codecOf(Codec<ImmutableList<NbtMatcher.NumberMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, Or::new, listCodec);
        }

        @Override
        public boolean shouldCache() {
            return true;
        }
    }

    public record And(ImmutableList<NbtMatcher.NumberMatcher> list) implements NumberImpl,
    AndMatcher<class_2514, NbtMatcher.NumberMatcher>
    {
        public static final String NAME = "and_numbers";

        static Codec<And> codecOf(Codec<ImmutableList<NbtMatcher.NumberMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, And::new, listCodec);
        }

        @Override
        public boolean shouldCache() {
            return true;
        }
    }

    public record Range(Min min, Max max) implements Direct
    {
        public static final String NAME = "range";
        public static final MapCodec<Range> MAP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Min.MAP_CODEC.forGetter(Range::min), (App)Max.MAP_CODEC.forGetter(Range::max)).apply((Applicative)instance, Range::new)).validate(range -> {
            Double minValue = (Double)range.min.value();
            Double maxValue = (Double)range.max.value();
            return minValue >= maxValue ? DataResult.error(() -> "min (%s) must be less than max (%s)".formatted(minValue, maxValue)) : DataResult.success((Object)range);
        }).fieldOf("range");
        public static final Codec<Range> CODEC = MAP_CODEC.codec();

        @Override
        public boolean matches(double number) {
            return this.min.matches(number) && this.max.matches(number);
        }

        @Override
        public boolean matches(class_2514 nbt) {
            return this.min.matches(nbt) && this.max.matches(nbt);
        }
    }

    public static sealed interface Max
    extends Direct,
    ValueBacked<Double> {
        public static final MapCodec<Max> MAP_CODEC = Codec.mapEither(Inclusive.MAP_CODEC, Exclusive.MAP_CODEC).xmap(Either::unwrap, max -> {
            Max max2 = max;
            Objects.requireNonNull(max2);
            Max selector0$temp = max2;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Inclusive.class, Exclusive.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Inclusive inclusive = (Inclusive)selector0$temp;
                    yield Either.left((Object)inclusive);
                }
                case 1 -> {
                    Exclusive exclusive = (Exclusive)selector0$temp;
                    yield Either.right((Object)exclusive);
                }
            };
        });
        public static final Codec<Max> CODEC = MAP_CODEC.codec();

        public static final class Inclusive
        extends Record
        implements Max {
            private final Double value;
            public static final String NAME = "inclusive_max";
            public static final MapCodec<Inclusive> MAP_CODEC = ValueBacked.mapCodecOf("inclusive_max", Inclusive::new, Codec.DOUBLE);
            public static final Codec<Inclusive> CODEC = MAP_CODEC.codec();

            public Inclusive(Double value) {
                this.value = value;
            }

            @Override
            public boolean matches(double number) {
                return number <= this.value;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Inclusive.class, "value", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Inclusive.class, "value", "value"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Inclusive.class, "value", "value"}, this, o);
            }

            @Override
            public Double value() {
                return this.value;
            }
        }

        public static final class Exclusive
        extends Record
        implements Max {
            private final Double value;
            public static final String NAME = "exclusive_max";
            public static final MapCodec<Exclusive> MAP_CODEC = ValueBacked.mapCodecOf("exclusive_max", Exclusive::new, Codec.DOUBLE);
            public static final Codec<Exclusive> CODEC = MAP_CODEC.codec();

            public Exclusive(Double value) {
                this.value = value;
            }

            @Override
            public boolean matches(double number) {
                return number < this.value;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Exclusive.class, "value", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Exclusive.class, "value", "value"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Exclusive.class, "value", "value"}, this, o);
            }

            @Override
            public Double value() {
                return this.value;
            }
        }
    }

    public static sealed interface Min
    extends Direct,
    ValueBacked<Double> {
        public static final MapCodec<Min> MAP_CODEC = Codec.mapEither(Inclusive.MAP_CODEC, Exclusive.MAP_CODEC).xmap(Either::unwrap, min -> {
            Min min2 = min;
            Objects.requireNonNull(min2);
            Min selector0$temp = min2;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Inclusive.class, Exclusive.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Inclusive inclusive = (Inclusive)selector0$temp;
                    yield Either.left((Object)inclusive);
                }
                case 1 -> {
                    Exclusive exclusive = (Exclusive)selector0$temp;
                    yield Either.right((Object)exclusive);
                }
            };
        });
        public static final Codec<Min> CODEC = MAP_CODEC.codec();

        public static final class Inclusive
        extends Record
        implements Min {
            private final Double value;
            public static final String NAME = "inclusive_min";
            public static final MapCodec<Inclusive> MAP_CODEC = ValueBacked.mapCodecOf("inclusive_min", Inclusive::new, Codec.DOUBLE);
            public static final Codec<Inclusive> CODEC = MAP_CODEC.codec();

            public Inclusive(Double value) {
                this.value = value;
            }

            @Override
            public boolean matches(double number) {
                return number >= this.value;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Inclusive.class, "value", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Inclusive.class, "value", "value"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Inclusive.class, "value", "value"}, this, o);
            }

            @Override
            public Double value() {
                return this.value;
            }
        }

        public static final class Exclusive
        extends Record
        implements Min {
            private final Double value;
            public static final String NAME = "exclusive_min";
            public static final MapCodec<Exclusive> MAP_CODEC = ValueBacked.mapCodecOf("exclusive_min", Exclusive::new, Codec.DOUBLE);
            public static final Codec<Exclusive> CODEC = MAP_CODEC.codec();

            public Exclusive(Double value) {
                this.value = value;
            }

            @Override
            public boolean matches(double number) {
                return number > this.value;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Exclusive.class, "value", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Exclusive.class, "value", "value"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Exclusive.class, "value", "value"}, this, o);
            }

            @Override
            public Double value() {
                return this.value;
            }
        }
    }

    public static final class Exact
    extends Record
    implements Direct,
    ValueBacked<Double> {
        private final Double value;
        public static final String NAME = "exact_number";
        public static final Codec<Exact> CODEC = ValueBacked.codecOf("exact_number", Exact::new, Codec.DOUBLE);

        public Exact(Double value) {
            this.value = value;
        }

        @Override
        public boolean matches(double number) {
            return number == this.value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Exact.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Exact.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Exact.class, "value", "value"}, this, o);
        }

        @Override
        public Double value() {
            return this.value;
        }
    }

    public static sealed interface Direct
    extends NumberImpl
    permits Exact, Min, Max, Range {
        @Override
        public boolean matches(double var1);

        @Override
        default public boolean matches(class_2514 number) {
            return this.matches(number.method_10697());
        }
    }

    public static final class Any
    implements NumberImpl {
        public static final String NAME = "any_number";
        public static final Any INSTANCE = new Any();
        public static final Codec<Any> CODEC = Codec.unit((Object)INSTANCE).fieldOf("any_number").codec();

        private Any() {
        }

        @Override
        public boolean matches(class_2514 nbt) {
            return true;
        }
    }
}

