/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5699;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.ValueBacked;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.AndMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.CachedMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NbtMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.NotMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.nbt.OrMatcher;
import org.jetbrains.annotations.Nullable;

sealed interface StringImpl
extends NbtMatcher.StringMatcher {
    public static final Codec<NbtMatcher.StringMatcher> CODEC = CodecImpl.INSTANCE;

    @Override
    default public boolean shouldCache() {
        return true;
    }

    @Override
    default public boolean matchesElement(@Nullable class_2520 element) {
        class_2519 string;
        return element instanceof class_2519 && this.matches(string = (class_2519)element);
    }

    public static final class CodecImpl
    implements Codec<NbtMatcher.StringMatcher> {
        private static final String TYPE_NAME = "StringMatcher";
        private static final CodecImpl INSTANCE = CodecUtil.recursive("StringMatcher", CodecImpl::build);
        public final Codec<Any> any;
        public final Codec<Exact> exact;
        public final Codec<Contains> contains;
        public final Codec<Regex> regex;
        public final Codec<And> and;
        public final Codec<Or> or;
        public final Codec<Not> not;
        private final ImmutableList<Codec<? extends NbtMatcher.StringMatcher>> codecs;

        private static CodecImpl build(Codec<NbtMatcher.StringMatcher> codec) {
            Codec<ImmutableList<NbtMatcher.StringMatcher>> listCodec = CodecUtil.immutableListOf(codec);
            return new CodecImpl(Any.CODEC, Exact.CODEC, Contains.CODEC, Regex.CODEC, And.codecOf(listCodec), Or.codecOf(listCodec), Not.codecOf(codec));
        }

        private CodecImpl(Codec<Any> any, Codec<Exact> exact, Codec<Contains> contains, Codec<Regex> regex, Codec<And> and, Codec<Or> or, Codec<Not> not) {
            this.any = any;
            this.exact = exact;
            this.contains = contains;
            this.regex = regex;
            this.and = and;
            this.or = or;
            this.not = not;
            this.codecs = ImmutableList.of(any, exact, contains, regex, and, or, not);
        }

        public <T> DataResult<Pair<NbtMatcher.StringMatcher, T>> decode(DynamicOps<T> ops, T input) {
            return CodecUtil.findSuccess(ops, input, this.codecs, "Failed to parse StringMatcher. ");
        }

        public <T> DataResult<T> encode(NbtMatcher.StringMatcher input, DynamicOps<T> ops, T prefix) {
            NbtMatcher.StringMatcher stringMatcher = input;
            Objects.requireNonNull(stringMatcher);
            NbtMatcher.StringMatcher stringMatcher2 = stringMatcher;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Any.class, Exact.class, Contains.class, Regex.class, And.class, Or.class, Not.class, Cached.class}, (Object)stringMatcher2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Any any = (Any)stringMatcher2;
                    yield this.any.encode((Object)any, ops, prefix);
                }
                case 1 -> {
                    Exact exact = (Exact)stringMatcher2;
                    yield this.exact.encode((Object)exact, ops, prefix);
                }
                case 2 -> {
                    Contains contains = (Contains)stringMatcher2;
                    yield this.contains.encode((Object)contains, ops, prefix);
                }
                case 3 -> {
                    Regex regex = (Regex)stringMatcher2;
                    yield this.regex.encode((Object)regex, ops, prefix);
                }
                case 4 -> {
                    And and = (And)stringMatcher2;
                    yield this.and.encode((Object)and, ops, prefix);
                }
                case 5 -> {
                    Or or = (Or)stringMatcher2;
                    yield this.or.encode((Object)or, ops, prefix);
                }
                case 6 -> {
                    Not not = (Not)stringMatcher2;
                    yield this.not.encode((Object)not, ops, prefix);
                }
                case 7 -> {
                    Cached cached = (Cached)stringMatcher2;
                    yield this.encode((NbtMatcher.StringMatcher)cached.matcher(), ops, prefix);
                }
            };
        }
    }

    public static final class Cached
    extends CachedMatcher.Typed<class_2519, NbtMatcher.StringMatcher>
    implements StringImpl {
        Cached(NbtMatcher.StringMatcher matcher) {
            super(matcher);
        }
    }

    public static final class Not
    extends NotMatcher<class_2519, NbtMatcher.StringMatcher>
    implements StringImpl {
        private static Codec<Not> codecOf(Codec<NbtMatcher.StringMatcher> codec) {
            return NotMatcher.codecOf(codec, Not::new);
        }

        Not(NbtMatcher.StringMatcher value) {
            super(value);
        }
    }

    public record Or(ImmutableList<NbtMatcher.StringMatcher> list) implements StringImpl,
    OrMatcher<class_2519, NbtMatcher.StringMatcher>
    {
        public static final String NAME = "or_strings";

        static Codec<Or> codecOf(Codec<ImmutableList<NbtMatcher.StringMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, Or::new, listCodec);
        }
    }

    public record And(ImmutableList<NbtMatcher.StringMatcher> list) implements StringImpl,
    AndMatcher<class_2519, NbtMatcher.StringMatcher>
    {
        public static final String NAME = "and_strings";

        static Codec<And> codecOf(Codec<ImmutableList<NbtMatcher.StringMatcher>> listCodec) {
            return ValueBacked.codecOf(NAME, And::new, listCodec);
        }
    }

    public static final class Regex
    extends Record
    implements Direct,
    ValueBacked<Pattern> {
        private final Pattern value;
        public static final String NAME = "regex";
        public static final Codec<Regex> CODEC = ValueBacked.codecOf("regex", Regex::new, CodecUtil.PATTERN_CODEC);

        public Regex(Pattern value) {
            this.value = value;
        }

        @Override
        public boolean matches(String string) {
            return this.value.matcher(string).find();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Regex.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Regex.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Regex.class, "value", "value"}, this, o);
        }

        @Override
        public Pattern value() {
            return this.value;
        }
    }

    public static final class Contains
    extends Record
    implements Direct,
    ValueBacked<String> {
        private final String value;
        public static final String NAME = "string_contains";
        public static final Codec<Contains> CODEC = ValueBacked.codecOf("string_contains", Contains::new, class_5699.field_41759);

        public Contains(String value) {
            this.value = value;
        }

        @Override
        public boolean matches(String string) {
            return string.contains(this.value);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Contains.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Contains.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Contains.class, "value", "value"}, this, o);
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public static final class Exact
    extends Record
    implements Direct,
    ValueBacked<String> {
        private final String value;
        public static final String NAME = "exact_string";
        public static final Codec<Exact> CODEC = ValueBacked.codecOf("exact_string", Exact::new, Codec.STRING);

        public Exact(String value) {
            this.value = value;
        }

        @Override
        public boolean matches(String string) {
            return this.value.equals(string);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Exact.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Exact.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Exact.class, "value", "value"}, this, o);
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public static sealed interface Direct
    extends StringImpl
    permits Exact, Contains, Regex {
        @Override
        default public boolean matches(class_2519 nbt) {
            return this.matches((String)nbt.method_68658().orElseThrow());
        }

        @Override
        public boolean matches(String var1);
    }

    public static final class Any
    implements StringImpl {
        public static final String NAME = "any_string";
        public static final Any INSTANCE = new Any();
        public static final Codec<Any> CODEC = Codec.unit((Object)INSTANCE).fieldOf("any_string").codec();

        private Any() {
        }

        @Override
        public boolean shouldCache() {
            return false;
        }

        @Override
        public boolean matches(class_2519 nbt) {
            return true;
        }
    }
}

