/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.state;

import com.google.common.collect.ImmutableSetMultimap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2688;
import net.minecraft.class_5699;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.NonNegativeIntRange;
import net.sssubtlety.anvil_crushing_recipes.util.StateParser;
import net.sssubtlety.anvil_crushing_recipes.util.ValueBacked;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.StateMatcher;

sealed interface PropertiesMatcher
extends StateMatcher,
ValueBacked<ImmutableSetMultimap<String, String>> {
    public static final Codec<List<String>> STRINGS_OR_RANGE_CODEC = Codec.either(CodecUtil.singleOrList(CodecUtil.PROPERTY_VALUE_CODEC), NonNegativeIntRange.CODEC).xmap(stringsOrRange -> (List)Either.unwrap((Either)stringsOrRange.mapRight(NonNegativeIntRange::expandToStrings)), strings -> NonNegativeIntRange.parse(strings).map(Either::right).orElseGet(() -> Either.left((Object)strings)));
    public static final Codec<ImmutableSetMultimap<String, String>> STRING_MULTIMAP_CODEC = Codec.unboundedMap((Codec)class_5699.field_41759, STRINGS_OR_RANGE_CODEC).xmap(stringListMap -> (ImmutableSetMultimap)stringListMap.entrySet().stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream())), stringsMultimap -> stringsMultimap.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue()))));

    public static <P extends PropertiesMatcher> Codec<P> codecOf(String name, Function<ImmutableSetMultimap<String, String>, P> factory) {
        return ValueBacked.codecOf(name, factory, STRING_MULTIMAP_CODEC);
    }

    public ImmutableSetMultimap<String, String> properties();

    @Override
    default public ImmutableSetMultimap<String, String> value() {
        return this.properties();
    }

    default public boolean matches(class_2688<?, ?> state, BiPredicate<Stream<Map.Entry<String, Collection<String>>>, Predicate<Map.Entry<String, Collection<String>>>> predicate) {
        return predicate.test(this.properties().asMap().entrySet().stream(), propertyValues -> StateParser.stateHas(state, (String)propertyValues.getKey(), (Collection)propertyValues.getValue()));
    }

    public record Any(ImmutableSetMultimap<String, String> properties) implements PropertiesMatcher
    {
        public static final String NAME = "any_properties";
        public static final Codec<Any> CODEC = PropertiesMatcher.codecOf("any_properties", Any::new);

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public boolean matches(class_2688<?, ?> state) {
            return this.matches(state, Stream::anyMatch);
        }
    }

    public record All(ImmutableSetMultimap<String, String> properties) implements PropertiesMatcher
    {
        public static final String NAME = "all_properties";
        public static final Codec<All> CODEC = PropertiesMatcher.codecOf("all_properties", All::new);

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public boolean matches(class_2688<?, ?> state) {
            return this.properties.keySet().size() <= state.method_28501().size() && this.matches(state, Stream::allMatch);
        }
    }

    public record Exact(ImmutableSetMultimap<String, String> properties) implements PropertiesMatcher
    {
        public static final String NAME = "exact_properties";
        public static final Codec<Exact> CODEC = PropertiesMatcher.codecOf("exact_properties", Exact::new);

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public boolean matches(class_2688<?, ?> state) {
            return this.properties.keySet().size() == state.method_28501().size() && this.matches(state, Stream::allMatch);
        }
    }
}

