/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.mojang.serialization.Codec;
import net.minecraft.class_2688;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.AndMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.CachedMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.NotMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.OrMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.PropertiesMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.StateMatcherCodec;

public sealed interface StateMatcher
permits AndMatcher, CachedMatcher, NotMatcher, OrMatcher, PropertiesMatcher {
    public static final String NAME = "state_matcher";
    public static final Codec<StateMatcher> CODEC = StateMatcherCodec.INSTANCE;

    public static StateMatcher not(StateMatcher matcher) {
        return new NotMatcher(matcher);
    }

    public static StateMatcher and(ImmutableList<StateMatcher> matchers) {
        return new AndMatcher(matchers);
    }

    public static StateMatcher or(ImmutableList<StateMatcher> matchers) {
        return new OrMatcher(matchers);
    }

    public static StateMatcher cached(StateMatcher matcher) {
        return CachedMatcher.of(matcher);
    }

    public static StateMatcher allProperties(ImmutableSetMultimap<String, String> properties) {
        return new PropertiesMatcher.All(properties);
    }

    public static StateMatcher anyProperties(ImmutableSetMultimap<String, String> properties) {
        return new PropertiesMatcher.Any(properties);
    }

    public static StateMatcher exactProperties(ImmutableSetMultimap<String, String> properties) {
        return new PropertiesMatcher.Exact(properties);
    }

    public String name();

    public boolean matches(class_2688<?, ?> var1);
}

