/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.anvil_crushing_recipes.util.matcher.state;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.sssubtlety.anvil_crushing_recipes.util.CodecUtil;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.AndMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.CachedMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.NotMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.OrMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.PropertiesCodec;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.PropertiesMatcher;
import net.sssubtlety.anvil_crushing_recipes.util.matcher.state.StateMatcher;

final class StateMatcherCodec
implements Codec<StateMatcher> {
    public static final Codec<StateMatcher> INSTANCE = StateMatcherCodec.create();
    public final Codec<PropertiesMatcher> properties;
    public final Codec<AndMatcher> and;
    public final Codec<NotMatcher> not;
    public final Codec<OrMatcher> or;
    private final ImmutableList<Codec<? extends StateMatcher>> codecs;

    private static Codec<StateMatcher> create() {
        return Codec.recursive((String)"state_matcher", StateMatcherCodec::build);
    }

    private static StateMatcherCodec build(Codec<StateMatcher> matcherCodec) {
        Codec<ImmutableList<StateMatcher>> listCodec = CodecUtil.immutableListOf(matcherCodec);
        return new StateMatcherCodec(AndMatcher.codecOf(listCodec), NotMatcher.codecOf(matcherCodec), OrMatcher.codecOf(listCodec), PropertiesCodec.INSTANCE);
    }

    StateMatcherCodec(Codec<AndMatcher> and, Codec<NotMatcher> not, Codec<OrMatcher> or, Codec<PropertiesMatcher> properties) {
        this.properties = properties;
        this.and = and;
        this.not = not;
        this.or = or;
        this.codecs = ImmutableList.of(this.properties, this.and, this.not, this.or);
    }

    public <T> DataResult<Pair<StateMatcher, T>> decode(DynamicOps<T> ops, T input) {
        return CodecUtil.findSuccess(ops, input, this.codecs, "Failed to parse state_matcher. ");
    }

    public <T> DataResult<T> encode(StateMatcher input, DynamicOps<T> ops, T prefix) {
        StateMatcher stateMatcher = input;
        Objects.requireNonNull(stateMatcher);
        StateMatcher stateMatcher2 = stateMatcher;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PropertiesMatcher.class, CachedMatcher.class, AndMatcher.class, NotMatcher.class, OrMatcher.class}, (Object)stateMatcher2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PropertiesMatcher properties = (PropertiesMatcher)stateMatcher2;
                yield this.properties.encode((Object)properties, ops, prefix);
            }
            case 1 -> {
                CachedMatcher cached = (CachedMatcher)stateMatcher2;
                yield this.encode(cached.matcher(), ops, prefix);
            }
            case 2 -> {
                AndMatcher and = (AndMatcher)stateMatcher2;
                yield this.and.encode((Object)and, ops, prefix);
            }
            case 3 -> {
                NotMatcher not = (NotMatcher)stateMatcher2;
                yield this.not.encode((Object)not, ops, prefix);
            }
            case 4 -> {
                OrMatcher or = (OrMatcher)stateMatcher2;
                yield this.or.encode((Object)or, ops, prefix);
            }
        };
    }
}

