/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.contact.client.gui.screen;

import com.flechazo.contact.client.gui.hud.TexturePos;
import com.flechazo.contact.client.widget.IconButton;
import com.flechazo.contact.common.screenhandler.PostboxScreenHandler;
import com.flechazo.contact.helper.GuiHelper;
import com.flechazo.contact.network.EnquireAddresseeMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;

public class PostboxScreen
extends class_465<PostboxScreenHandler> {
    private static final class_2960 RED_TEXTURE = new class_2960("contact", "textures/gui/red_postbox.png");
    private static final class_2960 GREEN_TEXTURE = new class_2960("contact", "textures/gui/green_postbox.png");
    private final boolean isRed;
    private int offsetX;
    private int offsetY;
    private IconButton buttonSend;
    private class_342 nameField;
    private int selected = 0;

    public PostboxScreen(PostboxScreenHandler screenContainer, class_1661 inv, class_2561 titleIn) {
        super((class_1703)screenContainer, inv, titleIn);
        this.isRed = screenContainer.isRed();
    }

    protected void method_25426() {
        super.method_25426();
        this.offsetX = (this.field_22789 - 176) / 2;
        this.offsetY = (this.field_22790 - 166) / 2 + 16;
        this.buttonSend = (IconButton)this.method_37063((class_364)new IconButton(this.offsetX + 97, this.offsetY + 26, 10, 9, (class_2561)class_2561.method_43471((String)"tooltip.contact.postbox.send"), button -> this.send(), this::buttonTooltip));
        this.nameField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.offsetX + 42, this.offsetY + 26, 44, 9, (class_2561)class_2561.method_43471((String)"info.contact.postbox.addressee")));
        this.nameField.method_1868(-1);
        this.nameField.method_1860(-1);
        this.nameField.method_1852(((PostboxScreenHandler)this.field_2797).playerName);
        this.nameField.method_1863(this::whileTyping);
        this.nameField.method_1858(false);
        this.nameField.method_1880(64);
        this.method_48265((class_364)this.nameField);
    }

    private void buttonTooltip(class_4185 button, class_332 guiGraphics, int mouseX, int mouseY) {
        if (button.method_49606()) {
            GuiHelper.drawTooltip(guiGraphics, mouseX, mouseY, button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364(), Lists.newArrayList((Object[])new class_2561[]{button.method_25369()}));
        }
    }

    private void whileTyping(String name) {
        if (!((PostboxScreenHandler)this.field_2797).playerName.equals(name)) {
            ((PostboxScreenHandler)this.field_2797).playerName = name;
            if (((PostboxScreenHandler)this.field_2797).status == 2) {
                ((PostboxScreenHandler)this.field_2797).status = 1;
            }
            if (((PostboxScreenHandler)this.field_2797).status == 1) {
                EnquireAddresseeMessage packet = EnquireAddresseeMessage.create(((PostboxScreenHandler)this.field_2797).playerName, false);
                packet.sendToServer();
            }
        }
    }

    private void send() {
        if (((PostboxScreenHandler)this.field_2797).status == 1) {
            if (this.isAddresseeValid() && ((PostboxScreenHandler)this.field_2797).ticks.get(0) >= 0) {
                EnquireAddresseeMessage packet = EnquireAddresseeMessage.create(((PostboxScreenHandler)this.field_2797).playerName, true);
                packet.sendToServer();
            }
        } else if (((PostboxScreenHandler)this.field_2797).status == 2) {
            ((PostboxScreenHandler)this.field_2797).status = 0;
        }
        this.nameField.method_25365(false);
    }

    private boolean isAddresseeValid() {
        return !((PostboxScreenHandler)this.field_2797).names.isEmpty() && Objects.equals(this.nameField.method_1882(), ((PostboxScreenHandler)this.field_2797).names.get(0));
    }

    protected void method_37432() {
        super.method_37432();
        this.nameField.method_1865();
        if (((PostboxScreenHandler)this.field_2797).status == 1 && !this.nameField.method_1882().equals(((PostboxScreenHandler)this.field_2797).playerName)) {
            this.nameField.method_1852(((PostboxScreenHandler)this.field_2797).playerName);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (((PostboxScreenHandler)this.field_2797).status == 1 && this.nameField.method_25370()) {
            int size = ((PostboxScreenHandler)this.field_2797).names.size();
            int maxWidth = 55;
            for (int i = 0; i < size; ++i) {
                maxWidth = Math.max(this.field_22793.method_1727(((PostboxScreenHandler)this.field_2797).names.get(i)) + 8, maxWidth);
            }
            if (size != 0 && (double)(this.offsetX + 42) <= mouseX && mouseX < (double)(this.offsetX + 42 + maxWidth) && (double)(this.offsetY + 40 + this.selected * 11) <= mouseY && mouseY < (double)(this.offsetY + 51 + this.selected * 11)) {
                this.nameField.method_1852(((PostboxScreenHandler)this.field_2797).names.get(this.selected));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        boolean flag = false;
        if (((PostboxScreenHandler)this.field_2797).status == 1 && this.nameField.method_25370()) {
            int size = ((PostboxScreenHandler)this.field_2797).names.size();
            int maxWidth = 55;
            for (int i = 0; i < size; ++i) {
                maxWidth = Math.max(this.field_22793.method_1727(((PostboxScreenHandler)this.field_2797).names.get(i)) + 8, maxWidth);
            }
            int z = 5000;
            if (size != 0) {
                class_2960 texture = this.isRed ? RED_TEXTURE : GREEN_TEXTURE;
                int renderWidth = maxWidth;
                if (renderWidth == 55) {
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 36, texture, new TexturePos(176, 18, 55, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 39 + 11 * size, texture, new TexturePos(176, 65, 55, 2));
                } else {
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 36, texture, new TexturePos(176, 18, 15, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 38, this.offsetY + 39 + 11 * size, texture, new TexturePos(176, 65, 15, 2));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 23 + renderWidth, this.offsetY + 36, texture, new TexturePos(216, 18, 15, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 23 + renderWidth, this.offsetY + 39 + 11 * size, texture, new TexturePos(216, 65, 15, 2));
                    renderWidth -= 30;
                    int pos = 0;
                    while (renderWidth > 15) {
                        GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 36, texture, new TexturePos(191, 18, 15, 3 + 11 * size));
                        GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 39 + 11 * size, texture, new TexturePos(191, 65, 15, 2));
                        renderWidth -= 15;
                        pos += 15;
                    }
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 36, texture, new TexturePos(191, 18, renderWidth, 3 + 11 * size));
                    GuiHelper.drawLayer(guiGraphics, this.offsetX + 53 + pos, this.offsetY + 39 + 11 * size, texture, new TexturePos(191, 65, renderWidth, 2));
                }
            }
            for (int i = 0; i < size; ++i) {
                if (this.offsetX + 42 <= mouseX && mouseX < this.offsetX + 42 + maxWidth && this.offsetY + 40 + i * 11 <= mouseY && mouseY < this.offsetY + 51 + i * 11) {
                    this.selected = i;
                    flag = true;
                }
                guiGraphics.method_51433(this.field_22793, ((PostboxScreenHandler)this.field_2797).names.get(i), this.offsetX + 42, this.offsetY + 40 + i * 11, (this.selected == i ? class_124.field_1054.method_532() : class_124.field_1068.method_532()).intValue(), false);
            }
        }
        guiGraphics.method_51448().method_22909();
        if (!flag) {
            this.method_2380(guiGraphics, mouseX, mouseY);
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_2960 texture = this.isRed ? RED_TEXTURE : GREEN_TEXTURE;
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        GuiHelper.drawLayer(guiGraphics.method_51448(), this.offsetX, this.offsetY, new TexturePos(0, 0, 176, 133));
        GuiHelper.renderButton(guiGraphics, partialTicks, x, y, 0, texture, this.buttonSend, new TexturePos(176, 0, 10, 9), new TexturePos(176, 9, 10, 9));
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"info.contact.postbox.addressee"), 40, 30, 0xE6E6E6, false);
        switch (((PostboxScreenHandler)this.field_2797).status) {
            case 0: {
                class_5250 text = class_2561.method_43471((String)"info.contact.postbox.need_mail");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 1: {
                if (this.isAddresseeValid()) {
                    int tick = ((PostboxScreenHandler)this.field_2797).ticks.get(0);
                    if (tick < 0) {
                        class_5250 text = class_2561.method_43471((String)"info.contact.postbox.no_mailbox");
                        this.renderTips(guiGraphics, text);
                        break;
                    }
                    class_5250 text = class_2561.method_43471((String)"info.contact.postbox.estimated");
                    int width = this.field_22793.method_1727(text.getString());
                    int min = tick / 1200;
                    int sec = tick % 1200 / 20;
                    if (width > 38) {
                        guiGraphics.method_51439(this.field_22793, (class_2561)text, 141 - width / 2, 26, 0x1A1A1A, false);
                        if (tick < 20) {
                            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"info.contact.postbox.instant"), 141 - width / 2, 38, 0x1A1A1A, false);
                            break;
                        }
                        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"info.contact.postbox.time", (Object[])new Object[]{min, sec}), 141 - width / 2, 38, 0x1A1A1A, false);
                        break;
                    }
                    guiGraphics.method_51439(this.field_22793, (class_2561)text, 122, 26, 0x1A1A1A, false);
                    if (tick < 20) {
                        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"info.contact.postbox.instant"), 122, 38, 0x1A1A1A, false);
                        break;
                    }
                    guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"info.contact.postbox.time", (Object[])new Object[]{min, sec}), 122, 38, 0x1A1A1A, false);
                    break;
                }
                class_5250 text = class_2561.method_43471((String)"info.contact.postbox.need_addressee");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 2: {
                class_5250 text = class_2561.method_43471((String)"info.contact.postbox.success");
                this.renderTips(guiGraphics, text);
                break;
            }
            case 3: {
                class_5250 text = class_2561.method_43471((String)"info.contact.postbox.cannot_send");
                this.renderTips(guiGraphics, text);
            }
        }
    }

    private void renderTips(class_332 guiGraphics, class_5250 text) {
        int width = this.field_22793.method_1727(text.getString());
        if (width > 38) {
            List list = this.field_22793.method_1728((class_5348)text, 50);
            for (int i = 0; i < list.size(); ++i) {
                guiGraphics.method_51430(this.field_22793, (class_5481)list.get(i), 118, 38 - list.size() * 6 + i * 12, 0x1A1A1A, false);
            }
        } else {
            guiGraphics.method_51439(this.field_22793, (class_2561)text, 122, 32, 0x1A1A1A, false);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
        }
        return this.nameField.method_25404(keyCode, scanCode, modifiers) || this.nameField.method_25370() || super.method_25404(keyCode, scanCode, modifiers);
    }
}

